<?php



	/******************************************\
	* Web Application 4.0 by SCFDuffy (C) 2021 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 4.0 Installer by SCFDuffy - (C)February 2021 *
	\**************************************************************/



	class Application{
		public $homedir,$rooturl,$rootpath,$homeurl,$homepath;
		public $sitename,$mainmail,$automail;
		public $db,$settings,$er,$token,$account;
		
		function logCrack($msg){file_put_contents($this->homedir.'cracks.log',$msg."\n",FILE_APPEND);}
		function automailer($mailto,$subject,$mailbody){mail($mailto,$subject,$mailbody,"From: {$app->automail}\r\n");}
		function setSiteinfo($sitename='',$automail='',$mainmail=''){$this->sitename=$sitename;$this->automail=$automail;$this->mainmail=$mainmail;}
		function encrypt($msg,$key){$mlen=strlen($msg);$klen=strlen($key);$dst=$msg;for ($i=0;$i<$mlen;$i++) $dst[$i]=$msg[$i] ^ $key[$i%$klen];unset($mlen);unset($klen);return $dst;}
		function decrypt($msg,$key){$mlen=strlen($msg);$klen=strlen($key);$dst=$msg;for ($i=0;$i<$mlen;$i++) $dst[$i]=$msg[$i] ^ $key[$i%$klen];unset($mlen);unset($klen);return $dst;}
		function decryptHex($msg,$key){return $this->decrypt(hex2bin($msg),hex2bin($key));}
		function encryptHex($msg,$key){return bin2hex($this->encrypt($msg,hex2bin($key)));}

		function dbInit($dbhost,$dbport,$dbname,$dbuser,$dbpass){
			$this->db=new mysqli($dbhost,$dbuser,$dbpass,$dbname,$dbport);
			if ($this->db->connect_errno===0) return true;
			else{return false;}
		}
		function dbError(){
			if ($this->db->connect_errno!==0) return $this->db->connect_error;
			else if ($this->db->errno!=0) return $this->db->error;
			else return false;
		}
		function addUser($type,$user,$pass,$email='',$einvalid=0,$first='',$last='',$country='',$gender='',$dob=''){
			$time=time();
			$hash=password_hash($pass,PASSWORD_DEFAULT);
			$user=addslashes($user);
			$email=addslashes($email);
			$first=addslashes($first);
			$last=addslashes($last);
			$dob=addslashes($dob);
			$this->db->query("
				insert into users(creation_time,account_type,username,password,email,email_invalid,first_name,last_name,country,gender,dob)
				values($time,'$type','$user','$hash','$email',$einvalid,'$first','$last','$country','$gender','$dob');
			");
			if ($this->dbError()) return false;
			return true;
		}
		function editUser($uuid,$column,$value){
			$value=addslashes($value);
			$this->db->query("update users set $column='$value' where uuid='$uuid';");
		}
		function delUser($uuid){
			$this->db->query("delete from users where uuid='$uuid';");
			if ($this->dbError()) return false;
			return true;
		}
		function getUserByUUID($uuid){
			$response=$this->db->query("select * from users where uuid='$uuid';");
			if ($response->num_rows==0) return false;
			else return $response->fetch_assoc();
		}
		function getUserByEmail($email){
			$email=addslashes($email);
			$response=$this->db->query("select * from users where email='$email';");
			if ($response->num_rows==0) return false;
			else return $response->fetch_assoc();
		}
		function getUser($user){
			$user=addslashes($user);
			$response=$this->db->query("select * from users where username='$user';");
			if ($response->num_rows==0) return false;
			else return $response->fetch_assoc();
		}
		function login($account){
			$strangenumber=md5($account['username'].$account['password'].$account['creation_time']);

			//PHP 7.3+ offers a samesite options by way of an "alternative signature" with an array containing options
			//$cookieOptions=['expires'=>time()+3600*24*30,'path'=>substr($app->homedir,0,-1),'domain'=>'.'.$_SERVER['SERVER_NAME'],'secure'=>false,'httponly'=>true,'samesite'=>'Lax'];
			//setcookie('user',$account['user'],$cookieOptions);
			//setcookie('login',$strangenumber,$cookieOptions);

			setcookie('user',htmlspecialchars($account['username']),time()+3600*24*30,substr($this->homedir,0,-1),'.'.$_SERVER['SERVER_NAME'],false,true);
			setcookie('login',$strangenumber,time()+3600*24*30,substr($this->homedir,0,-1),'.'.$_SERVER['SERVER_NAME'],false,true);
		}
		function logout(){
			$this->account=null;
			setcookie('user','',1,substr($this->homedir,0,-1),'.'.$_SERVER['SERVER_NAME'],false,true);
			setcookie('login','',1,substr($this->homedir,0,-1),'.'.$_SERVER['SERVER_NAME'],false,true);
			Header('Location: '.$_SERVER['REQUEST_URI']);
		}
		function setAccount($user){
			$this->account=null;
			$account=$this->getUser($user);
			if ($account!=false){
				if ($_COOKIE['login']===md5($account['username'].$account['password'].$account['creation_time'])) $this->account=$account;
				else $this->logCrack("In Application::setAccount, login cookie did not match account for user '$user'.");
				if ($this->account!=false) $this->editUser($this->account['uuid'],'last_login',time());
			}
		}

		function __destruct(){
			if ($this->db) $this->db->close();
		}
		function __construct(){
			$this->er=false;

			$me=$_SERVER['SCRIPT_NAME'];
			$aPos=strrpos($me,'main'); if ($aPos===false) $aPos=strrpos($me,'/')+1;
			$this->homedir=substr($me,0,$aPos);unset($aPos);unset($me);
			$this->rooturl='http'.(isset($_SERVER['HTTPS'])? 's://':'://').$_SERVER['SERVER_NAME'];
			$this->rootpath=$_SERVER['DOCUMENT_ROOT'];
			$this->homeurl=$this->rooturl.$this->homedir;		//FQURL	to app home
			$this->homepath=$this->rootpath.$this->homedir;		//FQPATH to app home

			if (isset($_POST['logout'])) $this->logout();

			$a=$_SERVER['SCRIPT_NAME']; $b='/main/special/install.php';
			//if not called by installer
			if (strlen($a)-strlen($b)!==strrpos($a,$b)){
				//if there's not config	
				if (!file_exists($this->homepath.'main/scripts/config.php')){
					//go to the installer
					Header("Location: {$this->homedir}main/special/install.php\n");
					exit;
				}
				else{
					include($this->homepath.'main/scripts/config.php');
					$this->settings=$Settings;
					$this->setSiteinfo($Settings['sitename'],$Settingd['automail'],$Settings['mainmail']);
					if (!$this->dbInit($Settings['dbHost'],$Settings['dbPort'],$Settings['dbName'],$Settings['dbUser'],$Settings['dbPass'])) $this->er="At Application::__construct: Failed to connect to database. The DBMS said \"".$this->dbError()."\".";
					if (!$this->getUserByUUID(1)){
						Header("Location: {$this->homedir}main/special/install.php\n");
						exit;
					}
					$this->setAccount($_COOKIE['user']);
				}
			}

			if (isset($_POST['token'])&&($_POST['token']!='')) $this->token=$_POST['token'];
			else $this->token=bin2hex(random_bytes(32));

		}
		function renderHead($title='',$author='',$keywords='',$description=''){
			echo "<!doctype html><html><head><meta charset='utf-8' /><meta name='viewport' content='width=device-width, initial-scale=1.0' />";
			echo "\n<meta name='author' content='$author' /><meta name='keywords' content='$keywords' /><meta name='description' content='$description' />";
			echo "\n<link rel='stylesheet' type='text/css' href='{$this->homedir}main/style/global.css' /><link rel='stylesheet' type='text/css' href='{$this->homedir}main/style/style.css' />";
			echo "\n<link rel='stylesheet' type='text/css' class='themeSheet' title='Dark' href='{$this->homedir}main/style/themes/dark.css' />";
			echo "\n<link rel='stylesheet' type='text/css' class='themeSheet' title='Light' href='{$this->homedir}main/style/themes/light.css' />";
			if (isset($_COOKIE['theme'])) echo "\n<meta http-equiv='Default-Style' id='themeSheet' content='{$_COOKIE['theme']}' />";
			else echo "\n<meta http-equiv='Default-Style' id='themeSheet' content='Light' />";
			echo file_get_contents("{$this->homepath}main/style/icons/iconmeta.htm");
			echo "\n<script src='{$this->homedir}main/classes/Website.js'></script><script src='{$this->homedir}main/classes/Application.js'></script>";
			echo "<title>{$title}</title></head><body onload='init();'>";
		}
		function renderTail(){
			echo "</body></html>";
		}
		function renderHeader(){
			include ($this->homepath.'main/includes/header.php');
		}
		function renderFooter(){
			include ($this->homepath.'main/includes/footer.php');
		}
	}
?>
