<?php



	/******************************************\
	* Web Application 4.0 by SCFDuffy (C) 2021 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 4.0 Installer by SCFDuffy - (C)February 2021 *
	\**************************************************************/



	require_once('../classes/Application.php');
	$app=new Application();
	$app->renderHead("Privacy - {$app->sitename}",'SCFDuffy','Privacy Policy, Privacy, Cookie, Cookies, Policy',"Privacy policy for {$app->sitename}");
	$app->renderHeader();
?>
<h1>Privacy</h1>
<article>
	<h1>The <?php echo $app->sitename; ?> Privacy Policy</h1>
	<section>
		<h3>About <?php echo $app->sitename; ?> </h3>

		<p><?php echo $app->sitename; ?> is a web site providing free
		and paid online social services to the general public. <?php echo $app->sitename; ?>
		can always be contacted at the email address:
		<a href='mailto:<?php echo $app->mainmail; ?>?subject=Privacy_Policy'>
		<?php echo $app->mainmail; ?></a></p>
		
		<p>It is <?php echo $app->sitename; ?> policy to respect your privacy regarding
		any information we may collect while operating our website. This Privacy
		Policy applies to <a href="<?php echo $app->homeurl; ?>"><?php echo $app->homeurl; ?>
		</a> (hereinafter, "us", "we", or "<?php echo $app->homeurl; ?>"). We respect
		your privacy and are committed to protecting personally identifiable
		information you may provide us through the Website. We have adopted this
		privacy policy ("Privacy Policy") to explain what information may be
		collected on our Website, how we use this information, and under what
		circumstances we may disclose the information to third parties. This
		Privacy Policy applies only to information we collect through the Website
		and does not apply to our collection of information from other sources.</p>

		<p>This Privacy Policy, together with the Terms and conditions posted on
		our Website, set forth the general rules and policies governing your use
		of our Website. Depending on your activities when visiting our Website,
		you may be required to agree to additional terms and conditions.</p>



		<h3>Website Visitors</h3>

		<p>Like most website operators, <?php echo $app->sitename; ?> collects
		non-personally-identifying information of the sort that web browsers and
		servers typically make available, such as the browser type, language
		preference, referring site, and the date and time of each visitor request.
		<?php echo $app->sitename; ?>'s purpose in collecting non-personally-identifying
		information is to better understand how <?php echo $app->sitename; ?> 's visitors
		use its website. From time to time, <?php echo $app->sitename; ?>  may release
		non-personally-identifying information in the aggregate. (For example, by
		publishing a report on trends in the usage of its website.</p>
		
		<p><?php echo $app->sitename; ?> also collects potentially
		personally-identifying information like Internet Protocol (IP) addresses
		for logged in users and for users leaving comments on <?php echo $app->homeurl; ?>
		blog posts. <?php echo $app->sitename; ?> only discloses logged in user and
		commenter IP addresses under the same circumstances that it uses and
		discloses personally-identifying information as described below.</p>
			


		<h3>Gathering of Personally-Identifying Information</h3>

		<p>Certain visitors to <?php echo $app->sitename; ?>'s websites choose to
		interact with <?php echo $app->sitename; ?> in ways that require
		<?php echo $app->sitename; ?> to gather personally-identifying information. The
		amount and type of information that <?php echo $app->sitename; ?> gathers
		depends on the nature of the interaction. For example, we ask visitors who
		sign up for a blog at <?php echo $app->homeurl; ?> to provide a username and
		email address.</p>
			


		<h3>Security</h3>

		<p>The security of your Personal Information is important to us, but
		remember that no method of transmission over the Internet, or method of
		electronic storage is 100% secure. While we strive to use commercially
		acceptable means to protect your Personal Information, we cannot guarantee
		its absolute security.</p>
			


		<h3>Advertisements</h3>

		<p>Ads appearing on our website may be delivered to users by advertising
		partners, who may set cookies. These cookies allow the ad server to
		recognize your computer each time they send you an online advertisement to
		compile information about you or others who use your computer. This
		information allows ad networks to, among other things, deliver targeted
		advertisements that they believe will be of most interest to you. This
		Privacy Policy covers the use of cookies by <?php echo $app->sitename; ?> and
		does not cover the use of cookies by any advertisers.</p>
			


		<h3>Links To External Sites</h3>

		<p>Our Service may contain links to external sites that are not operated
		by us. If you click on a third party link, you will be directed to that
		third party's site. We strongly advise you to review the Privacy Policy
		and terms and conditions of every site you visit.</p>
		<p>We have no control over, and assume no responsibility for the content,
		privacy policies or practices of any third party sites, products or
		services.</p>
			
			

		<h3>Protection of Certain Personally-Identifying Information</h3>

		<p><?php echo $app->sitename; ?> discloses potentially personally-identifying
		and personally-identifying information only to those of its employees,
		contractors and affiliated organizations that
		<ul>
			<li>(i) need to know that information in order to process it on
			<?php echo $app->sitename; ?>'s behalf or to provide services available at
			<?php echo $app->sitename; ?>'s website, and</li>
			
			<li>(ii) that have agreed not to disclose it to others.</li>
		</ul></p>

		<p>Some of those employees, contractors and affiliated organizations may
		be located outside of your home country; by using <?php echo $app->sitename; ?>'s
		website, you consent to the transfer of such information to them.
		<?php echo $app->sitename; ?> will not rent or sell potentially
		personally-identifying and personally-identifying information to anyone.</p>
		
		<p>Other than to its employees, contractors and affiliated organizations,
		as described above, <?php echo $app->sitename; ?> discloses potentially
		personally-identifying and personally-identifying information only in
		response to a subpoena,	court order or other governmental request, or when
		<?php echo $app->sitename; ?> believes in good faith that disclosure is
		reasonably necessary to protect the property or rights of
		<?php echo $app->sitename; ?>, third parties or the public at large.</p>
		
		<p>If you are a registered user of <?php echo $app->homeurl; ?> and have
		supplied your email address, <?php echo $app->sitename; ?> may occasionally send
		you an email to tell you about new features, solicit your feedback, or
		just keep you up to date with what's going on with <?php echo $app->sitename; ?>
		and our products. We primarily use our blog to communicate this type of
		information, so we expect to keep this type of email to a minimum. If you
		send us a request (for example via a support email or via one of our
		feedback mechanisms), we reserve the right to publish it in order to help
		us clarify or respond to your request or to help us support other users.
		<?php echo $app->sitename; ?> takes all measures reasonably necessary to protect
		against the unauthorized access, use, alteration or destruction of
		potentially personally-identifying and personally-identifying information.
		</p>
			
		
			
		<h3>Affiliate Disclosure</h3>
		<p>This site uses affiliate links and does earn a commission from certain
		links. This does not affect your purchases or the price you may pay.</p>



		<h3>Cookies</h3>

		<p>To enrich and perfect your online experience, <?php echo $app->sitename; ?>
		uses "Cookies", similar technologies and services provided by others to
		display personalized content, appropriate advertising and store your
		preferences on your computer.</p>
		
		<p>A cookie is a string of information that a website stores on a visitor's
		computer, and that the visitor's browser provides to the website each time
		the visitor returns. <?php echo $app->sitename; ?> uses cookies to help
		<?php echo $app->sitename; ?> identify and track visitors, their usage of
		<?php echo $app->homeurl; ?>, and their website access preferences.
		<?php echo $app->sitename; ?> visitors who do not wish to have cookies placed on
		their computers should set their browsers to refuse cookies before using
		<?php echo $app->sitename; ?>'s websites, with the drawback that certain features
		of <?php echo $app->sitename; ?>'s websites may not function properly without
		the aid of cookies.</p>

		<p>By continuing to navigate our website without changing your cookie
		settings, you hereby acknowledge and agree to <?php echo $app->sitename; ?>'s
		use of cookies.</p>
			


		<h3>E-commerce</h3>

		<p>Those who engage in transactions with <?php echo $app->sitename; ?> – by
		purchasing <?php echo $app->sitename; ?>'s services or products, are asked to provide
		additional information, including as necessary the personal and financial
		information required to process those transactions. In each case,
		<?php echo $app->sitename; ?> collects such information only insofar as is
		necessary or appropriate to fulfill the purpose of the visitor's
		interaction with <?php echo $app->sitename; ?>. <?php echo $app->sitename; ?> does not
		disclose personally-identifying information other than as described below.
		And visitors can always refuse to supply personally-identifying information,
		with the caveat that it may prevent them from engaging in certain website
		related activities.</p>
			


		<h3>Business Transfers</h2>

		<p>If <?php echo $app->sitename; ?>, or substantially all of its assets, were
		acquired, or in the unlikely event that <?php echo $app->sitename; ?> goes out
		of business or enters bankruptcy, user information would be one of the
		assets that is transferred or acquired by a third party. You acknowledge
		that such transfers may occur, and that any acquirer of
		<?php echo $app->sitename; ?> may continue to use your personal information as
		set forth in this policy.</p>


			
		<h3>Privacy Policy Changes</h3>
		<p>Although most changes are likely to be minor, <?php echo $app->sitename; ?>
		may change its Privacy Policy from time to time, and in
		<?php echo $app->sitename; ?>'s sole discretion. <?php echo $app->sitename; ?>
		encourages visitors to frequently check this page for any changes to its
		Privacy Policy. Your continued use of this site after any change in this
		Privacy Policy will constitute your acceptance of such change.</p>
			
			
						  
		<h3>Contact Information</h3>

		<p>If you have any questions about this Privacy Policy, please contact us
		at <a href="mailto:<?php echo $app->mainmail; ?>?Privacy_Policy">
		<?php echo $app->mainmail; ?></a>.</p>

	</section>
</article>







<h1>About Our Cookies</h1>
<article>
	<h1>Quick Cookie Primer</h1>
	<section>
		<h3>Skip the Primer</h3>
		<p>If you already have a basic understanding of cookies and just want
		information on the cookies this web application generates, you can skip
		the primer by clicking on these links to go to the appropriate subsection.
		</p>
		<p class='center'>
			<a href='#1stpc'>Cookies set by this web application</a>
			<br/><br/>
			<a href='#3rdpc'>Cookies which may be set by third parties through the application</a>
		</p>
	</section>
	<section>
		<h2>About Cookies</h2>
		<p>Cookies are data which are specific for a particular website which are stored
		on a users browser and sent by the browser to the particular website anytime the
		user attempts to access the website. They are usually created and altered by the
		website according the way the user interacts with the website and the user then
		seamlessly tells the website all the information it has stored in the form of
		cookies every time they access the website.
		</p>
		<p>Cookies are the primary means by which internet sites "remember" each user
		between browsing sessions. (A session is the time from when a user browses to
		a site to the time the user closes all windows and tabs associatied with the
		site.) By the use of cookies, a website can remember who a user is despite that
		the previous session may have ended days ago.
		</p>
		<p>Cookies are used for a variety of purposes. The most common purpose they are
		used for is to remember the User Identity (UID) of a user for a particular website
		which in turn can allow the website to look up the data it has stored internal
		to itself about the user who has the cookie that the server created on their
		browser for them. This internal data can include anything from the version of
		browser and the dimensions of the screen upon which the website renders content,
		to user options like the preferred colours of the user, text-size or options
		that are specific to certain types of site.
		</p>

		<h3>Malignant Cookies</h3>
		<p>They can also be used to track user activities not only on the site that the
		user is visiting but on third party websites which are able to read cookies set
		by a website for other websites to read. Tracking cookies do not only store your
		options for a website but can identify across a huge swathe of websites and such
		sites can target content at those they track which can include advertising for
		commercial purposes by people who know you clicked on an advert for a train trip
		or a political candidate and are capable of being used for targeted propaganda
		at dissidents, people of influence and even people who some organisations may
		wish to keep in a bubble of false and misleading information for purposes which
		may not involve financial gain or profits as would fit into categories imagined
		by ordinary people where money is a scarce and all important matter to those who
		cant imagine a world composed of those who have never lacked money.
		</p>
		<p>On this website, we tick the legal boxes of ensuring your privacy but then so
		do all the organisations showing privacy popups telling you they care so much 
		about your privacy they are only going to share with their partners as soon as
		you click the annoying button preventing the flow of your browsing session. We
		don't share your data with anyone except the "authorities" and only then once
		the said "authorities" have fulfilled the legal requirements they need to follow
		like getting a court order and such like, indemnifying us from being sued by you
		because we gave away your private information to those who were not legally
		entitled. We will co-operate with the "authorities" but we strike a balance that
		the "authorities" must themselves be in compliance with the law.
		</p>
		<p>We reserve a right to reveal your data without your permission in situations
		or imminent threat of death or torture, terrorism, state corruption and war.
		Outside of that, only if the law says we are <u>required</u> to divulge it.
		</p>
	</section>
	<section>
		<h2>Cookies Types</h2>
		<p>We separate cookies into four simple categories in describing who can see
		the cookies which are on your browser.
		</p>
		<h3>Session Cookies</h3>
		<p>These cookies are deleted at the end of every session and it would be rare
		for them to contain anything that could seriously violate your privacy. Perhaps
		the server wants to know what your screen size is during the current session so
		it can generate pages appropriate to the device dimensions. This could be stored
		in a session cookie but the next you access the website, the server will create
		a brand new session cookie serving the same purpose. Prior to version 3.0 of
		this web application, the "chatrooms section visiblity" and the "theme"
		being light or dark were stored on a session cookie which reset back to default
		values if the user left and came back again.
		</p>
		<h3>Third Party Cookies</h3>
		<p>Third party cookies are traditionally cookies which created for websites
		other than the website you are currently visiting. For example, you visit the
		example.com website and it puts a cookie on your browser that can be read by
		any website and is intended that freindsofexample.com can read that cookie and
		make the connection that you exist elsewhere anytime you visit a whole range of
		websites.
		</p>
		<p>Third party cookies were heavily exploited by organisations during the late
		HTTP 1.1 era and many browsers continue to allow users to block third party
		cookies with the caveat that on the modern internet, some sites may not work at
		all.
		</p>
		<h3>Samesite Cookies</h3>
		<p>A samesite cookie is a cookie which is created by a website specifically
		forbidding the cookie to be read by any website other than itself. These types
		of cookies are used by almost all websites which employ the use of cookies. The
		ability to be remembered by a site you signed up to logged into before is most
		often provided by samesite cookies.
		</p>
		<h3 id='ssby3rd'>Samesite Cookies by Third Parties</h3>
		<p>Social media and external authentication has encouraged techniques which were
		previously considered dangerous since they allowed third party websites to run
		programs on a website which was not their own. This was traditionally described
		as a cross site scripting XSS attack and far from a website just deliberately
		running a script from another site, alot of effort was made by maligned hackers
		to cause an external script to run on a website that was not their own such that
		alot of underlying technology had to be rewritten to prevent people from getting
		their scripts to run on someone elses website.
		</p>
		<p>Samesite Cookies by Third Parties are a type of Samesite cookie which are 
		appear to be created by the site that you are visiting and will not flag up as
		a third party cookie in a users browser but the cookies are ultimately being
		created by a script which is hosted on a third party website but is being run
		by the site you are visiting. This web application at the current
		time can run a script which is hosted by Facebook that creates cookies appearing
		to be created by the instance of the web application that a user is
		visiting. That is to say that a user visits this site, logs in using the
		facebook button and ends up with a samesite cookie for this site which were
		actually created by the script which was being hosted by facebook during the
		login procedure.
		</p>
	</section>
</article>

<h1>Cookies by <?php echo $app->sitename; ?></h1>
<article id='1stpc'>
	<section>
		<h2><q>theme</q></h2>
		<p>The <q>theme</q> cookie is a samesite cookie which remebers the theme preferred
		by both members and anonymous users. At the current time (January 2021) there are
		two themes installed representing a dark mode like night time and a light mode
		like during the day.
		</p>
	</section>
	<section>
		<h2><q>user</q></h2>
		<p>The <q>Login</q> cookie is a samesite cookie which contains a members
		username between sessions when the user is not online.
		</p>
		<p>This cookie is only created when a someone with a Basic Membership or
		greater opts to be remembered and logged in automatically every time they
		visit the site.
		</p>
	</section>
	<section>
	<h2>login</h2>
	<p>The login cookie is a samesite cookie which the server uses to ensure the
	user cookie is a genuine cookie created by the genuine user on the website so
	avoiding potential security hazards such as someone using a forged cookie.
	</p>
	<p>This cookie is only created when a someone with a Basic Membership or greater
	opts to be remembered and logged in automatically every time they visit the site.
	</p>
	</section>
</article>

<h1>Third Party Cookies</h1>
<article id='3rdpc'>
	<h1>Our Third Party Cookie Policy</h1>
	<section>
	<p>With the possible exception of benign session cookies which are deleted at
	the end of each session and do not contain personally identifying information,
	this web application does not create any cookies which can be read by sites
	other than the site on which the instance of the web application is running.
	</p>
	<p>In saying this, in order to provide features that some websites employing
	an instance of the this web application may desire to use, the use of 
	<a href='#ssby3rd'>Samesite Cookies by Third Parties</a> is unavoidable if
	the certain features of the instance are enabled such as facebook logins.
	</p>
	<p>The website owner should consult the list of site settings section of the
	setup or install page to switch these features on and off.
	</p>
	</section>
	<section>
	<h2>Facebook</h2>
	<p>Our website may be enabled to support logging in and signing up using
	Facebook as an Outside Authentication (OAuth) service provider. If you have
	logged in or signed up using the Facebook login then you will receive cookies
	which appear to be samesite cookies from our website but which were actually
	created by a script which is run through our site but hosted on Facebook.
	</p>
	<p>At the current time (January 2021), Facebook will create two cookies which
	appear to be same-site/any-subdomain cookies from our website for anyone who
	logs in or signs up using the facebook login or continue as button. Their names
	are as described here:
	</p>
	<p class='center'><code>fbm_###############</code> (where # is digit from 0 to 9)
	</p>
	<p class='center'><code>fbsr_###############</code> (where # is digit from 0 to 9)
	</p>
	<p>These cookies are only sent for "social members" who login to our site using
	the facebook login button and are not needed for members who have signed up for
	or upgraded from "social membership" to "Basic Membership".
	</p>
	</section>
</article>





<?php
	$app->renderFooter();
	$app->renderTail();
?>
