<?php



	/******************************************\
	* Web Application 4.0 by SCFDuffy (C) 2021 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 4.0 Installer by SCFDuffy - (C)February 2021 *
	\**************************************************************/



	require_once('../classes/Application.php');
	$app=new Application();
	$app->renderHead("Administrate - {$app->sitename}",'SCFDuffy','Administration, User, Admin, Administrate, Users, Moderator',"Administration page for {$app->sitename}");
	$app->renderHeader();

	$account_types=['director'=>1,'administrator'=>2,'moderator'=>3,'basic'=>4];
	switch ($app->account['account_type']){
		case 'director':
		case 'administrator':
		case 'moderator':

		if ((isset($_POST['account_type']))&&($_POST['account_type']!='')&&(isset($_POST['uid']))&&($_POST['uid']!='')){
			$ac=$app->getUserByUUID($_POST['uid']);
			$act=$account_types[$app->account['account_type']];	//actor (the admin clearance)
			$obj=$account_types[$ac['account_type']];					//object (the accountee clearance)
			$tgt=$account_types[$_POST['account_type']];				//target (the target clearance)
			if (($act<=$obj)&&($act<=$tgt)){
				$app->editUser($ac['uuid'],'account_type',$_POST['account_type']);
			}
		}

		if ((isset($_POST['ban']))&&($_POST['ban']!='')&&(isset($_POST['uid']))&&($_POST['uid']!='')){
			$ac=$app->getUserByUUID($_POST['uid']);
			$act=$account_types[$app->account['account_type']];	//actor (the admin clearance)
			$obj=$account_types[$ac['account_type']];					//object (the accountee clearance)
			if ($act<$obj) switch ($_POST['ban']){
				case 'unban': $app->editUser($_POST['uid'],'bantil',time()-1); break;
				case 'hour': $app->editUser($_POST['uid'],'bantil',time()+3600); break;
				case 'day': $app->editUser($_POST['uid'],'bantil',time()+86400); break;
				case 'month': $app->editUser($_POST['uid'],'bantil',time()+2592000); break;
				case 'permanent': $app->editUser($_POST['uid'],'bantil','2147483647'); break;
			}
		}
		if ((isset($_POST['delete']))&&($_POST['delete']!='')&&(isset($_POST['uid']))&&($_POST['uid']!='')){
			$app->delUser($_POST['uid']);
		}
		if ((isset($_POST['notes']))&&($_POST['notes']!='')&&(isset($_POST['uid']))&&($_POST['uid']!='')){
			$app->editUser($_POST['uid'],'notes',$_POST['notes']);
		}
?>
<style>
div.record{vertical-align:top;padding:0;display:inline-block;overflow-x:auto;}
section.male{background:#ccf; color:black;}
section.female{background:#fcc; color:black;}
.big{padding:0px;display:inline;font-weight:medium;font-size:1.125rem;}
.data{font-size:0.75rem;font-family:monospace;vertical-align:top;}
form.actions{display:inline;}
</style>
<h1>User Administration</h1>
<article>
<?php
	$response=$app->db->query('select * from users;');
	for ($n=0;$n<$response->num_rows;$n++){
		$row=$response->fetch_assoc();
		$avatar=$row['icon_url'];
		if ($avatar=='') $avatar='main/style/glyphs/anonymous.png';
		$avatar=$app->homedir.$avatar;
?>
	<section class='<?php if ($row['gender']=='male') echo ' male'; else if ($row['gender']=='female') echo ' female'; ?>'>
		<div class='record'>
			<img src='<?php echo $avatar; ?>' style='height:3rem;' />
		</div>
		<div class='record' style='width:220px'>
			<span class='record big'>
			<a href='<?php echo $app->homedir.'main/special/profile.php?view='.$row['username']; ?>'>
			<?php echo $row['username']; ?>
			</a>
			</span>
			<form method='post' class='actions'>
				<select name='account_type' style='height:1rem; font-size:0.6rem;' onchange='form.submit();'>
					<option value='director'<?php if ($row['account_type']=='director') echo " selected='true'"; ?>>Director</option>
					<option value='administrator'<?php if ($row['account_type']=='administrator') echo " selected='true'"; ?>>Administrator</option>
					<option value='moderator'<?php if ($row['account_type']=='moderator') echo " selected='true'"; ?>>Moderator</option>
					<option value='basic'<?php if ($row['account_type']=='basic') echo " selected='true'"; ?>>Basic</option>
				</select>
				<input type='hidden' name='uid' value='<?php echo $row['uuid']; ?>' />
			</form>
			<?php
				echo "<a href='mailto:{$row['email']}'";
				if ($row['email_invalid']!=0) echo " style='color:var(--redlink);'";
				echo ">{$row['email']}</a>";
			?>
		</div>
		<div class='record data' style='width:220px'>
			<?php echo $row['first_name']; ?> <?php echo $row['last_name']; ?>
			<br/>
			<?php
				if ((isset($row['city']))&&($row['city']!='')) echo $row['city'].', ';
				if ((isset($row['country']))&&($row['country']!='')) echo $row['country'];
				echo "<br/>Joined: ".date('d M Y',$row['creation_time']);
			?>
		</div>
		<div class='record data' style='width:220px'>
			<?php echo "Last login:<br/>".date('H:i D d M Y',$row['last_login']).'<br/>'; ?>
			<?php
				if ($row['bantil']>Time()) echo "<b style='color:red;'>Ban Lift:<br/>".date('H:i D d M Y',$row['bantil']).'</b>';
			?>
		</div>
		<div class='record'>
			<form method='post'>
				<textarea name='notes' class='data'><?php echo $row['notes']; ?></textarea>
				</br><input type='submit' style='width:100%;margin:0' value='update' />
				<input type='hidden' name='uid' value='<?php echo $row['uuid']; ?>' />
			</form>
		</div>
		<div class='record'>
			<form method='post' class='actions'>
				<select name='ban'>
					<option></option>
					<?php if ($row['bantil']>Time()) echo "<option value='unban'>unban</option>"; ?>
					<option value='hour'>hour</option>
					<option value='day'>day</option>
					<option value='month'>month</option>
					<option value='permanent'>permanent</option>
				</select><br/><input style='margin:0;' type='submit' value='ban' />
				<input type='hidden' name='uid' value='<?php echo $row['uuid']; ?>' />
			</form>
			<form method='post' class='actions' onsubmit='return confirm("Delete Account?");'>
				<input type='submit' name='delete' value='delete' style='background:linear-gradient(#faa,#c00);border-color:#faa;color:white;' />
				<input type='hidden' name='uid' value='<?php echo $row['uuid']; ?>' />
			</form>
		</div>


	</section>
<?php
	}
?>
</article>
<?php
		break;
		default:
?>
	<h1>User Administration</h1>
	<article>
		<section>
			<p>The User Administration page is only available to certain classes of users.</p>
			<p>You should hit the back button or navigate to a more appropriate page.</p>
		</section>
	</article>
<?php
	}
	$app->renderFooter();
	$app->renderTail();
?>
