<?php



	/******************************************\
	* Web Application 4.0 by SCFDuffy (C) 2021 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 4.0 Installer by SCFDuffy - (C)February 2021 *
	\**************************************************************/



	require_once('../classes/Application.php');
	ob_start();
	$app=new Application();

	$errfocus=false;
	if (!count($_POST)) $errfocus='none';
	//ICON DETECTION AND CREATION CODE
	$icon_error='';
	if (isset($_FILES['site_icon']['tmp_name'])&&($_FILES['site_icon']['tmp_name']!='')){
		if (getimagesize($_FILES['site_icon']['tmp_name'])===false) $icon_error='No Image';
		else{
			if ($_FILES['site_icon']['size']>=1048576) $icon_error='File too large. File must be less that 1 megabyte.';
			else{
				$icon_extension=strtolower(pathinfo(basename($_FILES["site_icon"]["name"]),PATHINFO_EXTENSION));
				switch ($icon_extension){
					default: $icon_error='Image must be a gif, jpg, jpeg, png, webp or bmp.'; break;
					case 'gif': case 'jpg': case 'jpeg': case 'png': case 'webp': case 'bmp': {
						if (!file_exists($app->homepath.'main/style/icons')) mkdir($app->homepath.'main/style/icons',0774,true);
						$icon_filename='main/style/icons/siteicon.'.$icon_extension;
						$icon_res=false;
						switch($icon_extension){
							case 'jpg':
							case 'jpeg':	$icon_res=imagecreatefromjpeg($_FILES["site_icon"]["tmp_name"]); break;
							case 'gif':		$icon_res=imagecreatefromgif($_FILES["site_icon"]["tmp_name"]); break;
							case 'png':		$icon_res=imagecreatefrompng($_FILES["site_icon"]["tmp_name"]); break;
							case 'webp':	$icon_res=imagecreatefromwebp($_FILES["site_icon"]["tmp_name"]); break;
							case 'bmp':		$icon_res=imagecreatefrombmp($_FILES["site_icon"]["tmp_name"]); break;
						}
						if ($icon_res===false) $icon_error='File is corrupted!';
						else{
							if ( imagesx($icon_res) > imagesy($icon_res) ) $i0=imagescale($icon_res,512,-1,IMG_BICUBIC_FIXED);
							else $i0=imagescale($icon_res,512*(imagesx($icon_res)/imagesy($icon_res)),512,IMG_BICUBIC_FIXED);
							imagedestroy($icon_res);
							$i512=imagecreatetruecolor(512,512);
							imageSaveAlpha($i512,true);
							imagefill($i512,256,256,imagecolorallocatealpha($i512,0,0,0,127));
							imagecopy($i512,$i0,(512-imagesx($i0))/2,(512-imagesy($i0))/2,0,0,imagesx($i0),imagesy($i0));
							imagedestroy($i0);
							$homepath=$app->homepath.'main/style/icons/';
							unlink($homepath.'mainicon.png');
 							imagepng($i512,$homepath.'mainicon.png');
							$i0=imagescale($i512,512,512,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-chrome-512x512.png');imagedestroy($i0);
							$i0=imagescale($i512,310,310,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'ms-icon-310x310.png');imagedestroy($i0);
							$i0=imagescale($i512,192,192,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-chrome-192x192.png');imagedestroy($i0);
							$i0=imagescale($i512,192,192,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-icon-192x192.png');imagedestroy($i0);
							$i0=imagescale($i512,192,192,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon.png');imagedestroy($i0); 
							$i0=imagescale($i512,180,180,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-180x180.png');imagedestroy($i0);
							$i0=imagescale($i512,180,180,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-touch-icon.png');imagedestroy($i0); 
							$i0=imagescale($i512,152,152,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-152x152.png');imagedestroy($i0);
							$i0=imagescale($i512,150,150,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'ms-icon-150x150.png');imagedestroy($i0);
							$i0=imagescale($i512,144,144,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-icon-144x144.png');imagedestroy($i0);
							$i0=imagescale($i512,144,144,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-144x144.png');imagedestroy($i0);
							$i0=imagescale($i512,144,144,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'ms-icon-144x144.png');imagedestroy($i0);
							$i0=imagescale($i512,120,120,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-120x120.png');imagedestroy($i0);
							$i0=imagescale($i512,114,114,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-114x114.png');imagedestroy($i0);
							$i0=imagescale($i512,96,96,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-icon-96x96.png');imagedestroy($i0);
							$i0=imagescale($i512,96,96,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'favicon-96x96.png');imagedestroy($i0);
							$i0=imagescale($i512,76,76,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-76x76.png');imagedestroy($i0);
							$i0=imagescale($i512,72,72,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-icon-72x72.png');imagedestroy($i0);
							$i0=imagescale($i512,72,72,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-72x72.png');imagedestroy($i0);
							$i0=imagescale($i512,70,70,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'ms-icon-70x70.png');imagedestroy($i0);
							$i0=imagescale($i512,60,60,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-60x60.png');imagedestroy($i0);
							$i0=imagescale($i512,57,57,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-57x57.png');imagedestroy($i0);
							$i0=imagescale($i512,48,48,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-icon-48x48.png');imagedestroy($i0);
							$i0=imagescale($i512,36,36,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-icon-36x36.png');imagedestroy($i0);
							$i0=imagescale($i512,32,32,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'favicon-32x32.png');imagedestroy($i0);
							$i0=imagescale($i512,16,16,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'favicon-16x16.png');imagedestroy($i0);
							$image_data=file_get_contents($homepath.'favicon-16x16.png');$i0=pack('vvvCCCCvvVV',0,1,1,16,16,0,0,1,0,filesize($homepath.'favicon-16x16.png'),22);$i0.=$image_data;
							file_put_contents($homepath.'favicon.ico',$i0);
							if (!isset($_POST['site_icon_root'])) file_put_contents($app->rootpath.'/favicon.ico',$i0);
							unset($image_data,$i0);
							imagedestroy($i512);
 							file_put_contents("{$homepath}browserconfig.xml","<"."?xml version='1.0' encoding='utf-8'?"."><browserconfig><msapplication><tile><square70x70logo src='{$app->homedir}main/style/icons/ms-icon-70x70.png'/><square144x144logo src='{$app->homedir}main/style/icons/ms-icon-144x144.png'/><square150x150logo src='{$app->homedir}main/style/icons/ms-icon-150x150.png'/><square310x310logo src='{$app->homedir}main/style/icons/ms-icon-310x310.png'/><TileColor>#ffffff</TileColor></tile></msapplication></browserconfig>");
 							file_put_contents("{$homepath}IEconfig.xml","<"."?xml version='1.0' encoding='utf-8'"."?><browserconfig><msapplication><tile><square70x70logo src='{$app->homedir}main/style/icons/ms-icon-70x70.png'/><square144x144logo src='{$app->homedir}main/style/icons/ms-icon-144x144.png'/><square150x150logo src='{$app->homedir}main/style/icons/ms-icon-150x150.png'/><square310x310logo src='{$app->homedir}main/style/icons/ms-icon-310x310.png'/><TileColor>#ffffff</TileColor></tile></msapplication></browserconfig>");
							file_put_contents("{$homepath}site.webmanifest",'{"name":"","short_name":"","icons":[{"src":"'.$app->homedir.'main/style/icons/android-chrome-192x192.png","sizes":"192x192","type":"image/png"},{"src":"'.$app->homedir.'main/style/icons/android-chrome-512x512.png","sizes":"512x512","type":"image/png"}],"theme_color":"#ffffff","background_color":"#ffffff","display":"standalone"}');
							file_put_contents("{$homepath}manifest.json",'{"name":"App","icons":[{"src": "'.$app->homedir.'main\/style\/icons\/android-icon-36x36.png","sizes": "36x36","type": "image\/png","density": "0.75"},{"src": "'.$app->homedir.'main\/style\/icons\/android-icon-48x48.png","sizes": "48x48","type": "image\/png","density": "1.0"},{"src": "'.$app->homedir.'main\/style\/icons\/android-icon-72x72.png","sizes": "72x72","type": "image\/png","density": "1.5"},{"src": "'.$app->homedir.'main\/style\/icons\/android-icon-96x96.png","sizes": "96x96","type": "image\/png","density": "2.0"},{"src": "'.$app->homedir.'main\/style\/icons\/android-icon-144x144.png","sizes": "144x144","type": "image\/png","density": "3.0"},{"src": "'.$app->homedir.'main\/style\/icons\/android-icon-192x192.png","sizes": "192x192","type": "image\/png","density": "4.0"}]}');
							file_put_contents("{$homepath}iconmeta.htm","
<link rel='icon' type='image/x-icon' sizes='16x16' href='{$app->homedir}main/style/icons/favicon.ico' />
<link rel='icon' type='image/png' sizes='96x96' href='{$app->homedir}main/style/icons/favicon-96x96.png' />
<link rel='icon' type='image/png' sizes='32x32' href='{$app->homedir}main/style/icons/favicon-32x32.png' />
<link rel='icon' type='image/png' sizes='16x16' href='{$app->homedir}main/style/icons/favicon-16x16.png' />
<link rel='icon' type='image/png' sizes='512x512' href='{$app->homedir}main/style/icons/android-chrome-512x512.png' />
<link rel='icon' type='image/png' sizes='192x192' href='{$app->homedir}main/style/icons/android-chrome-192x192.png' />
<link rel='icon' type='image/png' sizes='192x192' href='{$app->homedir}main/style/icons/android-icon-192x192.png' />
<link rel='icon' type='image/png' sizes='144x144' href='{$app->homedir}main/style/icons/android-icon-144x144.png' />
<link rel='icon' type='image/png' sizes='96x96' href='{$app->homedir}main/style/icons/android-icon-96x96.png' />
<link rel='icon' type='image/png' sizes='72x72' href='{$app->homedir}main/style/icons/android-icon-72x72.png' />
<link rel='icon' type='image/png' sizes='48x48' href='{$app->homedir}main/style/icons/android-icon-48x48.png' />
<link rel='icon' type='image/png' sizes='36x36' href='{$app->homedir}main/style/icons/android-icon-36x36.png' />
<link rel='apple-icon' type='image/png' sizes='192x192' href='{$app->homedir}main/style/icons/apple-icon.png' />
<link rel='apple-touch-icon' type='image/png' sizes='180x180' href='{$app->homedir}main/style/icons/apple-icon-180x180.png' />
<link rel='apple-touch-icon' type='image/png' sizes='180x180' href='{$app->homedir}main/style/icons/apple-touch-icon.png' />
<link rel='apple-touch-icon' type='image/png' sizes='152x152' href='{$app->homedir}main/style/icons/apple-icon-152x152.png' />
<link rel='apple-touch-icon' type='image/png' sizes='144x144' href='{$app->homedir}main/style/icons/apple-icon-144x144.png' />
<link rel='apple-touch-icon' type='image/png' sizes='120x120' href='{$app->homedir}main/style/icons/apple-icon-120x120.png' />
<link rel='apple-touch-icon' type='image/png' sizes='114x114' href='{$app->homedir}main/style/icons/apple-icon-114x114.png' />
<link rel='apple-touch-icon' type='image/png' sizes='76x76' href='{$app->homedir}main/style/icons/apple-icon-76x76.png' />
<link rel='apple-touch-icon' type='image/png' sizes='72x72' href='{$app->homedir}main/style/icons/apple-icon-72x72.png' />
<link rel='apple-touch-icon' type='image/png' sizes='60x60' href='{$app->homedir}main/style/icons/apple-icon-60x60.png' />
<link rel='apple-touch-icon' type='image/png' sizes='57x57' href='{$app->homedir}main/style/icons/apple-icon-57x57.png' />
<meta name='msapplication-TileImage' content='{$app->homedir}main/style/icons/ms-icon-310x310.png' />
<meta name='msapplication-TileImage' content='{$app->homedir}main/style/icons/ms-icon-150x150.png' />
<meta name='msapplication-TileImage' content='{$app->homedir}main/style/icons/ms-icon-70x70.png' />
<meta name='msapplication-TileImage' content='{$app->homedir}main/style/icons/ms-icon-144x144.png' />
<meta name='msapplication-config' content='{$app->homedir}main/style/icons/browserconfig.xml' />
<meta name='msapplication-config' content='{$app->homedir}main/style/icons/IEconfig.xml' />
<link rel='manifest'	href='{$app->homedir}main/style/icons/manifest.json' />
<link rel='manifest' href='{$app->homedir}main/style/icons/site.webmanifest' />
<meta name='msapplication-TileColor' content='#ffffff' />
<meta name='theme-color' content='#ffffff' />
"
							);
						}
					}
				}
			}
		}
	}
	$icon_complete=false;
	if (file_exists($app->homepath.'main/style/icons/mainicon.png')) $icon_complete=true;
	else if (!$errfocus) $errfocus="document.getElementsByName('site_icon')[0].focus();";

	//SITE INFORMATION DETECTION CODE
	$site_info_complete=false;
	if (
			(isset($_POST['site_name']))&&($_POST['site_name']!=false)&&
			(isset($_POST['auto_mail']))&&($_POST['auto_mail']!=false)
		){
		$site_info_complete=true;
	}
	else if (!$errfocus){
		if ((!isset($_POST['site_name']))||($_POST['site_name']==''))
			$errfocus="document.getElementsByName('site_name')[0].focus();";
		else if ((!isset($_POST['auto_mail']))||($_POST['auto_mail']==''))
			$errfocus="document.getElementsByName('auto_mail')[0].focus();";
	}


	//ADMIN INFORMATION DETECTION CODE
	$adm_info_complete=false;
	if (
			(isset($_POST['adm_email'])&&($_POST['adm_email']!=false))&&
			(isset($_POST['adm_user'])&&($_POST['adm_user']!=false))&&
			(isset($_POST['adm_pass'])&&($_POST['adm_pass']!=false))
		){
		$adm_info_complete=true;
	}
	else if (!$errfocus){
		if (!isset($_POST['adm_email'])||($_POST['adm_email']==false)) $errfocus="document.getElementsByName('adm_email')[0].focus();";
		else
		if (!isset($_POST['adm_user'])||($_POST['adm_user']==false)) $errfocus="document.getElementsByName('adm_user')[0].focus();";
		else
		if (!isset($_POST['adm_pass'])||($_POST['adm_pass']==false)) $errfocus="document.getElementsByName('adm_pass')[0].focus();";
	}



	//DATABASE INFORMATION TESTING CODE
	$db_error=false;	//NB false!==null
	if (  //ARE ALL THE SETTINGS FOR THE DATABASE CONNECTION AVAILABLE?
			(isset($_POST['db_host'])&&($_POST['db_host']!=false))&&
			(isset($_POST['db_port'])&&($_POST['db_port']!=false))&&
			(isset($_POST['db_name'])&&($_POST['db_name']!=false))&&
			(isset($_POST['db_user'])&&($_POST['db_user']!=false))&&
			(isset($_POST['db_pass'])&&($_POST['db_pass']!=false))
		){
      $test=new mysqli($_POST['db_host'],$_POST['db_user'],$app->decrypt(hex2bin($_POST['db_pass']),hex2bin($app->token)),$_POST['db_name'],$_POST['db_port']);

      $db_error=$test->connect_error;
		unset($test);
	}
	else if (!$errfocus){
		if ((!isset($_POST['db_host']))||($_POST['db_host']==false)) $errfocus="document.getElementsByName('db_host')[0].focus();";
		else
		if ((!isset($_POST['db_port']))||($_POST['db_port']==false)) $errfocus="document.getElementsByName('db_port')[0].focus();";
		else
		if ((!isset($_POST['db_name']))||($_POST['db_name']==false)) $errfocus="document.getElementsByName('db_name')[0].focus();";
		else
		if ((!isset($_POST['db_user']))||($_POST['db_user']==false)) $errfocus="document.getElementsByName('db_user')[0].focus();";
		else
		if ((!isset($_POST['db_pass']))||($_POST['db_pass']==false)) $errfocus="document.getElementsByName('db_pass')[0].focus();";
	}


	if (!file_exists($app->homepath.'main/scripts/config.php'))
	//DATABASE TABLES CREATION CODE
	if (($site_info_complete)&&($icon_complete)&&($db_error===null)&&($adm_info_complete)){
		if (!$app->dbInit($_POST['db_host'],$_POST['db_port'],$_POST['db_name'],$_POST['db_user'],$app->decrypt(hex2bin($_POST['db_pass']),hex2bin($app->token)))){
			$db_error=$app->dbError();
		}
		else{
			$query=file_get_contents($app->homepath.'main/scripts/users.sql');
			if ($app->db->query($query))
				$app->addUser('director',$_POST['adm_user'],$app->decrypt(hex2bin($_POST['adm_pass']),hex2bin($app->token)),$_POST['adm_email'],0);
			else if ($app->db->errno===1050){
				$adminRecord=$app->getUserByUUID(1);
				if ($adminRecord){
					$passhash=password_hash($app->decrypt(hex2bin($_POST['adm_pass']),hex2bin($app->token)),PASSWORD_DEFAULT);
					$app->editUser($adminRecord['uuid'],'username',$_POST['adm_user']);
					$app->editUser($adminRecord['uuid'],'password',$passhash);
					$app->editUser($adminRecord['uuid'],'email',$_POST['adm_email']);
				}
				else $app->addUser('director',$_POST['adm_user'],$app->decrypt(hex2bin($_POST['adm_pass']),hex2bin($app->token)),$_POST['adm_email'],0);
			}			
			if (($app->db->errno!==1050)&&($app->db->errno!==0)) $db_error=$app->db->error;
			else{
				$newuser=$app->getUser($_POST['adm_user']);
				$app->editUser($newuser['uuid'],'icon_url','main/style/glyphs/anonymous.png');
				$config_file="<?php\n";
				$config_file.="\$Settings['sitename']='{$_POST['site_name']}';\n";
				$config_file.="\$Settings['automail']='{$_POST['auto_mail']}';\n";
				$config_file.="\$Settings['mainmail']='{$_POST['adm_email']}';\n";
				$config_file.="\$Settings['dbHost']='{$_POST['db_host']}';\n";
				$config_file.="\$Settings['dbPort']={$_POST['db_port']};\n";
				$config_file.="\$Settings['dbName']='{$_POST['db_name']}';\n";
				$config_file.="\$Settings['dbUser']='{$_POST['db_user']}';\n";
				$config_file.="\$Settings['dbPass']='".$app->decrypt(hex2bin($_POST['db_pass']),hex2bin($app->token))."';\n";
				$config_file.="\$Settings['nameCompulsory']='{$_POST['ss_name']}';\n";
				$config_file.="\$Settings['emailCompulsory']='{$_POST['ss_email']}';\n";
				$config_file.="\$Settings['emailValidation']='{$_POST['ss_evalid']}';\n";
				$config_file.="\$Settings['countryCompulsory']='{$_POST['ss_country']}';\n";
				$config_file.="\$Settings['genderCompulsory']='{$_POST['ss_gender']}';\n";
				$config_file.="\$Settings['dobCompulsory']='{$_POST['ss_dob']}';\n";
				if ($_POST['ss_age']=='') $_POST['ss_age']=0;
				$config_file.="\$Settings['min_age']='{$_POST['ss_age']}';\n";
				$config_file.="?>\n";
				file_put_contents($app->homepath.'main/scripts/config.php',$config_file);
				Header("Location: {$app->homedir}index.php"); exit;
			}
		}
	}
	ob_end_flush();
	$app->renderHead("Installation",'SCFDuffy','Install, Setup, Configure, Configuration, Installation, Config',"Installation of a new instance of a Gartbeth Digital Services Web Application");
	$app->renderHeader();
?>










		<style>
			body{text-align:center;}
			article{text-align:center;display:inline-block;border:0.125rem outset #ccc;}
			section{text-align:right;display:inline-block;border:none;}
			.complete{background:#cfc; color:black;}
		   .helpbox{background:#ffe; font-weight:normal;font-size:1rem;text-align:left;
			         border:0.0625rem solid var(--button-fg);
			         border-radius:0.5rem;padding:0.5rem;}
			blockquote{border:0.0625rem dashed var(--button-fg); border-radius:0.5rem; padding:0.25rem;}
		</style>


		<script>
			function safepost(){
				var form=document.getElementById('mainform');	
				var token=document.getElementsByName('token')[0].value;
				var adpw=document.getElementsByName('adm_pass')[0];
				var dbpw=document.getElementsByName('db_pass')[0];
				adpw.value=app.encryptHex(adpw.value,token);
				dbpw.value=app.encryptHex(dbpw.value,token);
				form.submit();
				adpw.value=app.decryptHex(adpw.value,token);				
				dbpw.value=app.decryptHex(dbpw.value,token);
				return false;
			}
			<?php if (($errfocus!='none')&&($errfocus!=false)) echo "function pageInit(){".$errfocus."}" ?>
		</script>




		<h1 style='color:red;'>503 - Service Unavailable</h1>




		<article>
			<h2>The section of the website is currently unavailable.</h2>




			<section style='text-align:left;'>
				<h3>Visitor Information</h3>
				<p>If you are an ordinary user of the website, the application at
				this URL has not yet been installed by the administrator. You should
				come back once the software has been properly installed.
				</p>
			</section>	




			<section style='text-align:left;' class='complete'>
				<h3>Information for Website Administrators</h3>
				<p>If you are a website administrator then the details which follow
				must be filled in so that the application can be installed on the
				installation directory.
				</p>
				<p>Some of the details have been pre-filled in with default values.
				You should look them over and change them where neccessary and where
				you prefer to have settings which are different from the default
				values. If you require assistance in filling out these details you
				can get help by clicking on the title of the section you are having
				difficulty with.
				</p>
			</section>	
		</article>
         
<?php

	if (file_exists($app->homepath.'main/scripts/config.php')){

?>
		<article>
			<h2>Installation Disabled
			</h2>
			<section style='text-align:left;'>
				<h3 class='center'>The Application Can't Be Installed Yet</h3>
				<p>Application installation is disabled while a <b><i>configuration
				file</i></b> exists in the scripts folder. Either move, rename or
				delete the <q>config.php</q> file from the scripts folder or alter
				the current configuration using
				<a href='<?php echo $app->homepath.'main/special/setup.php' ?>'>
				The Setup Page</a>.
				</p>
				<p>You can <a href=''>reload this installation page</a> once you
				have moved, renamed or deleted the configuration file.
				</p>
			</section>	
		</article>

<?php

	}
	else{

?>
         
         
		<article>
			<h2>
				<details><summary>Installation URL</summary>
		         <div class='helpbox'>
		         <p>This is the url at which the application will be available
		         from. It cannot be altered from this installation page. If you
		         would prefer to install to a different location, you should go
		         to your websites filing system and move the folder <q>main</q>
		         and its subfolders to a more appropriate directory. You will need
		         to move the file <q>index.php</q> from the folder that <q>main
		         </q> is in to the same folder into which you are placing <q>main
		         </q>. You should then navigate to that folder from a web browser
		         and begin this installation process again.
					</p>
		         </div>
				</details>
			</h2>
			<section class='complete'>
				<h3 class='center'> 	&nbsp; The Application will be installed at &nbsp;
				<blockquote style='border:0.0625rem dashed var(--button-fg);'>
					<?php echo $app->homeurl; ?>
				</blockquote>
				</h3>
			</section>	
		</article>
         

         
         
      <form id='mainform' enctype='multipart/form-data' method='post' onsubmit='return safepost();'>
         <article>



            <h2>
            	<details><summary>Website Icon</summary>
			         <div class='helpbox'>
			         <p>The website icon will appear in numerous places throughout
			         the end users use of the site. It is a square logo which will
			         appear on the browser tabs, bookmarks and quickdial area to
			         represent the site. This will be the image that will be shown
			         on home screen short cuts on mobile phones and the icons to
			         reach the site from some operating system menus.
			         </p>
			         <p>The icon should have square dimensions with a resolution
			         which is 512x512 ideally. This image will be used to generate
			         smaller and larger images so if you're image has less than the
			         ideal dimensions, the larger images generated may be of lower
			         quality than what they might be.
                  </p>
			         <p>If you are installing this to a subdirectory of a website
			         (*NB not including the root of a subdomain), you may wish to
			         keep the favicon stored on the www-root directory for use in
			         the main application you use with your site. You should click
			         the <q>No Favicon for www-root</q> checkbox to suppress the
			         favicon on your sites www-root folder from being overwritten.
                  </p>
			         </div>
					</details>
				</h2>
				<section <?php	if ($icon_complete) echo "class='complete'"; ?>>
					<div style='display:inline-block;'>
						<?php
							if (file_exists($app->homepath.'main/style/icons/mainicon.png'))
								echo "<img src='".$app->homedir."main/style/icons/mainicon.png'
									style='height:4.5rem;padding:0.25rem;' />";
						?>
					</div>

					<div style='display:inline-block;vertical-align:top;'>
					<h3>Site Icon
						<input name='site_icon' type='file' />
					</h3>

					<h3 title="Suppress placing a favicon image on the www-root folder.">No Favicon for www-root
						<input name='site_icon_root' type='checkbox'
						<?php
							if (isset($_POST['site_icon_root']))
								echo ' checked';
						?>
					/>
					</h3>

					<!--input name='site_icon_upload' type='submit' value='upload' /-->

					</div>
	            <?php if (!$icon_complete){echo "<br/><b style='color:red;'>$icon_error</b>";}?>
				</section>	




				<h2>
					<details><summary>Website Information</summary>
			         <div class='helpbox'>
			         <p>To install this software, you must provide a name for the
			         site. This will appear in the title bar of browsers and will
			         be the name used in the site banner and any places where the
			         name of the site is automatically written.
                  </p>
						<p>You will also need to provide an email address which will
						be used by the system to send out automated email for which
						there will be no reply. For example, if email acitivation is
						enabled then users will receive an <q>noreply</q> email asking
						them to click a link to validate that they can receive email
						at the address they have given. <b>It should be different from
						the administrators email address</b> which you will need to
						fill in below to set up an initial administratve account for
						provide later. The emails which are sent from the automated
						email address are used for purposes like validation and the
						recipients of mails from this <q>no reply</q> email address
						are instructed that emails to the auto-mailer address will not
						be responded to.
						</p>
			         </div>
					</details>
				</h2>
				<section <?php if ($site_info_complete) echo " class='complete'"; ?>>
         		
					<h3>Website Name					
         		<input name='site_name' placeholder='example'
	               <?php
	               	if (isset($_POST['site_name'])&&($_POST['site_name']!=false))
	               		echo "value='{$_POST['site_name']}'";
							else
								echo "value='{$_SERVER['SERVER_NAME']}'";
						?>
	         	/>
	         	</h3>
					
					<h3>Auto-Emailer					
					<input name='auto_mail' type='email' placeholder='noreply@example.com'
						<?php
							if (isset($_POST['auto_mail'])&&($_POST['auto_mail']!=false))
								echo "value='{$_POST['auto_mail']}'";
							else
								echo "value='noreply@{$_SERVER['SERVER_NAME']}'";
						?>
					/>
	         	</h3>



				</section>



				<h2>
					<details><summary>Signup Settings</summary>
			         <div class='helpbox'>
			         <p>These settings are for the mandatory requirements of new
			         signups. You can use these settings to make certain fields
			         a requirement for new signups.
			         </p>
			         <p>Email validation can be made compulsory meaning that a new
			         user will not be able to sign into their account until the
			         email address they provide at sign up has been validated by
			         clicking on a link sent to the email address with which they
			         signed up.
			         </p>
			         <p>You can also just require that a new user provides an email
			         address but does not need to validate it by clicking on any
			         link we send. You can also require that new users provide a
			         country or their first and last name.
			         </p>
			         </div>
					</details>
				</h2>
				<section <?php if ($site_info_complete) echo " class='complete'"; ?>>
         		<script>
         			function syncEmailSiteSettings(calltype){
							if ((calltype==='v') && (document.getElementsByName("ss_evalid")[0].checked))
								document.getElementsByName("ss_email")[0].checked=true;
							if ((calltype==='e') && (!document.getElementsByName("ss_email")[0].checked))
								document.getElementsByName("ss_evalid")[0].checked=false;
         			}
         		</script>
					<h3>Email Validation Required
					<input name='ss_evalid' type='checkbox' onclick='syncEmailSiteSettings("v");' title='User must click a link sent by email'
						<?php
							if (isset($_POST['ss_evalid'])&&($_POST['ss_evalid']=='on'))
								echo "checked='checked'";
						?>
					/>
	         	</h3>
	         	
					<h3>Email Required
					<input name='ss_email' type='checkbox' onclick='syncEmailSiteSettings("e");'
						<?php
							if (isset($_POST['ss_email'])&&($_POST['ss_email']=='on'))
								echo "checked='checked'";
						?>
					/>
	         	</h3>

					<h3>Name Required
					<input name='ss_name' type='checkbox' 
						<?php
							if (isset($_POST['ss_name'])&&($_POST['ss_name']=='on'))
								echo "checked='checked'";
						?>
					/>
	         	</h3>
    	
					<h3>Country Required
					<input name='ss_country' type='checkbox' 
						<?php
							if (isset($_POST['ss_country'])&&($_POST['ss_country']=='on'))
								echo "checked='checked'";
						?>
					/>
	         	</h3>
	         	
					<h3>Gender Required
					<input name='ss_gender' type='checkbox' 
						<?php
							if (isset($_POST['ss_gender'])&&($_POST['ss_gender']=='on'))
								echo "checked='checked'";
						?>
					/>
	         	</h3>
	         	
					<h3>Date of Birth Required
					<input name='ss_dob' type='checkbox' 
						<?php
							if (isset($_POST['ss_dob'])&&($_POST['ss_dob']=='on'))
								echo "checked='checked'";
						?>
					/>
	         	</h3>
	         	
					<h3>Minimum Age
					<input name='ss_age' type='number' min='0' onclick="document.getElementsByName('ss_dob')[0].checked='on';"
						<?php
							if (isset($_POST['ss_age']))
								echo "value='{$_POST['ss_age']}'";
						?>
					/>
	         	</h3>
	         	




				</section>




            <h2>
            	<details><summary>Director's Account</summary>
			         <div class='helpbox'>
						<p>The application is installed with one initial account for
						the person who directs all affairs on this installation of the
						application. This person will most likely be you if you are
						installing this and this initial account can be used to create
						other administrative accounts on the system.
						</p>
						<p>An email address is <em>required</em> since it will be used
						in various parts of the web application as a basic point of
						contact for people making general enquiries.
						</p>
						<p>You will also need to provide a username and a password for
						the initial directors account here and these credentials will
						be used for you to login into the application once it has been
						installed.
						</p>
			         </div>
					</details>
				</h2>
            <section <?php if ($adm_info_complete) echo " class='complete'"; ?>>

            	<h3>Email Address					
            	<input name='adm_email' type='email' placeholder='webmaster@example.com'
            		<?php
							if (isset($_POST['adm_email'])&&($_POST['adm_email']!=false))
								echo "value='{$_POST['adm_email']}'";
							else
								echo "value='webmaster@{$_SERVER['SERVER_NAME']}'";
				   	?>
					/>
	         	</h3>
					
					<h3>Username					
					<input name='adm_user' placeholder='Directors Username'
						<?php
							if (isset($_POST['adm_user'])&&($_POST['adm_user']!=false))
								echo "value='{$_POST['adm_user']}'";	
							else
								echo "value='admin'";
						?>
					/></h3>
					
					<h3>Password
					<input name='adm_pass' type='password' placeholder='Directors Password'
						<?php
							if (isset($_POST['adm_pass'])&&($_POST['adm_pass']!=false))
								echo "value='".$app->decrypt(hex2bin($_POST['adm_pass']),hex2bin($app->token))."'";
//the live system should not autofill this default
//else echo "value='password'";
						?>
					/></h3>


				
            </section>




            <h2>
            	<details><summary>Database Information</summary>
			         <div class='helpbox'>
			         <p>This application needs to connect to a MySql database
			         server in order to work. You're hosting provider will provide
			         you with the database <b><u>hostname</u></b> in the form of a
			         domain name or an IP address. It is often set to <q>localhost
			         </q>. Similarly, your hosting provider will also provide you
			         with the <b><u>port</u></b> at which you by which to connect
			         to the database server on the host at <b><u>hostname</u></b>.
			         The default <b><u>port</u></b> for a MySql server is <q>3306
			         </q> but it may differ depending on how your hosting provider
			         has set it up. You should consult their help pages if you have
			         problems working out what the right <b><u>hostname</u></b> and
			         <b><u>port</u></b> are for you database server.
			         </p>
			         <p>You will need create a new database on the database server
			         using cPanel, PhpMySql or some other means by which you can
			         create a new database using a <b><u>Database Name</u></b> you
			         can set to whatever name you wish but you must provide this
			         <b><u>Database Name</u></b> also here.
			         </p>
			         <p>You will also need to either create a new <b><u>Database
			         User</u></b> user with a <b><u>Database User Password</u></b>
			         or provide an existing<b><u>Database Username</u></b> with the
			         appropriate <b><u>Database User Password</u></b> for the <b>
			         <u>Database Username</u></b> you provide. This <b><u>Database
			         User</u></b> must be given full permissions to use the newly
			         created database you are providing here in the <b><u>Database
			         Name</u></b> field. 
                  </p>
                  <p>If you have access to aterminal through cPanel, ssh or some
                  special page your hosting provider has created to allow you to
                  interact with your hosts command line interface, the following
                  script will create a new database and user with the default
                  settings of this installation.
                  </p>
                  <code>sudo mysql -e "create database dbname;grant all on dbname.* to 'dbuser'@'localhost' identified by 'dbpass';";
                  </code>
                  <p>You may need to adjust the words <q>dbname</q>, <q>dbuser
                  </q>, <q>localhost</q> and <q>dbpass</q> according to your own
                  setup and preferences.
                  </p>
			         </div>
					</details>
				</h2>

				<?php
					// QUICK REFERENCE COMMENTS for dropping and creating db and user
					// sudo mysql -e "drop database dbname;drop user 'dbuser'@'localhost';";
					// sudo mysql -e "create database dbname;grant all on dbname.* to 'dbuser'@'localhost' identified by 'dbpass';";
				?>

            <section <?php if ($db_error===null) echo " class='complete'"; ?>>
					<h3>Database Hostname					
					<input name='db_host' placeholder='localhost'
					   <?php
					      if (isset($_POST['db_host'])&&($_POST['db_host']!=false))
					         echo "value='{$_POST['db_host']}'";
						   else
						      echo "value='localhost'";
					   ?>
					/>
					</h3>
					
					<h3>Database Port					
					<input name='db_port' placeholder='3306'
						<?php
							if (isset($_POST['db_port'])&&($_POST['db_port']!=false))
								echo "value='{$_POST['db_port']}'";
							else
								echo "value='3306'";
						?>
					/></h3>
					
					<h3>Database Name					
					<input name='db_name' placeholder='WebAppDB'
						<?php
							if (isset($_POST['db_name'])&&($_POST['db_name']!=false))
						 		echo "value='{$_POST['db_name']}'";
							else
								echo "value='GDSWADB'";
						?>
					/></h3>
					
					<h3>Database Username					
					<input name='db_user' placeholder='WebAppUser'
						<?php
							if (isset($_POST['db_user'])&&($_POST['db_user']!=false))
								echo "value='{$_POST['db_user']}'";	
							else
								echo "value='GDSWAUSR'";
						?>
					/></h3>
					
					<h3>Database User Password
					<input name='db_pass' type='password' placeholder='WebAppPassword'
						<?php
							if (isset($_POST['db_pass'])&&($_POST['db_pass']!=false))
								echo "value='".$app->decryptHex($_POST['db_pass'],$app->token)."'";
							else
								echo "value='password'";
						?>
					/></h3>
	            <?php if ($db_error){echo "<br/><b style='color:red;'>$db_error</b>";}?>
            </section>



			
				<h3 class='center'><input type='submit' value='Create' /></h3>
				<input type='hidden' name='token' value='<?php echo $app->token; ?>' />
				<br/><br/>



         </article>
		</form>

<?php
	}
?>


		<br/>


<?php
	$app->renderFooter();
	$app->renderTail();
?>
