<?php



	/******************************************\
	* Web Application 4.0 by SCFDuffy (C) 2021 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 4.0 Installer by SCFDuffy - (C)February 2021 *
	\**************************************************************/





	require_once('../classes/Application.php');
	
	ob_start(); //no flush until cookies set

	$app=new Application();

	$at=false; $lu=false; $lp=false; $success=false;
	$luerr=''; $lperr='';
	$focus='lu';
	if (isset($_POST['token'])&&($_POST['token']!=false))
		$at=$_POST['token'];
	if (isset($_POST['lu'])&&($_POST['lu']!=false))
		$lu=$app->decryptHex($_POST['lu'],$app->token);
	if (isset($_POST['lp'])&&($_POST['lp']!=false))
		$lp=$app->decryptHex($_POST['lp'],$app->token);
	if ($at){
		if (!$lu) $luerr='You must supply a username';
		else {
			$focus='lp';
			if (!$lp) $lperr='You must supply a password';
			else {
				$record=$app->getUser($lu);
				if ((!$record)||(!password_verify($lp,$record['password']))){
					$luerr=false;
					$lperr="These details do not match our records.";
				}
				else{
					$app->login($record);
					$luerr=false;
					$lperr=false;
					$success=true;
				}
			}
		}
	}
	
	ob_end_flush(); //cookies set so flush the buffer onto page
	
if ($success){

?>
<body onload="parent.app.closeFrameReload('dialogue');"></body></html>
<?php } else {
	$app->renderHead("Login - {$app->sitename}",'SCFDuffy','Login, Username, Password, Log In',"Login page for {$app->sitename}");
?>

<style>
	body{background:none;}
	table{position:fixed;width:100%;height:100%;table-layout:auto;text-align:center;}
	article{text-align:center;display:inline-block;border:0.125rem outset #ccc;}
	section{text-align:right;display:block;border:none;}
	.error{color:red;text-align:center;font-size:1rem;padding-top:0; margin-top:0;}
</style>
<script>
	function ignoreClick(ev){ev.cancelBubble=true;} //clicking on the dialogue itself doesnt close the signup screen
	function keyHandler(e){if (e.code==='Escape') closeFrame();}
	function closeFrame(){
		document.removeEventListener('keyup',keyHandler);
		document.getElementById('dialogue').removeEventListener('click',ignoreClick);
		document.body.removeEventListener('click',closeFrame);
		parent.app.closeFrame('dialogue');
	}
	function safepost(){
		var form=document.getElementById('mainform');	
		var token=document.getElementsByName('token')[0].value;
		var lu=document.getElementsByName('lu')[0];
		var lp=document.getElementsByName('lp')[0];
		lu.value=app.encryptHex(lu.value,token);
		lp.value=app.encryptHex(lp.value,token);
		form.submit();
		lu.value=app.decryptHex(lu.value,token);
		lp.value=app.decryptHex(lp.value,token);
		return false;
	}
	function init(){
		app=new Website();
		document.body.addEventListener('click',closeFrame);
		document.addEventListener('keyup',keyHandler);		
		document.getElementById('dialogue').addEventListener('click',ignoreClick);
		document.getElementsByName('<?php echo $focus; ?>')[0].focus();
	}
</script>

	<table><tr><td></td><td></td><td></td></tr><tr><td></td><td>
		<article id='dialogue'>
			<h1>Login</h1>
			<section>
				<form id='mainform' method='post' onsubmit='return safepost();' autocomplete='off'>
					<h3>Username					
					<input name='lu' placeholder='Username'
						<?php
							if (isset($_POST['lu'])&&($_POST['lu']!=false))
								echo "value='".$app->decryptHex($_POST['lu'],$app->token)."'";
						?>
					/>
					<?php if ($luerr) echo "<div class='error'>$luerr</div>"; ?>
					</h3>
					
					<h3>Password
					<input name='lp' type='password' placeholder='Password'
						<?php
							if (isset($_POST['lp'])&&($_POST['lp']!=false))
								echo "value='".$app->decryptHex($_POST['lp'],$app->token)."'";
						?>
					/>
					<?php if ($lperr) echo "<div class='error'>$lperr</div>"; ?>
					</h3>

					<p class='center'>
						<input type='submit' value='login' />
						<input type='button' value='cancel' onclick='closeFrame();' />
					</p>

					<input type='hidden' name='token' value='<?php echo $app->token; ?>' />
				</form>
			</section>
			<p class='center'>
				<a target='_top' href='<?php echo $app->homedir.'main/special/recover.php'; ?>'>
					Forgotten your login details?
				</a>
			</p>
		</article>
	</td><td></td></tr><tr><td></td><td></td><td></td></tr></table>
<?php
	$app->renderTail();
} ?>
