<?php



	/******************************************\
	* Web Application 4.0 by SCFDuffy (C) 2021 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 4.0 Installer by SCFDuffy - (C)February 2021 *
	\**************************************************************/



	require_once('../classes/Application.php');
	ob_start();

	$app=new Application();
	$target=$app->account['username'];
	if (isset($_GET['view'])) $target=$_GET['view'];
	$app->renderHead("$target profile - {$app->sitename}",'SCFDuffy','Profile, Member, User, Details, Bio',"Profile page for a member of {$app->sitename}");
	$app->renderHeader();

	if (!$app->account){
?>
	<article>
		<h1>User Profile</h1>
		<section class='center'>
		<p>You must be logged in to your account to see this page.
		</p>
		<p>Click the back button or login to your account.
		</p>
		</section>
	</article>
<?php
	} else if ($app->account['username']==$target) {
		$averr='';$uerr='';$eerr='';$cterr='';$ferr='';$lerr='';$berr='';
		$avatar=$app->account['icon_url'];
		if ($avatar=='') $avatar='main/style/glyphs/anonymous.png';
		if (isset($_FILES['pr_av']['tmp_name'])&&($_FILES['pr_av']['tmp_name']!='')){
			if ($_FILES['pr_av']['size']>=1048576) $averr='File too large. File must be less that 1 megabyte.';
			else{
				if (!file_exists($app->homepath.'main/user/avatars')) mkdir($app->homepath.'main/user/avatars',0774,true);
				$avext=strtolower(pathinfo(basename($_FILES["pr_av"]["name"]),PATHINFO_EXTENSION));
				do $avfilename='main/user/avatars/'.time().rand(1000,9999).'.png';
				while (file_exists($app->homepath.$avfilename));
				$avres=false;
				switch ($avext){
					case 'jpg':
					case 'jpeg':	$avres=imagecreatefromjpeg($_FILES["pr_av"]["tmp_name"]); break;
					case 'gif':		$avres=imagecreatefromgif($_FILES["pr_av"]["tmp_name"]); break;
					case 'png':		$avres=imagecreatefrompng($_FILES["pr_av"]["tmp_name"]); break;
					case 'webp':	$avres=imagecreatefromwebp($_FILES["pr_av"]["tmp_name"]); break;
					case 'bmp':		$avres=imagecreatefrombmp($_FILES["pr_av"]["tmp_name"]); break;
					default: 		$averr='Image must be a gif, jpg, jpeg, png, webp or bmp.'; break;
				}
				if ($avres===false) $averr='File is corrupted!';
				else{
					if ( imagesx($avres) > imagesy($avres) ) $i0=imagescale($avres,128,-1,IMG_BICUBIC_FIXED);
					else $i0=imagescale($avres,128*(imagesx($avres)/imagesy($avres)),128,IMG_BICUBIC_FIXED);
					imagedestroy($avres);
					$i128=imagecreatetruecolor(128,128);
					imageSaveAlpha($i128,true);
					imagefill($i128,64,64,imagecolorallocatealpha($i128,0,0,0,127));
					imagecopy($i128,$i0,(128-imagesx($i0))/2,(128-imagesy($i0))/2,0,0,imagesx($i0),imagesy($i0));
					imagedestroy($i0);
					imagepng($i128,$app->homepath.$avfilename);
					imagedestroy($i128);
					if (strpos($avatar,'main/user/avatars')!==false) unlink($app->homepath.$avatar);
					$avatar=$avfilename;
					$app->editUser($app->account['uuid'],'icon_url',$avatar);
				}
			}
		}
		else{
			include($app->homepath.'main/scripts/pregs.php');
			if ((isset($_POST['pr_u']))&&($_POST['pr_u']!='')){
				if (!preg_match($pregs['username'],$_POST['pr_u'])) $uerr='Illegal characters in username';
				else if (($app->account['username']!==$_POST['pr_u'])&&($app->getUser($_POST['pr_u']))) $uerr='Username already taken';
				else{
					$app->editUser($app->account['uuid'],'username',$_POST['pr_u']);
					$app->account['username']=$_POST['pr_u'];
					$app->login($app->account);
				}
			}
			if ((isset($_POST['pr_e']))&&($_POST['pr_e']!='')){
				if (!preg_match($pregs['email'],$_POST['pr_e'])) $eerr='Inavalid Email Address';
				else if (($app->account['email']!==$_POST['pr_e'])&&($app->getUserByEmail($_POST['pr_e']))) $eerr="There is already an account associated with this email address<br/>You can reset it using the <a href='{$app->homedir}main/special/recover.php'>Recovery Page</a>";
				else $app->editUser($app->account['uuid'],'email',$_POST['pr_e']);
			}
			if ((isset($_POST['pr_ct']))&&($_POST['pr_ct']!='')){
				if (!preg_match($pregs['city'],$_POST['pr_ct'])) $cterr='Illegal characters in city name';
				else $app->editUser($app->account['uuid'],'city',$_POST['pr_ct']);
			}
			if ((isset($_POST['pr_f']))&&($_POST['pr_f']!='')){
				if (!preg_match($pregs['name'],$_POST['pr_f'])) $ferr='Illegal characters in name';
				else $app->editUser($app->account['uuid'],'first_name',$_POST['pr_f']);
			}
			if ((isset($_POST['pr_l']))&&($_POST['pr_l']!='')){
				if (!preg_match($pregs['name'],$_POST['pr_l'])) $lerr='Illegal characters in name';
				else $app->editUser($app->account['uuid'],'last_name',$_POST['pr_l']);
			}
			if ((isset($_POST['pr_g']))&&($_POST['pr_g']!='')){
				$app->editUser($app->account['uuid'],'gender',$_POST['pr_g']);
			}
			if ((isset($_POST['pr_c']))&&($_POST['pr_c']!='')){
				$app->editUser($app->account['uuid'],'country',$_POST['pr_c']);
			}
			if ((isset($_POST['pr_d']))&&($_POST['pr_d']!='')){
				if (!preg_match($pregs['dob'],$_POST['pr_d'])) $derr='Invalid date of birth';
				else $app->editUser($app->account['uuid'],'dob',$_POST['pr_d']);
			}
			if ((isset($_POST['pr_b']))&&($_POST['pr_b']!='')){
				$bio=$_POST['pr_b'];
				$app->editUser($app->account['uuid'],'bio',$bio);
			}
			$app->account=$app->getUserByUUID($app->account['uuid']);
		}
?>
	<h1>User Profile</h1>
	<article class='center'>
		<h1><?php echo $app->account['username']; ?></h1>
		<p class='center'>(<?php echo $app->account['account_type']; ?>)</p>
		<p class='center'>Joined on <?php echo Date("l \\t\h\\e dS \of F Y \a\\t g:ia",$app->account['creation_time']); ?></p>

		<h2>Avatar</h2>
		<section style='text-align:right; display:inline-block;'>
	      <form id='avform' enctype='multipart/form-data' method='post'>
				<div class='center'>
					<img src='<?php echo $app->homedir.$avatar; ?>' style='width:6rem;' /><br/>
					<input name='pr_av' type='file' /></br>
					<input type='submit' value='upload' />
					<p style='color:red;'><?php echo $averr; ?></p>
				</div>
			</form>				
		</section>

		<h2>Information</h2>
		<section style='text-align:right; display:inline-block;'>
	      <form id='mainform' method='post'>
				<h3>Username
					<input name='pr_u' value='<?php if (isset($_POST['pr_u'])) echo $_POST['pr_u']; else echo$app->account['username']; ?>' />
					<p style='color:red;'><?php echo $uerr; ?></p>
				</h3>
				<h3>Email
					<input name='pr_e' value='<?php echo $app->account['email']; ?>' />
					<p style='color:red;'><?php echo $eerr; ?></p>
				</h3>
				<h3>Country
					<select name='pr_c'>
						<?php
							echo "<option value=''></option>";
							$countryList=explode("\n",file_get_contents($app->homepath.'main/scripts/countries.list'));
							foreach ($countryList as $country){
								if ($country===$app->account['country']) $selected="selected='true'"; else $selected='';
								echo "<option value='$country' $selected>$country</option>";
							}
						?>
					</select>
				</h3>
				<h3>City
					<input name='pr_ct' value='<?php echo $app->account['city']; ?>' />
					<p style='color:red;'><?php echo $cterr; ?></p>
				</h3>
				<h3>First Name
					<input name='pr_f' value='<?php echo $app->account['first_name']; ?>' />
					<p style='color:red;'><?php echo $ferr; ?></p>
				</h3>
				<h3>Last Name
					<input name='pr_l' value='<?php echo $app->account['last_name']; ?>' />
					<p style='color:red;'><?php echo $lerr; ?></p>
				</h3>
				<h3>Date of Birth
					<input type='date' name='pr_d' value='<?php echo $app->account['dob']; ?>' />
					<p style='color:red;'><?php echo $derr; ?></p>
				</h3>
				<h3>Gender
					<select name='pr_g'>
						<option value=''></option>
						<option value='male' <?php if ($app->account['gender']==='male') echo "selected='true'"; ?>>Male</option>
						<option value='female' <?php if ($app->account['gender']==='female') echo "selected='true'"; ?>>Female</option>
					</select>					
				</h3>
				<div class='center'>
					<h3>About Me</h3>
					<textarea name='pr_b' style='height:6rem;width:90%;text-align:left;'><?php echo $app->account['bio']; ?></textarea>
					<p style='color:red;'><?php echo $berr; ?></p>
					<br/>
					<input type='submit' value='Submit Changes' />
				</div>
			</form>
		</section>

		<h2>Password</h2>
		<section style='text-align:center; display:inline-block;'>
			<p>This button will take you to the password reset page.</p>
			<button onclick='location.assign("<?php echo $app->homedir.'main/special/recover.php'; ?>")'>Reset Password</button>
		</section>

	</article>
<?php
	}
	else{	//this is a target profile - ie its an indeditable profile of another user
		$target=$app->getUser($target);
		if ($target==false){
			$target=$_GET['view'];
?>
	<h1>User Profile</h1>
	<article>
		<section class='center'>
		<p>There is no such user <q><?php echo $target; ?></q> on the system. This
		may be because the user has changed their name or they have had their 
		account deleted or it could be that you attempted to access this page
		through an unorthodox means such as directly typing the get parameter
		into the browser address field.
		</p>
		<p>In any case, the user does not exist.
		</p>
		</section>
	</article>
<?php
		}
		else{
			$avatar=$target['icon_url'];
			if ($avatar=='') $avatar='main/style/glyphs/anonymous.png';
			$name=$target['username'];
			if (($target['first_name']!='')||($target['last_name']!='')) $name="{$target['first_name']} {$target['last_name']}";
			$age=false;
			if ($target['dob']!='') $age=date_diff(new DateTime($target['dob']),new DateTime('now'))->format('%y');
			$place='';
			if ($target['city']!='') $place.=$target['city'];
			if ($target['country']!=''){
				if ($place!='') $place.=', ';
				$place.=$target['country'];
			}
			if ($target['gender']==='male'){$gen1='he';$gen2='has';$gen3='himself';$gen4='He';$gen5='is';$gen6='lives';}
			else if ($target['gender']==='female'){$gen1='she';$gen2='has';$gen3='herself';$gen4='She';$gen5='is';$gen6='lives';}
			else{$gen1='they';$gen2='have';$gen3='themself';$gen4='They';$gen5='are';$gen6='live';}
			if ($target['bio']!='') $about="This is what $gen1 $gen2 to say about $gen3:";
			else $about="$gen4 $gen2 not provided any further information about $gen3.";
?>
	<h1>User Profile</h1>
	<article class='center'>
		<section>
			<img src='<?php echo $app->homedir.$avatar; ?>' style='width:6rem;' /><br/>
			<h1><?php echo $target['username']; ?></h1>
			<p style='text-align:left;'>
			<?php
				echo "<b>$name</b> holds <b>{$target['account_type']}</b> membership with us, having joined on <b>";
				echo Date("l \\t\h\\e dS \of F Y \a\\t g:ia",$target['creation_time']);
				echo "</b>";
				if ($age!==false) echo ". $gen4 $gen5 <b>$age</b> years of age";
				if ($place!==''){
					if ($age!=false) echo " and";
					else echo ". $gen4";
					echo " $gen1 $gen6 in <b>$place</b>";
				}
				echo ". $about";
				if ($target['bio']!=''){
			?>
					<p><textarea disabled='true' style='height:6rem;width:90%;text-align:left;'><?php echo $target['bio']; ?></textarea></p>
			<?php
				}
				echo " $gen4 last logged in on <b>";
				echo Date("l \\t\h\\e dS \of F Y \a\\t g:ia",$target['last_login']);
				echo "</b>.";
			?>
			</p>
		</section>
	</article>
<?php
		}
	}
	$app->renderFooter();
	$app->renderTail();
	ob_end_flush();
?>
