<?php



	/******************************************\
	* Web Application 4.0 by SCFDuffy (C) 2021 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 4.0 Installer by SCFDuffy - (C)February 2021 *
	\**************************************************************/



	require_once('../classes/Application.php');
	ob_start();
	$app=new Application();
	include($app->homepath.'main/scripts/pregs.php');
	$success=false;
	if (($app->account==null)&&(isset($_GET['rc_q']))&&($_GET['rc_q']!='')&&(isset($_GET['rc_e']))&&($_GET['rc_e']!='')){
		$user=$app->getUserByEmail(hex2bin($_GET['rc_e']));
		if ($user!==false){
			if ($user['username']===$app->decryptHex($_GET['rc_q'],bin2hex($user['password']))){
				$app->account=$user;
				if ((isset($_POST['token']))&&($_POST['token']!='')&&(isset($_POST['rc_p']))&&($_POST['rc_p']!='')&&(isset($_POST['rc_c']))&&($_POST['rc_c']!='')&&($_POST['rc_p']===$_POST['rc_c'])){
					$passhash=password_hash($app->decryptHex($_POST['rc_p'],$_POST['token']),PASSWORD_DEFAULT);
					$app->editUser($user['uuid'],'password',$passhash);
					$app->login($app->getUserByUUID($user['uuid']));
					$success=true;
				}
			}
		}
	}
	else if (($app->account!==null)&&(isset($_POST['token']))&&($_POST['token']!='')&&(isset($_POST['rc_p']))&&($_POST['rc_p']!='')&&(isset($_POST['rc_c']))&&($_POST['rc_c']!='')&&($_POST['rc_p']===$_POST['rc_c'])){
		$passhash=password_hash($app->decryptHex($_POST['rc_p'],$_POST['token']),PASSWORD_DEFAULT);
		$app->editUser($app->account['uuid'],'password',$passhash);
		$app->login($app->getUserByUUID($app->account['uuid']));
		$success=true;				
	}

	$app->renderHead("Recover - {$app->sitename}",'SCFDuffy','Account, Password, Recover, Recovery, Usernme',"Account recovery for {$app->sitename}");
	$app->renderHeader();
	ob_end_flush();
	if ($app->account==null){
		$account=null;
		if (
			(isset($_POST['rc_e']))
			&&($_POST['rc_e']!='')
			&&(preg_match($pregs['email'],$_POST['rc_e'])!==0)
			&&(($account=$app->getUserByEmail($_POST['rc_e']))!=false)			
		){
			$recoveryLink=$app->homeurl.'main/special/recover.php?rc_e='.bin2hex($_POST['rc_e']).'&rc_q='.$app->encryptHex($account['username'],bin2hex($account['password']));
			$recoveryMail="
Dear {$account['username']}\n,
\n
We received a request for a password reset on your account with us at\n
{$app->sitename}.\n
\n
The following link will allow you to reset the password for this account. You\n
should click on it or copy and paste it into a browser in order to reset the\n
password for your account.\n
\n
$recoveryLink\n
\n
Thanks for your continued membership.\n
\n
{$app->sitename}.\n
";
			$app->automailer($_POST['rc_e'],$app->sitename.' account recovery',$recoveryMail);
//echo $recoveryMail;
?>

	<article>
		<h1>Recovery Email Sent</h1>
		<section>
			<p>We have sent a recovery email to <?php echo $_POST['rc_e']; ?>. It
			should be with you shortly. The email contains your username and a link
			you should either click or copy and paste into your browser. This link
			will take you to a page where you can reset your password. You should
			be able to change your username from your profile once your password is
			reset.
			</p>
			<p>If you are still having problems recovering your username, in some
			circumstances, <a href='mailto:<?php echo $app->mainmail; ?>'>emailing
			the administrator</a> can resolve your problem, if for example, you are
			experiencing a bug or you are a very well known user to our community.
			</p>
		</section>
	</article>

<?php
		} else {
			//no email provided yet
?>

	
	<article>
		<h1>Account Recovery</h1>
		<section>
			<p>If you have lost your password or forgotten your username, you can
			recover it if there is an email address associated with your account.
			Please fill out your email address below and if there is such an email
			address on our records, an email will be sent to it containing your
			username and a link you can click or copy and paste into a browser to
			reset the password for your account.
			</p>
			<form class='center' method='post'>
				<input name='rc_e' type='email' autofocus=1 placeholder='john.smith@example.com' />
				<?php if (preg_match($pregs['email'],$_POST['rc_e'])===0) echo "<p style='color:red;'>Invalid Email Address</p>";?>
				<input type='submit' value='send' />
			</form>
			<p>If you are still having problems recovering your username, in some
			circumstances, <a href='mailto:<?php echo $app->mainmail; ?>'>emailing
			the administrator</a> can resolve your problem, if for example, you are
			experiencing a bug or you are a very well known user to our community.
			</p>
		</section>
	</article>

<?php
		} //end of no email provided condition
	} else { //$app->account!=null
		if ($success){
?>
	<script>
		var rc_tick=5;
		function pageInit(){
			document.getElementById('rc_tick').innerHTML=rc_tick--;
			if (rc_tick==0) location.assign(<?php echo "'{$app->homeurl}'"; ?>);
			else setTimeout(pageInit,1000);
		}
	</script>
	<article>
		<h1>Password Reset</h1>
		<section>
			<p>You're password has been reset and you have been logged into the
			system. You will be redirected to the main page in <b id='rc_tick'></b>
			seconds.
			</p>
		</section>
	</article>

<?php
		} else {
?>

	<script>
	function safepost(){
		var form=document.getElementById('rc_form');	
		var token=document.getElementsByName('token')[0].value;
		var rcp=document.getElementsByName('rc_p')[0];
		var rcc=document.getElementsByName('rc_c')[0];
		rcp.value=app.encryptHex(rcp.value,token);
		rcc.value=app.encryptHex(rcc.value,token);
		form.submit();
		rcp.value=app.decryptHex(rcp.value,token);
		rcc.value=app.decryptHex(rcc.value,token);
		return false;
	}
	</script>

	<article>
		<h1>Reset Password</h1>
		<section>
			<p>This is the password reset page. Please type in your new password
			in the field below and then type it in again in the next field to be
			sure there aren't any typographical errors.
			</p>
			<div style='text-align:center;'>
				<form id='rc_form' onsubmit='return safepost();' method='post' style='display:inline-block; text-align:right;'>
					<input type='hidden' name='token' value='<?php echo $app->token; ?>' />

					<h3>New Password
					<input name='rc_p' type='password' autofocus=1 placeholder='password'
						<?php
							if (isset($_POST['rc_p']))
								echo "value='".$app->decryptHex($_POST['rc_p'],$app->token)."'"; 
						?>
					/>
					</h3>
					<?php
						if (  (isset($_POST['rc_p']))    &&    ($_POST['rc_p']!='')    &&    ( (!isset($_POST['rc_c'])) || ($_POST['rc_c']=='') )  )
							echo "<p style='color:red;'>You need to create a password.</p>";
					?>
					<h3>Confirm Password
					<input name='rc_c' type='password'  placeholder='password confirmation'
						<?php
							if ((isset($_POST['rc_c'])))
								echo "value='".$app->decryptHex($_POST['rc_c'],$app->token)."'";
						?>
					/>
					</h3>
					<?php
						if (  (isset($_POST['rc_c']))    &&    ($_POST['rc_c']!='')    &&    ( (!isset($_POST['rc_p'])) || ($_POST['rc_p']=='') )  )
							echo "<p style='color:red;'>You need to retype your chosen password to confirm it.</p>";
					?>
					<input type='submit' value='send' />
				</form>
			</div>
			<p>If you are still having problems recovering your username, in some
			circumstances, <a href='mailto:<?php echo $app->mainmail; ?>'>emailing
			the administrator</a> can resolve your problem, if for example, you are
			experiencing a bug or you are a very well known user to our community.
			</p>
		</section>
	</article>
	
<?php
		}
	}
	$app->renderFooter();
	$app->renderTail();
?>