<?php



	/******************************************\
	* Web Application 4.0 by SCFDuffy (C) 2021 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 4.0 Installer by SCFDuffy - (C)February 2021 *
	\**************************************************************/



	require_once('../classes/Application.php');
	ob_start();
	$app=new Application();
	if (($app->account['account_type']!=='director')&&($app->account['account_type']!=='administrator')){
		$app->renderHead("Setup - {$app->sitename}",'SCFDuffy','Setup, Install, Configuration, Options, Config',"Setup page for for {$app->sitename}");
		$app->renderHeader();
		echo "<article><h1>Page Unavailable</h1><section><center>This page is only available to administrators.</center></section></article>";
		$app->renderFooter();
		$app->renderTail();
		exit;
	}

	$errfocus=false;
	if (!count($_POST)) $errfocus='none';
	//ICON DETECTION AND CREATION CODE
	$icon_error='';
	if (isset($_FILES['site_icon']['tmp_name'])&&($_FILES['site_icon']['tmp_name']!='')){
		if (getimagesize($_FILES['site_icon']['tmp_name'])===false) $icon_error='No Image';
		else{
			if ($_FILES['site_icon']['size']>=1048576) $icon_error='File too large. File must be less that 1 megabyte.';
			else{
				$icon_extension=strtolower(pathinfo(basename($_FILES["site_icon"]["name"]),PATHINFO_EXTENSION));
				switch ($icon_extension){
					default: $icon_error='Image must be a gif, jpg, jpeg, png, webp or bmp.'; break;
					case 'gif': case 'jpg': case 'jpeg': case 'png': case 'webp': case 'bmp': {
						if (!file_exists($app->homepath.'main/style/icons')) mkdir($app->homepath.'main/style/icons',0774,true);
						$icon_filename='main/style/icons/siteicon.'.$icon_extension;
						$icon_res=false;
						switch($icon_extension){
							case 'jpg':
							case 'jpeg':	$icon_res=imagecreatefromjpeg($_FILES["site_icon"]["tmp_name"]); break;
							case 'gif':		$icon_res=imagecreatefromgif($_FILES["site_icon"]["tmp_name"]); break;
							case 'png':		$icon_res=imagecreatefrompng($_FILES["site_icon"]["tmp_name"]); break;
							case 'webp':	$icon_res=imagecreatefromwebp($_FILES["site_icon"]["tmp_name"]); break;
							case 'bmp':		$icon_res=imagecreatefrombmp($_FILES["site_icon"]["tmp_name"]); break;
						}
						if ($icon_res===false) $icon_error='File is corrupted!';
						else{
							if ( imagesx($icon_res) > imagesy($icon_res) ) $i0=imagescale($icon_res,512,-1,IMG_BICUBIC_FIXED);
							else $i0=imagescale($icon_res,512*(imagesx($icon_res)/imagesy($icon_res)),512,IMG_BICUBIC_FIXED);
							imagedestroy($icon_res);
							$i512=imagecreatetruecolor(512,512);
							imageSaveAlpha($i512,true);
							imagefill($i512,256,256,imagecolorallocatealpha($i512,0,0,0,127));
							imagecopy($i512,$i0,(512-imagesx($i0))/2,(512-imagesy($i0))/2,0,0,imagesx($i0),imagesy($i0));
							imagedestroy($i0);
							$homepath=$app->homepath.'main/style/icons/';
							unlink($homepath.'mainicon.png');
 							imagepng($i512,$homepath.'mainicon.png');
							$i0=imagescale($i512,512,512,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-chrome-512x512.png');imagedestroy($i0);
							$i0=imagescale($i512,310,310,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'ms-icon-310x310.png');imagedestroy($i0);
							$i0=imagescale($i512,192,192,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-chrome-192x192.png');imagedestroy($i0);
							$i0=imagescale($i512,192,192,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-icon-192x192.png');imagedestroy($i0);
							$i0=imagescale($i512,192,192,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon.png');imagedestroy($i0); 
							$i0=imagescale($i512,180,180,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-180x180.png');imagedestroy($i0);
							$i0=imagescale($i512,180,180,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-touch-icon.png');imagedestroy($i0); 
							$i0=imagescale($i512,152,152,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-152x152.png');imagedestroy($i0);
							$i0=imagescale($i512,150,150,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'ms-icon-150x150.png');imagedestroy($i0);
							$i0=imagescale($i512,144,144,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-icon-144x144.png');imagedestroy($i0);
							$i0=imagescale($i512,144,144,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-144x144.png');imagedestroy($i0);
							$i0=imagescale($i512,144,144,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'ms-icon-144x144.png');imagedestroy($i0);
							$i0=imagescale($i512,120,120,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-120x120.png');imagedestroy($i0);
							$i0=imagescale($i512,114,114,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-114x114.png');imagedestroy($i0);
							$i0=imagescale($i512,96,96,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-icon-96x96.png');imagedestroy($i0);
							$i0=imagescale($i512,96,96,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'favicon-96x96.png');imagedestroy($i0);
							$i0=imagescale($i512,76,76,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-76x76.png');imagedestroy($i0);
							$i0=imagescale($i512,72,72,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-icon-72x72.png');imagedestroy($i0);
							$i0=imagescale($i512,72,72,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-72x72.png');imagedestroy($i0);
							$i0=imagescale($i512,70,70,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'ms-icon-70x70.png');imagedestroy($i0);
							$i0=imagescale($i512,60,60,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-60x60.png');imagedestroy($i0);
							$i0=imagescale($i512,57,57,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'apple-icon-57x57.png');imagedestroy($i0);
							$i0=imagescale($i512,48,48,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-icon-48x48.png');imagedestroy($i0);
							$i0=imagescale($i512,36,36,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'android-icon-36x36.png');imagedestroy($i0);
							$i0=imagescale($i512,32,32,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'favicon-32x32.png');imagedestroy($i0);
							$i0=imagescale($i512,16,16,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'favicon-16x16.png');imagedestroy($i0);
							$image_data=file_get_contents($homepath.'favicon-16x16.png');$i0=pack('vvvCCCCvvVV',0,1,1,16,16,0,0,1,0,filesize($homepath.'favicon-16x16.png'),22);$i0.=$image_data;
							file_put_contents($homepath.'favicon.ico',$i0);
							if (!isset($_POST['site_icon_root'])) file_put_contents($app->rootpath.'/favicon.ico',$i0);
							unset($image_data,$i0);
							imagedestroy($i512);
 							file_put_contents("{$homepath}browserconfig.xml","<"."?xml version='1.0' encoding='utf-8'?"."><browserconfig><msapplication><tile><square70x70logo src='{$app->homedir}main/style/icons/ms-icon-70x70.png'/><square144x144logo src='{$app->homedir}main/style/icons/ms-icon-144x144.png'/><square150x150logo src='{$app->homedir}main/style/icons/ms-icon-150x150.png'/><square310x310logo src='{$app->homedir}main/style/icons/ms-icon-310x310.png'/><TileColor>#ffffff</TileColor></tile></msapplication></browserconfig>");
 							file_put_contents("{$homepath}IEconfig.xml","<"."?xml version='1.0' encoding='utf-8'"."?><browserconfig><msapplication><tile><square70x70logo src='{$app->homedir}main/style/icons/ms-icon-70x70.png'/><square144x144logo src='{$app->homedir}main/style/icons/ms-icon-144x144.png'/><square150x150logo src='{$app->homedir}main/style/icons/ms-icon-150x150.png'/><square310x310logo src='{$app->homedir}main/style/icons/ms-icon-310x310.png'/><TileColor>#ffffff</TileColor></tile></msapplication></browserconfig>");
							file_put_contents("{$homepath}site.webmanifest",'{"name":"","short_name":"","icons":[{"src":"'.$app->homedir.'main/style/icons/android-chrome-192x192.png","sizes":"192x192","type":"image/png"},{"src":"'.$app->homedir.'main/style/icons/android-chrome-512x512.png","sizes":"512x512","type":"image/png"}],"theme_color":"#ffffff","background_color":"#ffffff","display":"standalone"}');
							file_put_contents("{$homepath}manifest.json",'{"name":"App","icons":[{"src": "'.$app->homedir.'main\/style\/icons\/android-icon-36x36.png","sizes": "36x36","type": "image\/png","density": "0.75"},{"src": "'.$app->homedir.'main\/style\/icons\/android-icon-48x48.png","sizes": "48x48","type": "image\/png","density": "1.0"},{"src": "'.$app->homedir.'main\/style\/icons\/android-icon-72x72.png","sizes": "72x72","type": "image\/png","density": "1.5"},{"src": "'.$app->homedir.'main\/style\/icons\/android-icon-96x96.png","sizes": "96x96","type": "image\/png","density": "2.0"},{"src": "'.$app->homedir.'main\/style\/icons\/android-icon-144x144.png","sizes": "144x144","type": "image\/png","density": "3.0"},{"src": "'.$app->homedir.'main\/style\/icons\/android-icon-192x192.png","sizes": "192x192","type": "image\/png","density": "4.0"}]}');
							file_put_contents("{$homepath}iconmeta.htm","
<link rel='icon' type='image/x-icon' sizes='16x16' href='{$app->homedir}main/style/icons/favicon.ico' />
<link rel='icon' type='image/png' sizes='96x96' href='{$app->homedir}main/style/icons/favicon-96x96.png' />
<link rel='icon' type='image/png' sizes='32x32' href='{$app->homedir}main/style/icons/favicon-32x32.png' />
<link rel='icon' type='image/png' sizes='16x16' href='{$app->homedir}main/style/icons/favicon-16x16.png' />
<link rel='icon' type='image/png' sizes='512x512' href='{$app->homedir}main/style/icons/android-chrome-512x512.png' />
<link rel='icon' type='image/png' sizes='192x192' href='{$app->homedir}main/style/icons/android-chrome-192x192.png' />
<link rel='icon' type='image/png' sizes='192x192' href='{$app->homedir}main/style/icons/android-icon-192x192.png' />
<link rel='icon' type='image/png' sizes='144x144' href='{$app->homedir}main/style/icons/android-icon-144x144.png' />
<link rel='icon' type='image/png' sizes='96x96' href='{$app->homedir}main/style/icons/android-icon-96x96.png' />
<link rel='icon' type='image/png' sizes='72x72' href='{$app->homedir}main/style/icons/android-icon-72x72.png' />
<link rel='icon' type='image/png' sizes='48x48' href='{$app->homedir}main/style/icons/android-icon-48x48.png' />
<link rel='icon' type='image/png' sizes='36x36' href='{$app->homedir}main/style/icons/android-icon-36x36.png' />
<link rel='apple-icon' type='image/png' sizes='192x192' href='{$app->homedir}main/style/icons/apple-icon.png' />
<link rel='apple-touch-icon' type='image/png' sizes='180x180' href='{$app->homedir}main/style/icons/apple-icon-180x180.png' />
<link rel='apple-touch-icon' type='image/png' sizes='180x180' href='{$app->homedir}main/style/icons/apple-touch-icon.png' />
<link rel='apple-touch-icon' type='image/png' sizes='152x152' href='{$app->homedir}main/style/icons/apple-icon-152x152.png' />
<link rel='apple-touch-icon' type='image/png' sizes='144x144' href='{$app->homedir}main/style/icons/apple-icon-144x144.png' />
<link rel='apple-touch-icon' type='image/png' sizes='120x120' href='{$app->homedir}main/style/icons/apple-icon-120x120.png' />
<link rel='apple-touch-icon' type='image/png' sizes='114x114' href='{$app->homedir}main/style/icons/apple-icon-114x114.png' />
<link rel='apple-touch-icon' type='image/png' sizes='76x76' href='{$app->homedir}main/style/icons/apple-icon-76x76.png' />
<link rel='apple-touch-icon' type='image/png' sizes='72x72' href='{$app->homedir}main/style/icons/apple-icon-72x72.png' />
<link rel='apple-touch-icon' type='image/png' sizes='60x60' href='{$app->homedir}main/style/icons/apple-icon-60x60.png' />
<link rel='apple-touch-icon' type='image/png' sizes='57x57' href='{$app->homedir}main/style/icons/apple-icon-57x57.png' />
<meta name='msapplication-TileImage' content='{$app->homedir}main/style/icons/ms-icon-310x310.png' />
<meta name='msapplication-TileImage' content='{$app->homedir}main/style/icons/ms-icon-150x150.png' />
<meta name='msapplication-TileImage' content='{$app->homedir}main/style/icons/ms-icon-70x70.png' />
<meta name='msapplication-TileImage' content='{$app->homedir}main/style/icons/ms-icon-144x144.png' />
<meta name='msapplication-config' content='{$app->homedir}main/style/icons/browserconfig.xml' />
<meta name='msapplication-config' content='{$app->homedir}main/style/icons/IEconfig.xml' />
<link rel='manifest'	href='{$app->homedir}main/style/icons/manifest.json' />
<link rel='manifest' href='{$app->homedir}main/style/icons/site.webmanifest' />
<meta name='msapplication-TileColor' content='#ffffff' />
<meta name='theme-color' content='#ffffff' />
"
							);
						}
					}
				}
			}
		}
	}
	$icon_complete=false;
	if (file_exists($app->homepath.'main/style/icons/mainicon.png')) $icon_complete=true;
	else $errfocus="document.getElementsByName('site_icon')[0].focus();";


	//SITE INFORMATION DETECTION CODE
	$site_info_complete=false;
	if (
			(isset($_POST['site_name'])&&($_POST['site_name']!=false))&&
			(isset($_POST['auto_mail'])&&($_POST['auto_mail']!=false))
		){
		$site_info_complete=true;
	}
	else if (!$errfocus){
		if ((!isset($_POST['site_name']))||($_POST['site_name']==''))
			$errfocus="document.getElementsByName('site_name')[0].focus();";
		else if ((!isset($_POST['auto_mail']))||($_POST['auto_mail']==''))
			$errfocus="document.getElementsByName('auto_mail')[0].focus();";
	}


	//ADMIN INFORMATION DETECTION CODE
	$adminRecord=$app->getUserByUUID(1);
	$adminemail=$adminRecord['email'];
	$adminname=$adminRecord['username'];
	$adm_info_complete=false;
	if (
			(isset($_POST['adm_email'])&&($_POST['adm_email']!=false))&&
			(isset($_POST['adm_user'])&&($_POST['adm_user']!=false))&&
			(isset($_POST['adm_pass'])&&($_POST['adm_pass']!=false))
		){
		$adm_info_complete=true;
	}
	else if (!$errfocus){
		if (!isset($_POST['adm_email'])||($_POST['adm_email']==false)) $errfocus="document.getElementsByName('adm_email')[0].focus();";
		else
		if (!isset($_POST['adm_user'])||($_POST['adm_user']==false)) $errfocus="document.getElementsByName('adm_user')[0].focus();";
		else
		if (!isset($_POST['adm_pass'])||($_POST['adm_pass']==false)) $errfocus="document.getElementsByName('adm_pass')[0].focus();";
	}


	//DATABASE INFORMATION TESTING CODE
	$db_error=false;	//NB false!==null
	if (  //ARE ALL THE SETTINGS FOR THE DATABASE CONNECTION AVAILABLE?
			(isset($_POST['db_host'])&&($_POST['db_host']!=false))&&
			(isset($_POST['db_port'])&&($_POST['db_port']!=false))&&
			(isset($_POST['db_name'])&&($_POST['db_name']!=false))&&
			(isset($_POST['db_user'])&&($_POST['db_user']!=false))&&
			(isset($_POST['db_pass'])&&($_POST['db_pass']!=false))
		){
      $test=new mysqli($_POST['db_host'],$_POST['db_user'],$app->decrypt(hex2bin($_POST['db_pass']),hex2bin($app->token)),$_POST['db_name'],$_POST['db_port']);
      $db_error=$test->connect_error;
		unset($test);
	}
	else if (!$errfocus){
		if ((!isset($_POST['db_host']))||($_POST['db_host']==false)) $errfocus="document.getElementsByName('db_host')[0].focus();";
		else
		if ((!isset($_POST['db_port']))||($_POST['db_port']==false)) $errfocus="document.getElementsByName('db_port')[0].focus();";
		else
		if ((!isset($_POST['db_name']))||($_POST['db_name']==false)) $errfocus="document.getElementsByName('db_name')[0].focus();";
		else
		if ((!isset($_POST['db_user']))||($_POST['db_user']==false)) $errfocus="document.getElementsByName('db_user')[0].focus();";
		else
		if ((!isset($_POST['db_pass']))||($_POST['db_pass']==false)) $errfocus="document.getElementsByName('db_pass')[0].focus();";
	}


	//DATABASE TABLES CREATION CODE
	if (($site_info_complete)&&($icon_complete)&&($db_error===null)&&($adm_info_complete)){
		if (!$app->dbInit($_POST['db_host'],$_POST['db_port'],$_POST['db_name'],$_POST['db_user'],
		$app->decrypt(hex2bin($_POST['db_pass']),hex2bin($app->token)))) $db_error=$app->dbError();
		else{
			$adminRecord=$app->getUserByUUID(1);
			if ($adminRecord){
				$passhash=password_hash($app->decrypt(hex2bin($_POST['adm_pass']),hex2bin($app->token)),PASSWORD_DEFAULT);
				$app->editUser($adminRecord['uuid'],'username',$_POST['adm_user']);
				$app->editUser($adminRecord['uuid'],'password',$passhash);
				$app->editUser($adminRecord['uuid'],'email',$_POST['adm_email']);
				$app->login($app->getUserByUUID($app->account['uuid']));
			}

			if ($app->db->errno!==0) $db_error=$app->db->error;
			else{
				$newuser=$app->getUser($_POST['adm_user']);
				$app->editUser($newuser['uuid'],'icon_url','main/style/glyphs/anonymous.png');
				$config_file="<?php\n";
				$config_file.="\$Settings['sitename']='{$_POST['site_name']}';\n";
				$config_file.="\$Settings['automail']='{$_POST['auto_mail']}';\n";
				$config_file.="\$Settings['mainmail']='{$_POST['adm_email']}';\n";
				$config_file.="\$Settings['dbHost']='{$_POST['db_host']}';\n";
				$config_file.="\$Settings['dbPort']={$_POST['db_port']};\n";
				$config_file.="\$Settings['dbName']='{$_POST['db_name']}';\n";
				$config_file.="\$Settings['dbUser']='{$_POST['db_user']}';\n";
				$config_file.="\$Settings['dbPass']='".$app->decrypt(hex2bin($_POST['db_pass']),hex2bin($app->token))."';\n";
				$config_file.="\$Settings['nameCompulsory']='{$_POST['ss_name']}';\n";
				$config_file.="\$Settings['emailCompulsory']='{$_POST['ss_email']}';\n";
				$config_file.="\$Settings['emailValidation']='{$_POST['ss_evalid']}';\n";
				$config_file.="\$Settings['countryCompulsory']='{$_POST['ss_country']}';\n";
				$config_file.="\$Settings['genderCompulsory']='{$_POST['ss_gender']}';\n";
				$config_file.="\$Settings['dobCompulsory']='{$_POST['ss_dob']}';\n";
				if ($_POST['ss_age']=='') $_POST['ss_age']=0;
				$config_file.="\$Settings['min_age']={$_POST['ss_age']};\n";
				$config_file.="?>\n";
				file_put_contents($app->homepath.'main/scripts/config.php',$config_file);
			}
		}
	}
	ob_end_flush();
	$app->renderHead("Setup - {$app->sitename}",'SCFDuffy','Setup, Install, Configuration, Options, Config',"Setup page for for {$app->sitename}");
	$app->renderHeader();
?>
		<style>
			article{text-align:center;display:inline-block;border:0.125rem outset #ccc;}
			section{text-align:right;display:inline-block;border:none;}
			.complete{background:#cfc; color:black;}
		   .helpbox{background:#ffe; font-weight:normal;font-size:1rem;text-align:left;
			         border:0.0625rem solid var(--button-fg);
			         border-radius:0.5rem;padding:0.5rem;}
			blockquote{border:0.0625rem dashed var(--button-fg); border-radius:0.5rem; padding:0.25rem;}
		</style>


		<script>
			function safepost(){
				var form=document.getElementById('mainform');	
				var token=document.getElementsByName('token')[0].value;
				var adpw=document.getElementsByName('adm_pass')[0];
				var dbpw=document.getElementsByName('db_pass')[0];
				adpw.value=app.encryptHex(adpw.value,token);
				dbpw.value=app.encryptHex(dbpw.value,token);
				form.submit();
				adpw.value=app.decryptHex(adpw.value,token);				
				dbpw.value=app.decryptHex(dbpw.value,token);
				return false;
			}
			<?php if (($errfocus!='none')&&($errfocus!=false)) echo "function pageInit(){".$errfocus."}" ?>
		</script>




		<h1>Application Settings</h1>




		<article>
			<h2>Installation URL</h2>
			<section class='complete'>
				<h3 class='center'> 	&nbsp; The Application is installed at &nbsp;
				<blockquote style='border:0.0625rem dashed var(--button-fg);'>
					<?php echo $app->homeurl; ?>
				</blockquote>
				</h3>
			</section>	
		</article>
         

         
         
      <form id='mainform' enctype='multipart/form-data' method='post' onsubmit='return safepost();'>
         <article>



            <h2>Website Icon</h2>
				<section <?php	if ($icon_complete) echo "class='complete'"; ?>>
					<div style='display:inline-block;'>
						<?php
							if (file_exists($app->homepath.'main/style/icons/mainicon.png'))
								echo "<img src='".$app->homedir."main/style/icons/mainicon.png'
									style='height:4.5rem;padding:0.25rem;' />";
						?>
					</div>

					<div style='display:inline-block;vertical-align:top;'>
					<h3>Site Icon
						<input name='site_icon' type='file' />
					</h3>

					<h3 title="Suppress placing a favicon image on the www-root folder.">No Favicon for www-root
						<input name='site_icon_root' type='checkbox'
						<?php
							if (isset($_POST['site_icon_root']))
								echo ' checked';
						?>
					/>
					</h3>

					<!--input name='site_icon_upload' type='submit' value='upload' /-->

					</div>
	            <?php if (!$icon_complete){echo "<br/><b style='color:red;'>$icon_error</b>";}?>
				</section>	




				<h2>Website Information</h2>
				<section <?php if ($site_info_complete) echo " class='complete'"; ?>>
         		
					<h3>Website Name					
         		<input name='site_name' placeholder='example'
	               <?php
	               	if (isset($_POST['site_name'])&&($_POST['site_name']!=false))
	               		echo "value='{$_POST['site_name']}'";
							else
								echo "value='{$app->settings['sitename']}'";
						?>
	         	/>
	         	</h3>
					
					<h3>Auto-Emailer					
					<input name='auto_mail' type='email' placeholder='noreply@example.com'
						<?php
							if (isset($_POST['auto_mail'])&&($_POST['auto_mail']!=false))
								echo "value='{$_POST['auto_mail']}'";
							else
								echo "value='{$app->settings['automail']}'";
						?>
					/>
	         	</h3>



				</section>



				<h2>Signup Settings</h2>
				<section <?php if ($site_info_complete) echo " class='complete'"; ?>>
         		<script>
         			function syncEmailSiteSettings(calltype){
							if ((calltype==='v') && (document.getElementsByName("ss_evalid")[0].checked))
								document.getElementsByName("ss_email")[0].checked=true;
							if ((calltype==='e') && (!document.getElementsByName("ss_email")[0].checked))
								document.getElementsByName("ss_evalid")[0].checked=false;
         			}
         		</script>
					<h3>Email Validation Required
					<input name='ss_evalid' type='checkbox' onclick='syncEmailSiteSettings("v");' title='User must click a link sent by email'
						<?php
							if (isset($_POST['ss_evalid'])&&($_POST['ss_evalid']=='on'))
								echo "checked='checked'";
							else
								if ($app->settings['emailValidation']) echo "checked='checked'";
						?>
					/>
	         	</h3>
	         	
					<h3>Email Required
					<input name='ss_email' type='checkbox' onclick='syncEmailSiteSettings("e");'
						<?php
							if (isset($_POST['ss_email'])&&($_POST['ss_email']=='on'))
								echo "checked='checked'";
							else
								if ($app->settings['emailCompulsory']) echo "checked='checked'";
						?>
					/>
	         	</h3>

					<h3>Name Required
					<input name='ss_name' type='checkbox' 
						<?php
							if (isset($_POST['ss_name'])&&($_POST['ss_name']=='on'))
								echo "checked='checked'";
							else
								if ($app->settings['nameCompulsory']) echo "checked='checked'";
						?>
					/>
	         	</h3>
    	
					<h3>Country Required
					<input name='ss_country' type='checkbox' 
						<?php
							if (isset($_POST['ss_country'])&&($_POST['ss_country']=='on'))
								echo "checked='checked'";
							else
								if ($app->settings['countryCompulsory']) echo "checked='checked'";
						?>
					/>
	         	</h3>
	         	
					<h3>Gender Required
					<input name='ss_gender' type='checkbox' 
						<?php
							if (isset($_POST['ss_gender'])&&($_POST['ss_gender']=='on'))
								echo "checked='checked'";
						?>
					/>
	         	</h3>
	         	
					<h3>Date of Birth Required
					<input name='ss_dob' type='checkbox' 
						<?php
							if (isset($_POST['ss_dob'])&&($_POST['ss_dob']=='on'))
								echo "checked='on'";
						?>
					/>
	         	</h3>
					<h3>Minimum Age
					<input name='ss_age' type='number' min='0' onclick="document.getElementsByName('ss_dob')[0].checked='on';"
						<?php
							if (isset($_POST['ss_age']))
								echo "value={$_POST['ss_age']}";
						?>
					/>
	         	</h3>

				</section>



            <h2>Director's Account</h2>
            <section <?php if ($adm_info_complete) echo " class='complete'"; ?>>

            	<h3>Email Address					
            	<input name='adm_email' type='email' placeholder='webmaster@example.com'
            		<?php
							if (isset($_POST['adm_email'])&&($_POST['adm_email']!=false))
								echo "value='{$_POST['adm_email']}'";
							else
								echo "value='$adminemail'";
				   	?>
					/>
	         	</h3>
					
					<h3>Username					
					<input name='adm_user' placeholder='Directors Username'
						<?php
							if (isset($_POST['adm_user'])&&($_POST['adm_user']!=false))
								echo "value='{$_POST['adm_user']}'";	
							else
								echo "value='$adminname'";
						?>
					/></h3>
					
					<h3>Password
					<input name='adm_pass' type='password' placeholder='Directors Password'
						<?php
							if (isset($_POST['adm_pass'])&&($_POST['adm_pass']!=false))
								echo "value='".$app->decrypt(hex2bin($_POST['adm_pass']),hex2bin($app->token))."'";
						?>
					/></h3>


				
            </section>





				<?php
					// QUICK REFERENCE COMMENTS for dropping and creating db and user
					// sudo mysql -e "drop database dbname;drop user 'dbuser'@'localhost';";
					// sudo mysql -e "create database dbname;grant all on dbname.* to 'dbuser'@'localhost' identified by 'dbpass';";
				?>

            <h2>Database Information</h2>
            <section <?php if ($db_error===null) echo " class='complete'"; ?>>
					<h3>Database Hostname					
					<input name='db_host' placeholder='localhost'
					   <?php
					      if (isset($_POST['db_host'])&&($_POST['db_host']!=false))
					         echo "value='{$_POST['db_host']}'";
						   else
						      echo "value='{$app->settings['dbHost']}'";

					   ?>
					/>
					</h3>
					
					<h3>Database Port					
					<input name='db_port' placeholder='3306'
						<?php
							if (isset($_POST['db_port'])&&($_POST['db_port']!=false))
								echo "value='{$_POST['db_port']}'";
							else
								echo "value='{$app->settings['dbPort']}'";
						?>
					/></h3>
					
					<h3>Database Name					
					<input name='db_name' placeholder='WebAppDB'
						<?php
							if (isset($_POST['db_name'])&&($_POST['db_name']!=false))
						 		echo "value='{$_POST['db_name']}'";
							else
								echo "value='{$app->settings['dbName']}'";
						?>
					/></h3>
					
					<h3>Database Username					
					<input name='db_user' placeholder='WebAppUser'
						<?php
							if (isset($_POST['db_user'])&&($_POST['db_user']!=false))
								echo "value='{$_POST['db_user']}'";	
							else
								echo "value='{$app->settings['dbUser']}'";
						?>
					/></h3>
					
					<h3>Database User Password
					<input name='db_pass' type='password' placeholder='WebAppPassword'
						<?php
							if (isset($_POST['db_pass'])&&($_POST['db_pass']!=false))
								echo "value='".$app->decryptHex($_POST['db_pass'],$app->token)."'";
							else
								echo "value='{$app->settings['dbPass']}'";
						?>
					/></h3>
	            <?php if ($db_error){echo "<br/><b style='color:red;'>$db_error</b>";}?>
            </section>


				

				<br/>
				<h3 class='center'><input type='submit' value='Change Settings' /></h3>
				<input type='hidden' name='token' value='<?php echo $app->token; ?>' />
				<br/>



         </article>
		</form>


		<br/>


<?php
	$app->renderFooter();
	$app->renderTail();
?>
