<?php



	/******************************************\
	* Web Application 4.0 by SCFDuffy (C) 2021 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 4.0 Installer by SCFDuffy - (C)February 2021 *
	\**************************************************************/



function alert($m){echo $m;}
	require_once('../classes/Application.php');
	include($app->homepath.'main/scripts/pregs.php');
	
	ob_start(); //no flush until cookies set

	$app=new Application();

	$at=false; $ru=false; $rp=false; $rc=false; $re=false; $rn=false; $rf=false; $rl=false; $rg=false; $rd=false; $ra=false; $success=false;
	$ruerr=''; $rperr=''; $rcerr=''; $reerr=false; $rnerr=false; $rferr=false; $rlerr=false; $rgerr=false; $rderr=false; $raerr=false;
	$focus='ru'; $success=false;

	if (isset($_POST['token'])&&($_POST['token']!=false))
		$at=$_POST['token'];
	if (isset($_POST['ru'])&&($_POST['ru']!=false))
		$ru=$app->decryptHex($_POST['ru'],$app->token);
	if (isset($_POST['rp'])&&($_POST['rp']!=false))
		$rp=$app->decryptHex($_POST['rp'],$app->token);
	if (isset($_POST['rc'])&&($_POST['rc']!=false))
		$rc=$app->decryptHex($_POST['rc'],$app->token);
	if (isset($_POST['re'])&&($_POST['re']!=false))
		$re=$app->decryptHex($_POST['re'],$app->token);
	if (isset($_POST['rf'])&&($_POST['rf']!=false))
		$rf=$app->decryptHex($_POST['rf'],$app->token);
	if (isset($_POST['rl'])&&($_POST['rl']!=false))
		$rl=$app->decryptHex($_POST['rl'],$app->token);
	if (isset($_POST['rn'])&&($_POST['rn']!=false))
		$rn=$app->decryptHex($_POST['rn'],$app->token);
	if (isset($_POST['rg'])&&($_POST['rg']!=false))
		$rg=$app->decryptHex($_POST['rg'],$app->token);
	if (isset($_POST['rd'])&&($_POST['rd']!=false))
		$rd=$app->decryptHex($_POST['rd'],$app->token);
	if (isset($_POST['ra'])&&($_POST['ra']!=false))
		$ra=$_POST['ra'];


	if ($at){
		if (!$ru) $ruerr='You must supply a username';
		else {
			if (preg_match($pregs['username'],$ru)===0) $ruerr='Invalid Username';
			else{
				$focus='rp';
				if (!$rp) $rperr='You must supply a password';
				else {
					if (preg_match($pregs['password'],$rp)===0) $rperr='Invalid Password';
					else{
						$focus='rc';
						if (!$rc) $rcerr='Retype the password to confirm its correct';
						else if ($rc!==$rp) $rcerr='The password and confirmation don`t match';
						else {
							$focus='re';
							if ((!$re)&&(($app->settings['emailCompulsory']=='on')||($app->settings['emailValidation']))){
								if ($app->settings['emailValidation']=='on') $reerr='An email address is needed for validation';
								else if ($app->settings['emailCompulsory']=='on') $reerr='All accounts must have an email address';
							}
							else {
								if (preg_match($pregs['email'],$re)===0) $reerr='Invalid Email Address';
								else if (($re!='')&&($app->getUserByEmail($re))) $reerr="There is already an account associated with this email address<br/>You can reset it using the <a href='{$app->homedir}main/special/recover.php'>Recovery Page</a>";								
								else{
									if ((!$rn)&&($app->settings['countryCompulsory']=='on')) $rnerr='All accounts must have a country';
									else{
										$focus='rf';
										if ((!$rf)&&($app->settings['nameCompulsory']=='on')) $rferr='You must provide your first name';
										else {
											if (($rf!='')&&(preg_match($pregs['name'],$rf)===0)) $rferr='Invalid Name';
											else{
												$focus='rl';
												if ((!$rl)&&($app->settings['nameCompulsory']=='on')) $rlerr='You must provide your last name';
												else {
													if (($rl!='')&&(preg_match($pregs['name'],$rl)===0)) $rlerr='Invalid Name';
													else{
														$focus='rg';
														if ((!$rg)&&($app->settings['genderCompulsory']=='on')) $rgerr='You must provide your gender';
														else {
															$focus='rd';
															if ((!$rd)&&($app->settings['dobCompulsory']=='on')) $rderr='You must provide a date of birth';
															else {
																if (($rd!='')&&(preg_match($pregs['dob'],$rd)===0)) $rderr='Invalid Date';
																else{
																	if ((time()-strtotime($rd))/31557600 < $app->settings['min_age']) $rderr='This site is not suitable for your age group.';
																	else{	//the date of birth is within constraints
																		$focus='ra';
																		if (!$ra) $raerr='Agree to the Terms and Conditions';
																		else {
																			$record=$app->getUser($ru);
																			if ($record!==false){
																				$focus='ru';
																				$ruerr='Username not available';
																			}
																			else{
																				unset($record);
																				if ($app->settings['emailValidation']){
																					$ev=rand(100000000,999999999);
																					$token=bin2hex(random_bytes(32));
																					$code=$app->encryptHex($re."\n".$ev,$token);
																					$mailbody=
"Hello $ru!,

This is an automated email from {$app->sitename}.

We recently received a sign up for a new membership using this email address for
the new account. We are sending this email so you can validate your account with
our website.

To validate your account now, click or copy and paste the following link into a
browser:

<a href='{$app->homeurl}main/special/validate.php?id=$code&t=$token'></a>

If you did not sign up with {$app->sitename}, you have received this email in
error and you can ignore it. We are sorry for any inconvenience.

Thankyou from {$app->sitename}.
";
																					$app->automailer($re,$app->sitename.' Email Validation',$mailbody);
																					$success='validation';
																				}
																				else{
																					$ev=0;
																					$success=true;
																				}
																				$app->addUser('basic',$ru,$rp,$re,$ev,$rf,$rl,$rn,$rg,$rd);
																				$newuser=$app->getUser($ru);
																				$app->editUser($newuser['uuid'],'icon_url','main/style/glyphs/anonymous.png');
																				if (!$app->settings['emailValidation']) $app->login($newuser);
																			}
																		}
																	}
																}
															}
														}
													}
												}					
											}
										}					
									}
								}
							}					
						}
					}
				}
			}
		}
	}


	ob_end_flush(); //cookies set so flush the buffer onto page
	if ($success===true){
?>
<!doctype html><html><body onload="parent.app.closeFrameReload('dialogue');"></body></html>
<?php } else {
	$app->renderHead("Signup - {$app->sitename}",'SCFDuffy','Signup, register, join, membership, account, enroll, member, application, apply, invite, invitation',"Signup page for {$app->sitename}");
	$app->renderHead();
?>

<style>
	body{background:none;}
	article{text-align:center;display:inline-block;border:0.125rem outset #ccc;}
	section{text-align:right;display:block;border:none;}
	.error{color:red;text-align:center;font-size:1rem;padding-top:0; margin-top:0;}
</style>
<script>
	function ignoreClick(ev){ev.cancelBubble=true;} //clicking on the dialogue itself doesnt close the signup screen
	function keyHandler(e){if (e.code==='Escape') closeFrame();}
	function closeFrame(){
		document.removeEventListener('keyup',keyHandler);
		document.getElementById('dialogue').removeEventListener('click',ignoreClick);
		document.body.removeEventListener('click',closeFrame);
		parent.app.closeFrame('dialogue');
	}
	function safepost(){
		var form=document.getElementById('mainform');	
		var token=document.getElementsByName('token')[0].value;
		var ru=document.getElementsByName('ru')[0];
		var rp=document.getElementsByName('rp')[0];
		var rc=document.getElementsByName('rc')[0];
		var re=document.getElementsByName('re')[0];
		var rns=document.getElementById('rns');
		var rn=document.getElementsByName('rn')[0]; rn.value=rns.options[rns.selectedIndex].text;
		var rf=document.getElementsByName('rf')[0];
		var rl=document.getElementsByName('rl')[0];
		var rgs=document.getElementById('rgs');
		var rg=document.getElementsByName('rg')[0]; rg.value=rgs.options[rgs.selectedIndex].text;
		var rds=document.getElementById('rds');
		var rd=document.getElementsByName('rd')[0]; rd.value=rds.value;
		ru.value=app.encryptHex(ru.value,token);
		rp.value=app.encryptHex(rp.value,token);
		rc.value=app.encryptHex(rc.value,token);
		re.value=app.encryptHex(re.value,token);
		rn.value=app.encryptHex(rn.value,token);
		rf.value=app.encryptHex(rf.value,token);
		rl.value=app.encryptHex(rl.value,token);
		rg.value=app.encryptHex(rg.value,token);
		rd.value=app.encryptHex(rd.value,token);
		form.submit();
		ru.value=app.decryptHex(ru.value,token);
		rp.value=app.decryptHex(rp.value,token);
		rc.value=app.decryptHex(rc.value,token);
		re.value=app.decryptHex(re.value,token);
		rn.value=app.decryptHex(rn.value,token);
		rf.value=app.decryptHex(rf.value,token);
		rl.value=app.decryptHex(rl.value,token);
		rg.value=app.decryptHex(rg.value,token);
		rd.value=app.decryptHex(rd.value,token);
		return false;
	}
	function init(){
		app=new Website();
		document.body.addEventListener('click',closeFrame);
		document.getElementById('dialogue').addEventListener('click',ignoreClick);
		document.addEventListener('keyup',keyHandler);
		document.getElementsByName('<?php echo $focus; ?>')[0].focus();
	}
</script>

		<article id='dialogue'>

			<h1>Signup</h1>


<?php if ($success==='validation') { ?>


			<section style='text-align:center;'>
				<h3>Email Validation</h3>
				<p>Your account has been created.</p>
				<p>An email has been sent to:</p>
				<p><?php echo $app->decryptHex($_POST['re'],$app->token); ?></p>
				<p>You must validate this email to login.
				</p>
				<input type='button' value='okay' onclick='closeFrame();' />
			</section>


<?php } else { ?>


			<section>
				<form id='mainform' method='post' onsubmit='return safepost();' autocomplete='off'>

					<h3>Username*		
					<input name='ru' placeholder='Choose a Username'
						<?php
							if (isset($_POST['ru'])&&($_POST['ru']!=false))
								echo "value='".$app->decryptHex($_POST['ru'],$app->token)."'";
//else echo "value='user'";
						?>
					/>
					<?php if ($ruerr) echo "<div class='error'>$ruerr</div>"; ?>
					</h3>
					
					<h3>Password*
					<input name='rp' type='password' placeholder='Set a Password'
						<?php
							if (isset($_POST['rp'])&&($_POST['rp']!=false))
								echo "value='".$app->decryptHex($_POST['rp'],$app->token)."'";
//else echo "value='pass'";
						?>
					/>
					<?php if ($rperr) echo "<div class='error'>$rperr</div>"; ?>
					</h3>

					<h3>Confirm Password*
					<input name='rc' type='password' placeholder='Retype Password'
						<?php
							if (isset($_POST['rc'])&&($_POST['rc']!=false))
								echo "value='".$app->decryptHex($_POST['rc'],$app->token)."'";
//else echo "value='pass'";
						?>
					/>
					<?php if ($rcerr) echo "<div class='error'>$rcerr</div>"; ?>
					</h3>

					<h3>Email Address<?php if (($app->settings['emailCompulsory'])||($app->settings['emailValidation'])) echo '*'; ?>

					<input name='re' type='email' placeholder='Enter Your Email Address'
						<?php
							if (isset($_POST['re'])&&($_POST['re']!=false))
								echo "value='".$app->decryptHex($_POST['re'],$app->token)."'";
//else echo "value='root@spock'";
						?>
					/>
					<?php if ($reerr) echo "<div class='error'>$reerr</div>"; ?>
					</h3>





					<h3>Country<?php if ($app->settings['countryCompulsory']) echo '*'; ?>
	
					<?php
						if (isset($_POST['rn'])&&($_POST['rn']!=false))
							$countrySelected=$app->decryptHex($_POST['rn'],$app->token); else $countrySelected='';
					?>
					<select id='rns'>
						<?php
							echo "<option value=''></option>";
							$countryList=explode("\n",file_get_contents($app->homepath.'main/scripts/countries.list'));
							foreach ($countryList as $country){
								if ($country===$countrySelected) $selected="selected='true'"; else $selected='';
								echo "<option value='$country' $selected>$country</option>";
							}
						?>
					</select>
					<input name='rn' type='hidden' value='<?php echo $countrySelected; ?>' />
					<?php if ($rnerr) echo "<div class='error'>$rnerr</div>"; ?>
					</h3>





					<h3>First Name<?php if ($app->settings['nameCompulsory']) echo '*'; ?>
					<input name='rf' placeholder='What are you called?'
						<?php
							if (isset($_POST['rf'])&&($_POST['rf']!=false))
								echo "value='".$app->decryptHex($_POST['rf'],$app->token)."'";
//else echo "value='John'";
						?>
					/>
					<?php if ($rferr) echo "<div class='error'>$rferr</div>"; ?>
					</h3>

					<h3>Last Name<?php if ($app->settings['nameCompulsory']) echo '*'; ?>
					<input name='rl' placeholder='What is your familty name?'
						<?php
							if (isset($_POST['rl'])&&($_POST['rl']!=false))
								echo "value='".$app->decryptHex($_POST['rl'],$app->token)."'";
//else echo "value='Smith'";
						?>
					/>
					<?php if ($rlerr) echo "<div class='error'>$rlerr</div>"; ?>
					</h3>



					<h3>Date of Birth<?php if ($app->settings['dobCompulsory']) echo '*'; ?>
					<input id='rds' type='date' placeholder='Date of Birth?'
						<?php
							if (isset($_POST['rd'])&&($_POST['rd']!=false))
								echo "value='".$app->decryptHex($_POST['rd'],$app->token)."'";
						?>
					/>
					<input name='rd' type='hidden' value='<?php echo $dobValue; ?>' />
					<?php if ($rderr) echo "<div class='error'>$rderr</div>"; ?>
					</h3>


					<h3>Gender<?php if ($app->settings['genderCompulsory']) echo '*'; ?>
					<?php
						if (isset($_POST['rg'])&&($_POST['rg']!=false))
							$genderSelected=$app->decryptHex($_POST['rg'],$app->token); else $genderSelected='';
					?>
					<select id='rgs'>
						<option value=''></option>
						<option value='male' <?php if ($genderSelected==='male') echo "selected='true'"; ?>>Male</option>
						<option value='female' <?php if ($genderSelected==='female') echo "selected='true'"; ?>>Female</option>
					</select>					
					<input name='rg' type='hidden' value='<?php echo $genderSelected; ?>' />
					<?php if ($rgerr) echo "<div class='error'>$rgerr</div>"; ?>
					</h3>

					<h4 class='center'>I agree to the <a href='<?php echo $app->homedir.'terms_and_conditions.php'; ?>'>Terms and Conditions</a>*
					<input name='ra' type='checkbox'
						<?php
							if (isset($_POST['ra'])&&($_POST['ra']!=false))
								echo "checked='".$_POST['ra']."'";
						?>
					/>
					<?php if ($raerr) echo "<div class='error'>$raerr</div>"; ?>
					</h4>

					<p class='center'>
						<input type='submit' value='signup' />
						<input type='button' value='cancel' onclick='closeFrame();' />
					</p>

					<input type='hidden' name='token' value='<?php echo $app->token; ?>' />
				</form>
			</section>
			<p>Fields marked with * are compulsory.</p>
<?php } ?>
		</article>
<?php
	$app->renderTail();
} ?>
