<?php





	/******************************************\
	* Web Application 6.0 by SCFDuffy (C) 2022 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 6.0 written by SCFDuffy        (C) July 2022 *
	\**************************************************************/






	$homepath=dirname($_SERVER['SCRIPT_NAME']);
	$homepath=($homepath=='/')?$_SERVER['DOCUMENT_ROOT']:$_SERVER['DOCUMENT_ROOT'].$homepath;
	while (!file_exists($homepath.'/main')) $homepath=dirname(substr($homepath,0,-1));
	require_once($homepath.'/main/classes/Application.php');

	$app->renderHead($app->settings['sitename'],'SCFDuffy',"{$app->settings['sitename']}, Computer Repairs, Cumbernauld, computer parts, for sale, south carbrain","The Homepage of {$app->settings['sitename']}");
	$app->renderHeader();
?>		 
<h1>Gartbeth Digital Services Web Application</h1>
<article>
	<h3>Version 6.0 of GDSWA</h3>
	<section>
	<figure style='width:50%;float:right;padding:0.25rem;margin:0.5rem;' >
		<img class='round' style='width:100%;' src='<?php echo "{$app->homedir}/main/static/gartbeth.jpg"; ?>' />
	</figure>
	<p>This version includes a more standardised plug in interface. See the setup
	for the Generic Plugin. All plugins must now contain these basic files. There
	has also been a change to the way application directories are accessed such
	that whereas before the application object contained a <q>/</q> at the end of
	its path prefixes, now the <q>/</q>must be prefixed to the path within the
	application. For example,
	</p>
	<p class='center'><code>{$app->homedir}/index.php</code>
	</p>
	<p>is now used	in place of
	</p>
	<p class='center'><code>{$app->homedir}index.php</code>
	</p>
	<p>This tiny change has meant	an update to all application files and since
	there has been a want for social media to be re-integrated, it was thought
	the time was now to make this long wanted fundamental adjustment to the way
	the application is programmed.
	</p>
	<p>Social media integration has been re-introduced including analytics for
	both facebook and google as well as facebook logins for what are now <q>basic</q>
	members as opposed to <q>social</q> as they were called in Version 3.0. There
	is also a social media sharing plugin which supports Facebook, Twitter and
	linkedIn as well as enabling <q>Copy to Clipboard</q>.
	</p>
	<h3>What has been removed?</h3>
	<p>As with all previous releases since Version 2.0, some things have been
	added but some things have also been taken away.
	</p>
	<p>The commerce plugin has been removed as the backend was ... well lets just
	say <q>functional</q> and the front end, though more presentable, was not up
	to the standards available on most sites which use e-commerce. The Version 5.0
	plugin is still to some extent usable with a bit of adjustment but it to get
	it to an acceptable standard, not only will it have to be re-integrated but
	a major rewrite is on the cards for it.
	</p>
	<h3>What plans before Version 7.0</h3>
	<p>In this release there will be much effort put into social integration and
	building up an audience. There is a want from those funding the developer's
	luxury lifestyle of toast and cheese for dinner every night to democratise
	and socialise the application. The whole WebGL project has been put on hold
	despite that it looks lovely. It is an advanced market to enter and at the
	current time, it would be better to build toward creating communities and an
	audience.
	</p>
	<p>Reintegration of the media capture functions from Version 4.0 looks to be
	on the cards on a very dynamic format. More OAuth2 provider support such as
	Google Logins and perhaps LinkedIn and Twitter if Twitter support OAuth2. As
	well as the features you can expect from the first line of this paragraph, a
	bit of experimentation may be carried out into the various graph APIs to see
	if it	might be better to write a combined social media application rather
	than rely on a third party which seems excessively slow.
	</p>
	<h3>Next on the agenda</h3>
	<p>Version 6.1 will contain the platform for integrating the media capture
	mentioned before but media capture may not yet feature in it right away. The
	absolutely next thing to be done, right now, is paypal re-integration since
	the paypal integration for Version 5.0 was attached to the commerce plugin.
	The commerce plugin will be rebuilt later but will REQUIRE the not yet written
	paypal plugin which should support subscriptions as well as purchases and
	donations. There may or may not be a plugin for Patreon on the cards before
	Version 6.1 but ... wait and see.
	</p>
	</section>
</article>
<?php
	$app->renderFooter();
	$app->renderTail();
?>
