




	/******************************************\
	* Web Application 6.0 by SCFDuffy (C) 2022 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 6.0 written by SCFDuffy        (C) July 2022 *
	\**************************************************************/






class Application extends Website{
	closeFrame(id){document.getElementById(id).remove();}
	closeFrameReload(id,url=false){if (!url) location.reload();else location.assign(url);}
	showFrame(id,title,url){
		var fr=document.createElement('iframe');
		fr.id=id;
		fr.title=title;
		fr.src=url;
		fr.scrolling='yes';
 		fr.style='border:none;position:fixed;left:0;top:0;width:100%;height:100%;';
		fr.allowfullscreen='false';
		fr.allowpaymentrequest='false';
		document.body.appendChild(fr);
		fr.focus();
	}

	logout(){
		var form=document.createElement('form');
		form.method='post';
		form.innerHTML='<input type="hidden" name="logout" />';
		document.body.appendChild(form);
		form.submit();
	}

	resize(){
		if (screen.width>screen.height) document.documentElement.style.fontSize='1.25vw';
		else document.documentElement.style.fontSize='4.5vw';
		if (document.getElementsByTagName('footer')[0]!=null){
			var footer=document.getElementsByTagName('footer')[0];
			footer.style.position='static';
			footer.style.display='block';
			var rect=footer.getBoundingClientRect();
			if (Math.ceil(rect.top+rect.height)<=innerHeight){
				footer.style.position='fixed';
				footer.style.bottom='0px';
			}
		}
	}

	tabswitch(ids){
		var tab=document.getElementById('tab_'+ids[0]);
		if (tab.classList.contains('opentab')) return;
		tab.classList.replace('tab','opentab');
		for (var i=1;i<ids.length;i++){
			document.getElementById('tab_'+ids[i]).classList.replace('opentab','tab');
			document.getElementById(ids[i]).style.display='none';
		}
		document.getElementById(ids[0]).style.display='block';
		this.resize();
	}

	toggleMenu(ev){
		var el=document.getElementById('menu');
		if (el.style.display!=='inline-block'){
			el.style.display='inline-block';
			this.toggleMenuBindin=this.toggleMenu.bind(this);
			document.addEventListener('click',this.toggleMenuBindin,true);
		}
		else if ((!ev)||(ev.target!==document.getElementById('hamburger'))){
			el.style.display='none';
			document.removeEventListener('click',this.toggleMenuBindin,true);
		}
	}

	initTheme(){
		var themeName=document.getElementById('themeSheet').content,cookie=this.getCookie('theme');
		if (cookie!=undefined) themeName=cookie;
		var themes=document.getElementsByClassName('themeSheet');
		for(var current=0;(current<themes.length)&&(themes[current].title!==themeName);current++);
		for(var i=0;i<themes.length;i++) themes[i].disabled=true;
		if (current>=themes.length) current=0;
		themes[current].disabled=false;
		current++;
		if (current>=themes.length) current=0;
		document.getElementById('themeSelect').innerHTML=themes[current].title;
	}
	toggleTheme(){
		var themes=document.getElementsByClassName('themeSheet');
		for(var current=0;(current<themes.length)&&(themes[current].disabled);current++);
		current++;
		if (current>=themes.length) current=0;
		for(var i=0;i<themes.length;i++) themes[i].disabled=true;
		themes[current].disabled=false;
		this.setCookie('theme',themes[current].title);
		current++;
		if (current>=themes.length) current=0;
		document.getElementById('themeSelect').innerHTML=themes[current].title;
	}

	constructor(homedir,apptoken){
		super();
		this.homedir=homedir;
		this.apptoken=apptoken;
		this.resize();
		this.initTheme();
		window.addEventListener('resize',this.resize);
	}
}
var app;
function init(homedir,apptoken){app=new Application(homedir,apptoken);}
