<?php





	/******************************************\
	* Web Application 6.0 by SCFDuffy (C) 2022 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 6.0 written by SCFDuffy        (C) July 2022 *
	\**************************************************************/






class Application{
	public $token,$user,$settings,$plugins,$db,$rooturl,$homepath,$homedir,$homeurl,$installed;

	//user privelege
	public static $accountType=[
		'visitor'=>0,			//Generic website viewer
		'basic'=>1,				//OAuth only accounts
		'member'=>2,			//Signed up properly
		'subscriber'=>3,		//Paying member
		'affiliate'=>4,		//Members we like
		'writer'=>5,			//Main Content creators
		'moderator'=>6,		//Members with a ban hammer
		'technical'=>7,		//technical
		'administrator'=>8,
		'director'=>9
	];
	function userPrivs($acReqd){
		if (!isset($this->user)) $acType='visitor';
		else $acType=$this->user['account_type'];
		$t=Application::$accountType[$acType];
		$r=Application::$accountType[$acReqd];
		return ($t<$r)?-1:($t>$r);
	}
	function logCrack($msg){file_put_contents("{$this->homepath}/cracks.log",$msg."\n",FILE_APPEND);}
	function automailer($mailto,$subject,$mailbody){mail($mailto,$subject,$mailbody,"From: {$app->settings['automail']}\r\n");}
	function encrypt($msg,$key){$mlen=strlen($msg);$klen=strlen($key);$dst=$msg;for ($i=0;$i<$mlen;$i++) $dst[$i]=$msg[$i] ^ $key[$i%$klen];unset($mlen);unset($klen);return $dst;}
	function decrypt($msg,$key){$mlen=strlen($msg);$klen=strlen($key);$dst=$msg;for ($i=0;$i<$mlen;$i++) $dst[$i]=$msg[$i] ^ $key[$i%$klen];unset($mlen);unset($klen);return $dst;}
	function decryptHex($msg,$key){return $this->decrypt(hex2bin($msg),hex2bin($key));}
	function encryptHex($msg,$key){return bin2hex($this->encrypt($msg,hex2bin($key)));}
	function fetch($url){$c = curl_init();curl_setopt($c,CURLOPT_HEADER,0);curl_setopt($c,CURLOPT_URL,$url);curl_setopt($c,CURLOPT_RETURNTRANSFER,TRUE);$result=curl_exec($c);curl_close($c);return $result;}
	function setToken(){if (isset($_POST['token'])) $this->token=$_POST['token'];else $this->token=bin2hex(random_bytes(32));}




	function renderHead($title='',$author='',$keywords='',$description=''){
		echo "<!doctype html><html lang='en-gb'><head><meta charset='utf-8' /><meta name='viewport' content='width=device-width, initial-scale=1.0' />";

		echo "\n<meta name='author' content='$author' /><meta name='keywords' content='$keywords' /><meta name='description' content='$description' />";




		echo "\n<link rel='stylesheet' type='text/css' href='{$this->homedir}/main/style/global.css' />";
		echo "\n<link rel='stylesheet' type='text/css' href='{$this->homedir}/main/style/style.css' />";
		if (isset($this->settings['plugins']))	foreach ($this->settings['plugins'] as $plugin)
			echo "\n<link rel='stylesheet' type='text/css' href='{$this->homedir}/main/plugins/$plugin/style.css' />";


		include "{$this->homepath}/main/include/stylehead.php";


		echo "\n<script src='{$this->homedir}/main/classes/Website.js'></script>";
		echo "\n<script src='{$this->homedir}/main/classes/Application.js'></script>";
		if (isset($this->settings['plugins']))	foreach($this->settings['plugins'] as $plugin)
			echo "\n<script src='{$this->homedir}/main/plugins/$plugin/script.js'></script>";


		@include "{$this->homepath}/main/style/favicons/iconmeta.htm";


		echo "<title>{$title}</title></head>";
		echo "<body onload='init(\"{$this->homedir}\",\"{$this->token}\");'>";
		if (!$this->installed) echo "<a style='display:none;' id='themeSelect'>stub</a>";


	}
	function renderTail(){
		echo '</body></html>';
	}
	function renderHeader(){
		if (!$this->installed) return;
		@include $this->homepath."/main/include/header.php";
		echo "<main>";
	}
	function renderFooter(){
		echo "</main>";
		if (!$this->installed) return;
		@include "{$this->homepath}/main/include/footer.php";
	}


	function menuItem($label,$link,$id=false){
		if ($id) return "<li><a href=\"$link\" class='menuitem' id='$id'>$label</a></li>";
		else return "<li><a href=\"$link\" class='menuitem'>$label</a></li>";
	}
	function squarePNG($file,$fname,$width){
		$ext=strtolower(pathinfo(basename($fname),PATHINFO_EXTENSION));
		$img=false;
		switch ($ext){
			case 'jpg':
			case 'jpeg':	$img=imagecreatefromjpeg($file); break;
			case 'gif':		$img=imagecreatefromgif($file); break;
			case 'png':		$img=imagecreatefrompng($file); break;
			case 'webp':	$img=imagecreatefromwebp($file); break;
			case 'bmp':		$img=imagecreatefrombmp($file); break;
			default: $img=false;
		}
		if ($img!==false){
			if ( imagesx($img) > imagesy($img) ) $i0=imagescale($img,512,-1,IMG_BICUBIC_FIXED);
			else $i0=imagescale($img,512*(imagesx($img)/imagesy($img)),512,IMG_BICUBIC_FIXED);
			imagedestroy($img);
			$i512=imagecreatetruecolor(512,512);
			imageSaveAlpha($i512,true);
			imagefill($i512,256,256,imagecolorallocatealpha($i512,0,0,0,127));
			imagecopy($i512,$i0,(512-imagesx($i0))/2,(512-imagesy($i0))/2,0,0,imagesx($i0),imagesy($i0));
			imagedestroy($i0);
			$img=$i512;
		}
		return $img;
	}		
	function tabstrip($tabselect,$ids){
		echo "<div class='tabstrip'>\n";
		foreach($ids as $id){
			echo "<a id='tab_$id' href='javascript:app.tabswitch([\"$id\"";
			foreach($ids as $id2) if ($id2!==$id) echo ",\"$id2\"";
			echo "]);' class='";
			if ($id===$tabselect) echo "open";
			echo "tab'>$id</a>\n";
		}
		echo "</div>\n";
	}
	function renderInfoBox($link,$colour,$title,$body,$imgurl){echo "<article class='infobox' style='background:$colour;border:var(--pixel) solid $colour;'><a href='$link' class='infobox'><h3>$title</h3><section class='infobox' style='background-image:url($imgurl);'><table style='width:100%;height:100%;'><tr><td>$body</td></tr></table></section></a></article>";}




	function sitemapGetXML($sitemap){if (file_exists($sitemap)) $xml=simplexml_load_file($sitemap);else $xml=simplexml_load_string("<?xml version='1.0' encoding='UTF-8' ?>\n<urlset xmlns='http://www.sitemaps.org/schemas/sitemap/0.9'>\n</urlset>");return $xml;}
	function sitemapPutXML($sitemap,$xml){$xml->asXML($sitemap);}
	function sitemapXMLUpdate($xml,$localurl,$priority=0.5,$changefreq='yearly'){
		//possible values for $changefreq are "always,hourly,daily,weekly,monthly,yearly,never"
		//1.0 is the highest $priority and 0.0 the lowest
		if (file_exists("{$this->rootpath}{$localurl}")){
			$loc=$this->rooturl.htmlspecialchars($localurl);
			$lastmod=date('c',filemtime("{$this->rootpath}{$localurl}"));
			$find=false;
			foreach($xml->url as $url) if ($url->loc==$loc){$find=$url;break;}
			if (!$find){$url=$xml->addChild('url');$url->addChild('loc',$loc);$url->addChild('lastmod',$lasmod);$url->addChild('priority',$priority);$url->addChild('changefreq',$changefreq);}
			else{$find->lastmod=$lastmod;$find->priority=$priority;$find->changefreq=$changefreq;}
		}
	}
	function sitemapUpdateAll(){
		$sitemap="{$this->rootpath}/sitemap.xml";
		$xml=$this->sitemapGetXML($sitemap);
		$this->sitemapXMLUpdate($xml,"{$this->homedir}/",'1.0');
		$this->sitemapXMLUpdate($xml,"{$this->homedir}/index.php",'0.9');
		$this->sitemapXMLUpdate($xml,"{$this->homedir}/main/special/privacy.php",'0.1');
		$this->sitemapXMLUpdate($xml,"{$this->homedir}/main/special/copyright.php",'0.1');
		$pages=glob("{$this->homepath}/main/pages/*.php");
		$rpl=strlen($this->rootpath);
		foreach($pages as $page) $this->sitemapXMLUpdate($xml,substr($page,$rpl),'0.5');
		$this->sitemapPutXML($sitemap,$xml);
	}

	function dbInit($dbhost,$dbport,$dbname,$dbuser,$dbpass){
		mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
		try{$this->db=new mysqli($dbhost,$dbuser,$dbpass,$dbname,$dbport);}
		catch (Exception $exception){return false;};
		if ($this->db->connect_errno===0) return true;
		else{return false;}
	}

	function addUser($type,$user,$pass,$email='',$einvalid=0,$first='',$last='',$country='',$gender='',$dob=''){
		$time=time();
		$hash=password_hash($pass,PASSWORD_DEFAULT);
		$user=addslashes($user);
		$email=addslashes($email);
		$first=addslashes($first);
		$last=addslashes($last);
		$dob=addslashes($dob);
		$this->db->query("
			insert into users(creation_time,account_type,username,password,email,email_invalid,first_name,last_name,country,gender,dob)
			values($time,'$type','$user','$hash','$email',$einvalid,'$first','$last','$country','$gender','$dob');
		");
		if ($this->db->errno!==0) return false;
		return true;
	}
	function delUser($uuid){
		$this->db->query("delete from users where uuid='$uuid';");
	}
	function editUser($uid,$column,$value){
		$value=addslashes($value);
		$this->db->query("update users set $column='$value' where uuid='$uid';");
	}
	function getUserByQuery($where){
		if (!$this->db) return false;
		$response=$this->db->query("select * from users where $where;");
		if ($response->num_rows==0) return false;
		else return $response->fetch_assoc();
	}
	function getUser($uid){
		return $this->getUserByQuery("uuid='$uid'");
	}
	function setCurrentUser($uid){
		$account=$this->getUser($uid);
		if ($account!=false){
			if ($_COOKIE['login']===md5($account['username'].$account['password'].$account['creation_time']))
				$this->user=$account;
			else $this->logCrack("In Application::setAccount, login cookie did not match account for user '$uid'.");
			if ($this->user!=false) $this->editUser($uid,'last_login',time());
		}
	}
	function login($user){
		$cookiepath=substr($this->homedir.'/',0);
		$strangenumber=md5($user['username'].$user['password'].$user['creation_time']);
		setcookie('user',$user['uuid'],time()+3600*24*30,$cookiepath,'.'.$_SERVER['SERVER_NAME'],false,true);
		setcookie('login',$strangenumber,time()+3600*24*30,$cookiepath,'.'.$_SERVER['SERVER_NAME'],false,true);
	}
	function logout(){
		$cookiepath=substr($this->homedir.'/',0);
		setcookie('user','',1,$cookiepath,'.'.$_SERVER['SERVER_NAME'],false,true);
		setcookie('login','',1,$cookiepath,'.'.$_SERVER['SERVER_NAME'],false,true);
		Header('Location: '.$_SERVER['REQUEST_URI']);
	}



	function __construct($homepath){
		$this->homepath=$homepath;
		$this->rootpath=$_SERVER['DOCUMENT_ROOT'];
		$this->homedir=substr($this->homepath,strlen($this->rootpath));
		if (isset($_POST['logout'])) $this->logout();
		$this->rooturl='http'.(isset($_SERVER['HTTPS'])? 's://':'://').$_SERVER['SERVER_NAME'];
		$this->homeurl=$this->rooturl.$this->homedir;		//FQURL	to app home
		$this->setToken();
		$this->installed=false; 	
		if (file_exists("{$this->homepath}/main/scripts/config.json")){
			$this->settings=json_decode(file_get_contents("{$this->homepath}/main/scripts/config.json"),true);
			if ($this->dbInit($this->settings['dbHost'],$this->settings['dbPort'],$this->settings['dbName'],$this->settings['dbUser'],$this->settings['dbPass'])){
				$q=$this->db->query("show tables where Tables_in_{$this->settings['dbName']}='users'");		
				if ($q->num_rows!=0) $this->installed=true;
			}
		}
		if (!$this->installed){
			if (strrpos($_SERVER['SCRIPT_NAME'],'/main/special/setup.php')===false)
				Header("Location: {$this->homedir}/main/special/setup.php\n");
		}
		else if (isset($_COOKIE['user'])) $this->setCurrentUser($_COOKIE['user']);
	}
	function __destruct(){
		if ($this->db) $this->db->close();
	}
}
$app=new Application($homepath);
?>