<?php





	/******************************************\
	* Web Application 6.0 by SCFDuffy (C) 2022 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 6.0 written by SCFDuffy        (C) July 2022 *
	\**************************************************************/






	$homepath=dirname($_SERVER['SCRIPT_NAME']);
	$homepath=($homepath=='/')?$_SERVER['DOCUMENT_ROOT']:$_SERVER['DOCUMENT_ROOT'].$homepath;
	while (!file_exists($homepath.'/main')) $homepath=dirname(substr($homepath,0,-1));
	require_once($homepath.'/main/classes/Application.php');

	$app->renderHead("About - {$app->settings['sitename']}",'SCFDuffy',"{$app->settings['sitename']}, About, Information, Info","A page describing {$app->settings['sitename']}");
	$app->renderHeader();
?>
<article>
	<h1>About <?php echo $app->settings['sitename']; ?></h1>
	<section>
		<figure style='width:50%;float:right;padding:0.25rem;margin:0.5rem;' >
			<img class='round' style='width:100%;' src='<?php echo "{$app->homedir}/main/static/gartbeth.jpg"; ?>' />
		</figure>
		<p><b>Auranos.org</b> is the online presence of <b>Gartbeth Digital Services</b> with its
		main headquarters established in the land of Gartbeth, between the Barony Parish of Glasgow
		and the County of Lanark as depicted within the red line on various maps.
		</p>
		<p>The main UK office for Gartbeth Digital Services Ltd is Cumbernauld, Scotland, Videlicit:
		</p>
		<div style='text-align:center;'>
			<address style='display:inline-block;padding:0 2rem;'><b>
				<p>Gartbeth Digital Services</p>
				<p>173D Greenrigg Road</p>
				<p>South Carbrain</p>
				<p>Cumbernauld G67 2QD</p>
				<p>United Kingdom</p>
			</b></address>
		</div>
		<p>We can also be reached by telephone on <a href='tel:07903064488'>(+44) 07903 064488</a></p>
		<p>Gartbeth Digital Services Ltd is registered at Companies House (SC710279)
		and for VAT (392 6548 59).
		</p>
	</section>
</article>
<article>
	<h1>Services Offered</h1>
	<section>
		<p>Auranos.org provides a number of services all related to computing and information technology.
		The focus of the business at the time of writing is the supply, repair and maintenance of computers and their
		components to domestic and small office consumers.
		</p>
		<p>A number of other services are available including consultancy, software specifications, hardware specifications,
		bespoke software solutions, novel microprocessor designs and fabrication, satelite communication equipment, fleet
		management services, time quotas on low to mid orbit communication satelites, data recovery, online educational
		courses and seminars on all things computer related.
		</p>
		<h1>Software</h1>
		<p>The current focus on software solutions centres around a full stack web application written in house called the
		GDS framework. It is capable of being adapted to suit almost any needs and includes its own proprietory encryption
		technology to give extra security even against intruders able to see beneath the TLS/SSL layer of encryption.
		</p>
		<p>Various modules can be deployed or developed for a tailor made software solution for your business. At the current
		time, the GDS framework v5 supports Paypal Integration, Social Media Logins, Instant Chat and Chatrooms and E-Retail,
		all of which can be made available according to the priveleges of a logged in user. In addition, the audio/video
		conferencing capabilities are currently under developement and will work without the need for expensive signal servers
		provided by major corporations like Google and Amazon. There is also a shipping address module under construction to
		make it easier for your customers to select their address. This module is based on public domain data and will not 
		require a special license from the Royal Mail or any state monopoly in any global region.
		</p>
		<h1>Hardware</h1>
		<p>As a digital service provider, Auranos.org has accrued special knowledge of markets for hardware and can
		provide various computing equipment either for rental or for purchase at prices which are competitive. While consumer
		computing equipment such as Desktops, Laptops, Routers and Printers can be supplied to domestic users and SOHO consumers,
		there is an infrequent demand for industrial scale computing equipment from server racks to specialised computing equipment
		such as differentiators, quantum memory banks, cryptographic processors, satcom devices and various analogue and supercomputing
		components as needs require.
		</p>
		<h1>Services</h1>
		<p>In addition to the provision of hardware and software, Auranos.org provides a number of services, especially to those
		within the locality of Cumbernauld, Scotland.
		</p>
		<p>The main service provided is the construction, repair and upgrade of consumer computers for domestic customers and small
		businesses. Windows Remote Assistance is available to users of Microsoft Windows within an hours travel of the Cumbernauld
		area. Help and assistance can be provided for Debian and Red Hat based Linux distributions such as Fedora, Ubuntu, Trisquel and
		Mint. Support is only available for Linux distributions which generally work completely "out of the box". No support is available
		at present for Slackware, BSD, Solaris or UNIX, however we can provide support regarding applications written for UNIX-like
		operating systems such as Apache, NGinx, MySql, MariaDB, Wine, OpenOffice, etc. Contact Auranos.org for inquiries regarding
		a specific need.
		</p>
	</section>
</article>
<?php
	$app->renderFooter();
	$app->renderTail();
?>
