<?php








	/******************************************\
	* Web Application 6.0 by SCFDuffy (C) 2022 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 6.0 written by SCFDuffy        (C) July 2022 *
	\**************************************************************/








	$homepath=dirname($_SERVER['SCRIPT_NAME']);
	$homepath=($homepath=='/')?$_SERVER['DOCUMENT_ROOT']:$_SERVER['DOCUMENT_ROOT'].$homepath;
	while (!file_exists($homepath.'/main')) $homepath=dirname(substr($homepath,0,-1));
	require_once($homepath.'/main/classes/Application.php');

	$app->renderHead("Analytics Plugin - {$app->settings['sitename']}",'SCFDuffy',"Analytics Plugin, Google Analytics, Facebook Pixel, Analytics, Pixel","Configuration for the Analytics Plugin for Auranos.org Application v6.0");
	$app->renderHeader();

	if ($app->userPrivs($app->user['account_type'],'technical')<0){
?>
<article>
	<h1>Special Page</h1>
	<section class='center'>
		<h3>Website Settings</h3>
		<details class='help' ontoggle='app.resize();'>
			<summary>Help</summary>
			<div class='helpbox'>
				<h3>Accessing Website Settings</h3>
				<p>If you believe you should have the priveleges to access this part
				of the website but are unable to access this page properly then you
				should make sure that you are logged in under the correct account
				and if you still cannot access the settings, speak to either an
				administator or the director (or webmaster) to have them raise your
				privelege level to access this part of the website.
				</p>
			</div>
		</details>
		<div style='padding:0 1rem;text-align:left;'>
			<p>You must be logged in using an account with sufficient priveleges
			to alter the settings of the website.
			</p>
			<p>As a general rule, only users with technical priveleges can alter
			the settings of the website itself. This includes the website director
			(ie The Webmaster), administration staff and anyone who has been given
			technical priveleges to alter the website such that they may need to
			access these settings.
			</p>
			<p>Moderators, writers, affiliates and members with higher priveleges
			than ordinary members are, as a general rule, not permitted to alter
			the settings of the website itself, albeit that they may have an
			enhanced privelege level on other parts of the website.
			</p>
		</div>
	</section>
</article>
<?php
	}
	else{
		$gaScript='';$fpScript='';$json=false;
		if (file_exists("{$app->homepath}/main/plugins/analytics/config.json")){
			$json=file_get_contents("{$app->homepath}/main/plugins/analytics/config.json");
			if ($json!==false) $json=json_decode($json,true);
		}
		if (!$json){
			$json['gpid']='';
			$json['fpid']='';
			$json['gpidon']='';
			$json['fpidon']='';
		}
		if (isset($_POST['GPID'])) $json['gpid']=$_POST['GPID'];
		if (isset($_POST['GPIDon'])) $json['gpidon']=$_POST['GPIDon'];
		if (isset($_POST['FPID'])) $json['fpid']=$_POST['FPID'];
		if (isset($_POST['FPIDon'])) $json['fpidon']=$_POST['FPIDon'];
		if (!$json['gpid']) $json['gpidon']=0;
		if (!$json['fpid']) $json['fpidon']=0;
		file_put_contents("{$app->homepath}/main/plugins/analytics/config.json",json_encode($json));
		if ($json['gpidon']) $gaScript=" (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)})(window,document,'script','https://www.google-analytics.com/analytics.js','ga');ga('create', '{$json['gpid']}', 'auto');ga('send', 'pageview');";
		if ($json['fpidon']) $fpScript=" !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window, document,'script','https://connect.facebook.net/en_US/fbevents.js');fbq('init','{$json['fpid']}');fbq('track','PageView');";
		$fullScript=$gaScript.$fpScript;
		file_put_contents("{$app->homepath}/main/plugins/analytics/script.js",$fullScript);
?>
<article>
	<h1>Analytics</h1>
	<section class='center'>
		<h1>Enabling Analytics</h1>
		<details class='help' ontoggle='app.resize();'>
			<summary>Google</summary>
			<div class='helpbox'>
				<h3>Propety ID</h3>
				<p>This is a very simple plugin allowing Google to be informed when
				someone is on a page on your website. The only information needed is
				the property ID for your website domain.
				</p>
				<p>You can check what the Property ID is by visiting
				<a href='https://ga-dev-tools.web.app/account-explorer/' target='_blank'>Google's
				Account Explorer</a> and copy/pastiong the number relevant to your
				domain name down at the bottom of the page.
				</p>
				<p>For information about letting Google know that you own a specific
				domain name and create a Property ID for it on Google, you should
				<a href='https://support.google.com/webmasters/answer/34592' target='_blank'>read
				this article in their help centre</a>.
			</div>
		</details>
		<details class='help' ontoggle='app.resize();'>
			<summary>Facebook</summary>
			<div class='helpbox'>
				<h3>Pixel ID</h3>
				<p>This is a very simple plugin which informs Facebook when someone
				visits a page on your website. The only information needed is the
				Facebook Pixel ID which Facebook has provided for your domain.
				</p>
				<h3>Getting your Pixel ID</h3>
				<p>You can check what the Pixel ID is by visiting
				<a href='https://www.facebook.com/events_manager2' target='_blank'>
				Facebook Events Manager</a>and selecting the triangular <q>Data
				Sources</q> icon in the right hand menu. This will bring up a list
				of Data Sources including your Facebook Pixel if you have one. You
				can copy/paste the ID from the box for the Facebook Pixel in the
				list of Data Sources.
				</p>
				<h3>Creating a Pixel</h3>
				<p>If you do not already have a Facebook Pixel, you need to visit
				<a href='https://www.facebook.com/events_manager2' target='_blank'>
				The Facebook Events Manager</a> and create one.
				</p>
				<p>On the right hand menu, click on the green <q>Connect Data Sources</q>
				icon, mark the box for <q>Web</q> in the pop up box which appears.
				Click the <q>Connect</q> on the bottom right to move onto the next
				pop up box. Give your pixel a name in this box then move on to the
				next and type in your website domain name.
				</p>
				<p>On the last box, you can see your pixel ID at the bottom. You can
				copy and paste this now if you like but to finish off, click next.
				</p>
			</div>
		</details>
		<form method='post'>
			<div class='aligner'>
				<fieldset>
					<h3 class='inline'>&nbsp;</h3>
					<h1 class='inline' style='float:left;'>Google</h1>
					<h3 class='inline' style='float:right;'>
						<input name='GPIDon' value='<?php echo $json['gpidon']; ?>' class='boolean' type='range' min='0' max='1' />
					</h3>
					<p>Property ID:
						<input name='GPID' value='<?php echo $json['gpid']; ?>'>
					</p>
				</fieldset>
				<fieldset>
					<h3 class='inline'>&nbsp;</h3>
					<h1 class='inline' style='float:left;'>Facebook</h1>
					<h3 class='inline' style='float:right;'>
						<input name='FPIDon' value='<?php echo $json['fpidon']; ?>' class='boolean' type='range' min='0' max='1' />
					</h3>
					<p>Pixel ID:
						<input name='FPID' value='<?php echo $json['fpid']; ?>'>
					</p>
				</fieldset>
			</div>
			<br/>
			<input type='submit' value='Use These Settings' />
		</form>
		<?php echo "<a href='{$app->homedir}/main/special/setup.php?anchor=Plugins'><img class='icon' src='{$app->homedir}/main/style/icons/back.png' /><br />back</a>"; ?>
	</section>
</article>
<?php
	}
	$app->renderFooter();
	$app->renderTail();
?>
