<?php
	$homepath=dirname($_SERVER['SCRIPT_NAME']);
	$homepath=($homepath=='/')?$_SERVER['DOCUMENT_ROOT']:$_SERVER['DOCUMENT_ROOT'].$homepath;
	while (!file_exists($homepath.'/main')) $homepath=dirname(substr($homepath,0,-1));
	require_once($homepath.'/main/classes/Application.php');
	function base64_url_decode($input){
		return base64_decode(strtr($input,'-_','+/'));
	}
	function parse_signed_request($signed_request,$secret) {
		list($encoded_sig,$payload)=explode('.',$signed_request,2);
		$sig=base64_url_decode($encoded_sig);
		$data=json_decode(base64_url_decode($payload),true);
		$expected_sig=hash_hmac('sha256',$payload,$secret,$raw=true);
		if ($sig!==$expected_sig){
            error_log('Bad Signed JSON signature!');
			return null;
		}
		return $data;
	}
	header('Content-Type: application/json');
	$secret=null;
	$fbloginconfig=file_get_contents('config.json');
	if ($fbloginconfig!==false){
		$fbloginconfig=json_decode($fbloginconfig,true);
		if ($fbloginconfig!==null){
			$secret=$fbloginconfig['secret'];
		}
	}
	if (!isset($_POST['signed_request'])) $data=false;
	else{
	    $signed_request=$_POST['signed_request'];
    	$data=parse_signed_request($signed_request,$secret);
	}
	if ((!$data)||(!$secret)){
		$status_url="{$app->homeurl}/main/plugins/fblogin/deletionRecord.php?id=error";
		$confirmation_code='error';
	}
	else{
		$user_id=$data['user_id'];
		$status_url="{$app->homeurl}/main/plugins/fblogin/deletionRecord.php?id=$user_id";
		$confirmation_code=$user_id;
		$q=$app->db->query("select uuid from fblogins where fbid='$user_id'");
		if ($q!==false){
			$uuid=$q->fetch_assoc()['uuid'];
			$app->db->query("delete from fblogins where fbid='$user_id';");
			$app->delUser($uuid);
		}
	}
	$data=array('url'=>$status_url,'confirmation_code'=>$confirmation_code);
	echo json_encode($data);
?>
