<?php





	/******************************************\
	* Web Application 6.0 by SCFDuffy (C) 2022 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 6.0 written by SCFDuffy        (C) July 2022 *
	\**************************************************************/






	$homepath=dirname($_SERVER['SCRIPT_NAME']);
	$homepath=($homepath=='/')?$_SERVER['DOCUMENT_ROOT']:$_SERVER['DOCUMENT_ROOT'].$homepath;
	while (!file_exists($homepath.'/main')) $homepath=dirname(substr($homepath,0,-1));
	require_once($homepath.'/main/classes/Application.php');

	$app->renderHead("FBLogin Plugin - {$app->settings['sitename']}",'SCFDuffy',"FBLogin Plugin, Facebook, FBLogin, OAuth2, Authentication, Plugin, Setup","Configuration for the FBLogin Plugin for Auranos.org Application v6.0");
	$app->renderHeader();

	if ($app->userPrivs('technical')<0){
?>
<article>
	<h1>Special Page</h1>
	<section class='center'>
		<h3>Website Settings</h3>
		<details class='help' ontoggle='app.resize();'>
			<summary>Help</summary>
			<div class='helpbox'>
				<h3>Accessing Website Settings</h3>
				<p>If you believe you should have the priveleges to access this part
				of the website but are unable to access this page properly then you
				should make sure that you are logged in under the correct account
				and if you still cannot access the settings, speak to either an
				administator or the director (or webmaster) to have them raise your
				privelege level to access this part of the website.
				</p>
			</div>
		</details>
		<div style='padding:0 1rem;text-align:left;'>
			<p>You must be logged in using an account with sufficient priveleges
			to alter the settings of the website.
			</p>
			<p>As a general rule, only users with technical priveleges can alter
			the settings of the website itself. This includes the website director
			(ie The Webmaster), administration staff and anyone who has been given
			technical priveleges to alter the website such that they may need to
			access these settings.
			</p>
			<p>Moderators, writers, affiliates and members with higher priveleges
			than ordinary members are, as a general rule, not permitted to alter
			the settings of the website itself, albeit that they may have an
			enhanced privelege level on other parts of the website.
			</p>
		</div>
	</section>
</article>
<?php
	}
	else{
		$fbloginconfig=false;
		if (file_exists("{$app->homepath}/main/plugins/fblogin/config.json"))
			$fbloginconfig=file_get_contents("{$app->homepath}/main/plugins/fblogin/config.json");
		if ($fbloginconfig===false){
			$fbloginconfig=[];
			$fbloginconfig['appid']='';
			$fbloginconfig['secret']='';
		}
		else $fbloginconfig=json_decode($fbloginconfig,true);
		if (isset($_POST['appid'])) $fbloginconfig['appid']=$_POST['appid'];
		if (isset($_POST['secret'])) $fbloginconfig['secret']=$_POST['secret'];
		file_put_contents("{$app->homepath}/main/plugins/fblogin/config.json",json_encode($fbloginconfig),true);
		$q=$app->db->query("show tables where Tables_in_{$app->settings['dbName']}='fblogins'");		
		if (($q!=false)&&($q->num_rows===0)){
			$q=$app->db->query(file_get_contents("{$app->homepath}/main/plugins/fblogin/fblogins.sql"));
		}
		if (!$q){
?>
<article>
	<h1>Facebook Logins</h1>
	<section class='center'>
		<h3>Facebook User Logins</h3> 
		<details class='help' ontoggle='app.resize();'>
			<summary>Help</summary>
			<div class='helpbox'>
				<h3>DATABASE ERROR</h3>
				<p>Ensure the database is otherwise working for your website and if
				everything else such as logins without facebook seems to be in order
				then this plugin is not suitable for the system you are operating
				with.
				</p>
				<p>We would like to make this plugin as compatible as possible and
				failing facebook becoming less popular than it still is in 2022, an
				email to <a href='mailto:admin@auranos.org?subject=bug_report'>The
				Application	Maintainer</a> providing as much information as possible
				will be dealt with as a priority bug fix.
				</p>
			</div>
		</details>
		<h1>Database Error</h1>
		<p>There has been an error creating a database table to handle Facebook
		Logins. This usually only occurs if you attempt to setup Facebook Logins
		prior to setting the general database settings on the first tab of the
		main settings page.
		</p>
		<p>If this application is otherwise connecting to the database for the
		application without any other problems, you should contact
		<a href='mailto:admin@auranos.org?subject=bug_report'>The Application
		Maintainer</a> and file a bug report stating that the Facebook Login
		Settings page announced a problem connecting to the database. It will be
		useful to know whether your database is stored on the same server as your
		website and whether there are any restrictions to the names of tables on
		the database your host provides.
		</p>
		<p>Any other information you can provide will be useful in making this
		plugin compatible for people with your type of setup.
		</p>
		<?php echo "<a href='{$app->homedir}/main/special/setup.php?anchor=Plugins'><img class='icon' src='{$app->homedir}/main/style/icons/back.png' /><br />back</a>"; ?>
	</section>
</article>
<?php	}else{ ?>
<article>
	<h1>Facebook Logins</h1>
	<section class='center'>
		<h3>Facebook User Logins</h3> 
		<details class='help' ontoggle='app.resize();'>
			<summary>Help</summary>
			<div class='helpbox'>
				<h3>App ID</h3>
				<p>For Facebook Logins to work, the applications requires a Facebook
				App ID and App Secret. This is a unique identity number for an
				application which you set up on
				<a href='https://developers.facebook.com/apps/?show_reminder=true'>
				The Facebook Developer Console</a>.
				</p>
				<p>This help box section will guide you through the process.
				</p>
				<p>Click the above link to visit the Facebook Developer Console. You
				may need to set up a developer account with facebook which tacks on
				to your regular Facebook account. Once you are in the console from
				the link above, you will see a screen with a big green button over
				on the top right of the page below the pages menu banner. Click on
				<q>Create App</q>.
				</p>
				<p>You want to create a Facebook App so users can login to your site
				using their Facebook account to authenticate rather than the regular
				signup process. The App Type for this behaviour is <q>Consumer</q>.
				</p>
				<p>A new page will open asking what you want the Facebook App to be
				called in <q>Display Name</q> and a contact email address. You can
				also set a business account for the Facebook App but this is not
				neccessary for the permissions we require for just logging users
				into the site through their Facebook Account.
				</p>
				<hr/>
				<p>When the Facebook App is created, you will need to alter the
				default settings. On the App Dashboard, the page showing will be
				titled <q>Client OAuth Settings</q>. The top portion of this page
				is dedicated to switches. All of them must be turned on, with the
				exception of <q>Force Web OAuth Reauthenitication</q> and <q>Embedded
				Browser OAuth Login</q>, both of which must be switched off.
				</p>
				<p>Beneath this section with switches is a box called <q>Valid OAuth
				Redirect URIs</q>. You must fill this in using your specific domain
				name and (if applicable) the specific folder you serve the Gartbeth
				Digital Services Web Application from, followed by the path suffix
				<q>/main/special/login.php</q> as exemplified here:
				</p>
				<p><code>https://yourspecificdomain.co.uk/yourappfolder/main/special/login.php</code>
				</p>
				<p>If you are serving the application directly from the public_www
				folder on your server then you can forgo the use of an appfolder and
				instead use the following example:
				</p>
				<p><code>https://yourspecificdomain.co.uk/main/special/login.php</code>
				</p>
				<p>Facebook will only support secure servers so it must be https.
				Remember to give the specific domain name for your website, including
				any prefixes like <q>www.</q> to express a subdomain.
				</p>
				<p>Following this is a pair of switches expressing login support.
				Both of these <i>should</i> be switched on but it is absolutely essential
				that the switch for <q>Login with the Javascript SDK</q> is switched
				on.
				</p>
				<p>The final field on this page is to express what domains will
				support logging into them. That is to say <q>https://yourspecificdomain.co.uk/
				will suffice for this field.</q>
				</p>
				<p>The other pages on that webpage can be left alone, but you will
				have to provide either a deletion information page or a deletion
				callback page so that Facebook members can delete their accounts
				through Facebook. If you do not provide this information, facebook
				may terminate your use of the Facebook Login. It is wise to provide
				this now.
				</p>
				<hr/>
				<p>Go to the left hand menu and slide open the Settings submenu near
				the top. Open the link <q>Basic</q> and a page will open showing
				Basic Settings for your newly created Facebook App.
				</p>
				<p>The most important field is the data deletion URL which you can
				discern from the following examples:
				</p>
				<p>The Gartbeth Digital Services Web Application supports deletion
				callbacks and to implement this, you should select the appropriate
				option in the <q>User data deletion</q> field then type something
				similar to the following in the text field below.
				</p>
				<p><code>https://yourspecificdomain.co.uk/yourappfolder/main/plugins/fblogin/deletionCallback.php</code>
				</p>
				<p>If you prefer, you can also select <q>Data Deletion Instructions</q>
				instead of the call back and use the following example for the text
				field instead:
				</p>
				<p><code>https://yourspecificdomain.co.uk/yourappfolder/main/plugins/fblogin/deletionInformation.php</code>
				</p>
				<p>You will notice that the page contains lots of information you
				can fill out to make your connection with facebook as presentable
				as possible. App Icon's, Terms of Service URL, etc, and while there
				are lots of fields that you can fill out, the scope of this help
				section is to get your Facebook Login up and running. It may be
				worthwhile keeping the Facebook App Basic Settings page open once
				you are done configuring this plugin but for now we will move to the
				last item Facebook needs to know and that's the <q>Privacy Policy URL</q>.
				</p>
				<p>Fortunately, we have created a Privacy Policy Page for you based
				on the standard settings of this Website Application. This page can
				be referenced on your setup as exemplified here:
				</p>
				<p><code>https://yourspecificdomain.co.uk/yourappfolder/main/special/privacy.php</code>
				</p>
				<p>Now click on the save page button at the bottom right hand corner
				and move on to getting the <q>App ID</q> and <q>App Secret</q>
				so it can be copy/pasted into the fields below this help box.
				</p>
				<p>Once you are done just click on <q>Use These Settings</q> and now
				your website visitors will be able to login to your website using
				Facebook instead of signing up with a username and password.
				</p>
				<p>Remember, as a director, an administrator or a technical member,
				you can upgrade the basic members who login with facebook to full
				members through the administrate page for the Website Application.
				You should email such members telling them to create a new password
				from their profile page so that they can login with their username
				and password even if facebook goes down.
				</p>
			</div>
		</details>
		<h1>This is the configuration page for the Facebook Login Plugin</h1>
		<h3>See the help section for getting the App ID and Secret from Facebook.</h3>
		<form method='post'>
			<br/>
			<div class='aligner'>
				Facebook App ID:<input name='appid' value='<?php echo $fbloginconfig['appid']; ?>' />
				<br/>
				App Secret:<input name='secret' value='<?php echo $fbloginconfig['secret']; ?>' />
				<br/>
			</div>
			<br/><br/>
			<input type='submit' value='Use These Settings' />
		</form>
		<br/>
		<?php echo "<a href='{$app->homedir}/main/special/setup.php?anchor=Plugins'><img class='icon' src='{$app->homedir}/main/style/icons/back.png' /><br />back</a>"; ?>
	</section>
</article>
<?php
		}
	}
	$app->renderFooter();
	$app->renderTail();
?>
