<?php





	/******************************************\
	* Web Application 6.0 by SCFDuffy (C) 2022 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 6.0 written by SCFDuffy        (C) July 2022 *
	\**************************************************************/






	$homepath=dirname($_SERVER['SCRIPT_NAME']);
	$homepath=($homepath=='/')?$_SERVER['DOCUMENT_ROOT']:$_SERVER['DOCUMENT_ROOT'].$homepath;
	while (!file_exists($homepath.'/main')) $homepath=dirname(substr($homepath,0,-1));
	require_once($homepath.'/main/classes/Application.php');
	$app->renderHead("Help - Admin - {$app->settings['sitename']}",'SCFDuffy','Help, Administration, Admin, Webmaster, Support',"Help Page for Administrators of {$app->settings['sitename']}");
	$app->renderHeader();
?>
<style>
ul.tree{padding-left:1rem;}
</style>
<h1>Help with Website Administration</h1>
<article>
	<h1>Contents</h1>
	<section>
		<ul>
			<li><h3>Installation</h3>
				<ul class='tree'>
					<li><a href='#SSLCertificates'>Creating and Installing SSL Certificates</a></li>
				</ul>
			</li>
		</ul>
		<br />
	</section>
</article>
<span id='SSLCertificates'></span>
<br /><br />
<article>
	<h1>SSL Certificates</h1>
	<section>
		<p>Many browsers flag up a warning and make visiting a site more difficult
		if it does not have an SSL certificate enabling a padlock icon to be
		displayed on the browsers menu area.
		</p>
		<p>In many situations, your domain name registraar or web hosting provider
		will provide you with just such a certificate but it is also possible to
		provide yourself with an SSL certificate by using certificates from free
		certificate authorities such as LetsEncrypt.
		</p>
		<p>The process for setting up your website with an SSL padlock is not
		entirely straightforward and you will need access to a secure shell console
		(SSH) on your web host in order to install certificates by the method we
		provide here.
		</p>
		<p>You do not need to have root priveleges and this procedure will work
		even on shared hosting platforms but it must be linux host. There are
		alternative solutions available online for platforms such as Microsoft IIS. 
		</p>
		<hr />
		<p>The following instructions assume your domain name is <em>example.com</em>.
		Wherever you see <em>example.com</em> you should change this to your own
		domain name.
		</p>
		<p>In addition, the assumption is made that the www-root directory of your
		website is in the www directory of your home directory. That is to say <em>
		~/www</em>. Whenever you see this, you should change it to the appropriate
		location of your www-root (for example <q>/var/www/html</q> is the Apache2
		standard www-root location on many debian based standalone setups).
		</p>
		<article>
			<ol>
				<li><p>Open up a secure shell to your web host. Sometimes this will be
				made available from the <q>Advanced</q> section of cPanel if your
				host provides such. You should consult your hosts help pages about
				how to access your website through a secure shell (SSH).
				</p>
				</li>
				<li><p>You will need to install the <q>acme.sh<q> script. This is very
				simple script which will work on almost any Linux installation.
				</p>
				<p>To	install it on a system which has cURL you can use the following:
				</p>
				<p><code>curl https://get.acme.sh | sh -s email=<em>you@example.com</em></code>
				</p>
				<p>Altenatively, if your system does not have cURL, you may want to
				try the same using wget instead:
				</p>
				<p><code>wget -O -  https://get.acme.sh | sh -s email=<em>you@example.com</em></code>
				</p>
				</li>
				<li><p>Now that acme.sh is installed (by default to the hidden folder
				<q>~/.acme.sh</q>), you can now issue a certicate for your website by
				letting the certifate authority validate your web server.
				</p>
				<p><code>acme.sh --issue -d <em>example.com</em> -d <em>www.example.com</em> -d <em>mail.example.com</em> -d --webroot <em>~/www</em></code>
				</p>
				</li>
				<li><p>Now that the certificates have been issued for your website
				you now need to collect them from the certicate authority:
				</p>
				<p><code>acme.sh --renew -d <em>example.com</em> --force</code>
				</p>
				</li>
				<li><p>This will create a local copy of the certifcate and its key
				inside the default hidden <q>.acme.sh</q>folder on your home folder.
				You can read these onto the terminal using:
				</p>
				<p><code>cat ~/.acme.sh/<em>example.com</em>/<em>example.com</em>.cer</code>
				</p>
				<p>for the certificate and</p>
				<p><code>cat ~/.acme.sh/<em>example.com</em>/<em>example.com</em>.key</code>
				</p>
				<p>for its key.
				</p>
				<p>You should now consult your hosting provider to see where you
				enter these so that the host will communicate with the OCP responder
				correctly for anyone visiting your secure website.
				</p>
				<p>For example, on hosts which provide a cPanel, there will be a
				<q>security</q> section containing an item called <q>SSL/TLS Status</q>.
				Clicking on this will bring up the list of domains and subdomains of
				your website. If you click <q>View Certificate</q> for your base
				domain (e.g. <em>example.com</em>) you will be presented with the
				opportunity to copy and paste the certificate and key texts which
				you outputed to the terminal at the last step. Note that you only
				need the certifcate and key and the CA Bundle section on platforms
				which provide it will not be needed and should be cleared blank. In
				this example, you would click the <q>Install Certificate</q> button
				at the bottom to finish.
				</p>
				</li>
			</ol>
		</article>
		<hr />
		<p>There will have a short Time To Live (TTL) period of perhaps a few
		minutes but often shorter and once time has elapsed, you should be able
		to visit your website and see the padlock showing that the site has been
		secured by SSL.
		</p>
		<p>This completes the help section on installing SSL certicates for your
		installation of the Gartbeth Digital Services Web Application.
		</p>
	</section>
</article>
<?php
	$app->renderFooter();
	$app->renderTail();
?>
