<?php





	/******************************************\
	* Web Application 6.0 by SCFDuffy (C) 2022 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 6.0 written by SCFDuffy        (C) July 2022 *
	\**************************************************************/






	$homepath=dirname($_SERVER['SCRIPT_NAME']);
	$homepath=($homepath=='/')?$_SERVER['DOCUMENT_ROOT']:$_SERVER['DOCUMENT_ROOT'].$homepath;
	while (!file_exists($homepath.'/main')) $homepath=dirname(substr($homepath,0,-1));
	require_once($homepath.'/main/classes/Application.php');

	$app->renderHead("Administrate - {$app->settings['sitename']}",'SCFDuffy','Administration, User, Admin, Administrate, Users, Moderator',"Administration page for {$app->settings['sitename']}");
	$app->renderHeader();



	if ($app->userPrivs('administrator')>=0){
		if ((isset($_POST['account_type']))&&($_POST['account_type']!='')&&(isset($_POST['uid']))&&($_POST['uid']!='')){
			$ac=$app->getUser($_POST['uid']);
			$act=$app::$accountType[$app->user['account_type']];			//actor (the admin clearance)
			$obj=$app::$accountType[$ac['account_type']];					//object (the accountee clearance)
			$tgt=$app::$accountType[$_POST['account_type']];				//target (the target clearance)
			if (($act>=$obj)&&($act>=$tgt)){
				$app->editUser($ac['uuid'],'account_type',$_POST['account_type']);
			}
		}
		if ((isset($_POST['ban']))&&($_POST['ban']!='')&&(isset($_POST['uid']))&&($_POST['uid']!='')){
			$ac=$app->getUser($_POST['uid']);
			$act=$app::$accountType[$app->user['account_type']];	//actor (the admin clearance)
			$obj=$app::$accountType[$ac['account_type']];			//object (the accountee clearance)
			if ($act>$obj) switch ($_POST['ban']){
				case 'unban': $app->editUser($_POST['uid'],'bantil',time()-1); break;
				case 'hour': $app->editUser($_POST['uid'],'bantil',time()+3600); break;
				case 'day': $app->editUser($_POST['uid'],'bantil',time()+86400); break;
				case 'month': $app->editUser($_POST['uid'],'bantil',time()+2592000); break;
				case 'permanent': $app->editUser($_POST['uid'],'bantil','2147483647'); break;
			}
		}
		if ((isset($_POST['delete']))&&($_POST['delete']!='')&&(isset($_POST['uid']))&&($_POST['uid']!='')){
			$app->delUser($_POST['uid']);
		}
		if ((isset($_POST['notes']))&&($_POST['notes']!='')&&(isset($_POST['uid']))&&($_POST['uid']!='')){
			$app->editUser($_POST['uid'],'notes',$_POST['notes']);
		}
?>
<style>
a.toplink{font-weight:bold;font-size:1.5rem;text-decoration:none;padding:0.5rem;}
.male{background:#88f; color:black;}
.female{background:#f88; color:black;}
div.record{text-align:center;display:inline-block;vertical-align:middle;}
form.actions,select.actions,input.actions{display:inline;vertical-align:middle;}
</style>
<h1>User Administration</h1>
<?php
	$response=$app->db->query('select * from users;');
	for ($n=0;$n<$response->num_rows;$n++){
		$row=$response->fetch_assoc();
		$avatar=$row['icon_url'];
		if ($avatar=='') $avatar="{$app->homeurl}/main/style/icons/anonymous.png";
?>
<article class='left'>
	<?php echo "<a class='toplink' href='{$app->homedir}/main/special/profile.php?view={$row['username']}'>{$row['username']}</a>"; ?>
	<section class='center' style='padding-top:0.25rem;'>
		<div class='record <?php if ($row['gender']=='male') echo ' male';else if ($row['gender']=='female') echo ' female';?>'>
			<img src='<?php echo $avatar; ?>' style='height:5rem;' />
			<br/>
			<form method='post' class='actions'>
				<select name='account_type' style='height:1.25rem; font-size:0.6rem;' onchange='form.submit();'>
					<option value='director'<?php if ($row['account_type']=='director') echo " selected='true'"; ?>>Director</option>
					<option value='administrator'<?php if ($row['account_type']=='administrator') echo " selected='true'"; ?>>Administrator</option>
					<option value='moderator'<?php if ($row['account_type']=='moderator') echo " selected='true'"; ?>>Moderator</option>
					<option value='member'<?php if ($row['account_type']=='member') echo " selected='true'"; ?>>Member</option>
					<option value='basic'<?php if ($row['account_type']=='basic') echo " selected='true'"; ?>>Basic</option>
				</select>
				<input type='hidden' name='uid' value='<?php echo $row['uuid']; ?>' />
			</form>
		</div>
		<div class='record'>
			<?php
				echo "<a href='mailto:{$row['email']}'";
				if ($row['email_invalid']!=0) echo " style='color:var(--redlink);'";
				echo ">{$row['email']}</a>";
			?>
			<br/>
			<?php echo $row['first_name']; ?> <?php echo $row['last_name']; ?>
			<br/>
			<?php
				if ((isset($row['city']))&&($row['city']!='')) echo ucfirst($row['city']).'<br/>';
				if ((isset($row['country']))&&($row['country']!='')) echo $row['country'];
				echo "<br/>Joined: ".date('d M Y',$row['creation_time']);
			?>
		</div>
		<div class='record'>
			<form method='post' class='actions'>
				<select name='ban' class='actions';>
					<option></option>
					<?php if ($row['bantil']>Time()) echo "<option value='unban'>unban</option>"; ?>
					<option value='hour'>hour</option>
					<option value='day'>day</option>
					<option value='month'>month</option>
					<option value='permanent'>permanent</option>
				</select><input class='actions' style='margin:0;' type='submit' value='ban' />
				<input type='hidden' name='uid' value='<?php echo $row['uuid']; ?>' />
			</form>

			<?php
				if ($row['bantil']>Time())
					echo "<br/><b style='color:white;background:red;'>Banned until:<br/>".date('H:i D d M Y',$row['bantil']).'</b>';
			?>
			<br/>
			<form method='post' class='actions' onsubmit='return confirm("Delete Account?");'>
				<input class='actions' type='submit' name='delete' value='delete' style='background:linear-gradient(#faa,#c00);border-color:#faa;color:white;width:100%;' />
				<input type='hidden' name='uid' value='<?php echo $row['uuid']; ?>' />
			</form>
		</div>
		<div class='record' style='min-width:50%;text-align:right;'>
			<form method='post'>
				<textarea name='notes' style='height:4rem;width:95%;'><?php echo $row['notes']; ?></textarea>
				</br>
				<?php echo "Last login: ".date('H:i D d M Y',$row['last_login']); ?>
				<input type='submit' style='' value='Update Notes' />
				<input type='hidden' name='uid' value='<?php echo $row['uuid']; ?>' />
			</form>
		</div>


	</section>
</article>
<?php
	}
?>
<?php
	}
	else{
?>
	<article>
		<h1>User Administration</h1>
		<section class='center'>
			<h1>The User Administration page is only available to certain classes of users.</h1>
			<p>You should hit the back button or navigate to a more appropriate page.</p>
		</section>
	</article>
<?php
	}
	$app->renderFooter();
	$app->renderTail();
?>
