<?php





	/******************************************\
	* Web Application 6.0 by SCFDuffy (C) 2022 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 6.0 written by SCFDuffy        (C) July 2022 *
	\**************************************************************/






	$homepath=dirname($_SERVER['SCRIPT_NAME']);
	$homepath=($homepath=='/')?$_SERVER['DOCUMENT_ROOT']:$_SERVER['DOCUMENT_ROOT'].$homepath;
	while (!file_exists($homepath.'/main')) $homepath=dirname(substr($homepath,0,-1));
	require_once($homepath.'/main/classes/Application.php');

	$emailLink="<a href='mailto:{$app->settings['mainmail']}?subject=Privacy_Policy'>{$app->settings['mainmail']}</a>";
	$app->renderHead("Privacy - {$app->settings['sitename']}",'SCFDuffy','Privacy Policy, Privacy, Cookie, Cookies, Policy',"Privacy policy for {$app->settings['sitename']}");
	$app->renderHeader();
?>
<article>
	<h1>Privacy Policy</h1>
	<section>
		<h3>About <?php echo $app->settings['sitename']; ?> </h3>
		<p><?php echo $app->settings['sitename']; ?> is the online presence of
		Gartbeth Digital Services Ltd, a company (SC710279) whose proprietor is
		Stephen Duffy who can be contacted with regard to any privacy related
		issues at the following email address: <?php echo $emailLink; ?>
		</p>
		<h3>Protecting your Privacy</h3>
		<p>It is the responsibility of Auranos.org to protect your privacy in regards
		to any information that may be acquired from you and this extends, not only to
		the information we collect as part of the general administration of the business
		such as your contact details but also to the extent that your equipment could
		contain data which is personal and private to yourself.
		</p>
		<p>Auranos.org will not disclose any information about you which is available to
		us to any other party to the extent that a court order will be required before we
		provide any data even to statutory agencies. We take the privacy of your data very
		seriously.
		</p>
		<h3>General Business Administration Data</h3>
		<p>The data about you we hold and control for the purposes of general business
		administration is held as exempt from the Data Protection Act but we are willing
		to correct any mistakes which are reasonable to correct. Examples of this data
		include your contact details, services currently being requested and any money
		which is due between us. This data will not be disclosed to any third party and
		forms part of the private contract between us.
		</p>
		<h3>Private and Personal Data Accessible to Auranos.org</h3>
		<p>As part of the business, it is essential to have access to a customers private
		data. For example, all the data on the hard disk of a machine that is currently
		under repair. We are neither a data controller for this data nor are we a data
		processor for this data. We regard this data to be the private personal property
		of the customer and nothing within it will be disclosed to any third party without
		a court order. In addition, it is in most cases, not part of a job to be going
		through your data to see what is in it, as this information is personal and private
		to the customer. For the most part data will simply be moved from one device to
		another and never looked at but in some circumstances it may be neccessary to look
		at the metadata such as filenames and subdirectories in order to ensure the integritty
		of data transfers in some specific instances. We will treat such data in the
		strictest of confidence. 
		</p>
		<h3>Personal Information on the Website</h3>
		<p>It is possible to set up an account on the website which allows website users to
		create, alter and delete information about themselves. Except where otherwise stated
		this data when entered will become public domain and in cases where there is a specific
		statement that the data will be held privately, auranos.org and its agents will have
		access to this data. This data will be treated in the strictest of confidence and will
		not be given to third parties or used for the purposes of marketing.
		</p>
		<h3>Protection of Personally-Identifying Information</h3>
		<p>Any data derived from customers and members that auranos.org holds, is
		held either on secure servers or on machines held within secure premises.
		The data controller may be cited as Stephen Duffy who can be contacted at
		<?php echo $emailLink; ?>in the event of any privacy breach. In any case
		the only person we will disclose any data to will, in absence of a court
		order to the contrary, be the person from whom the data is derived.
		</p>  
	</section>
</article>

<br/>


<h1>About Our Cookies</h1>
<article>
	<h1>Quick Cookie Primer</h1>
	<section>
		<h3>Skip the Primer</h3>
		<p>If you already have a basic understanding of cookies and just want
		information on the cookies this web application generates, you can skip
		the primer by clicking on these links to go to the appropriate subsection.
		</p>
		<p class='center'>
			<a href='#1stpc'>Cookies set by this web application</a>
			<br/><br/>
			<a href='#3rdpc'>Cookies which may be set by third parties through the application</a>
			<br/><br/>
			<a href='#3rdpr'>Other threats to your online privacy and how to prevent them</a>
		</p>
	</section>
	<section>
		<h2>About Cookies</h2>
		<p>Cookies are data which are specific for a particular website which are stored
		on a users browser and sent by the browser to the particular website anytime the
		user attempts to access the website. They are usually created and altered by the
		website according the way the user interacts with the website and the user then
		seamlessly tells the website all the information it has stored in the form of
		cookies every time they access the website.
		</p>
		<p>Cookies are the primary means by which internet sites "remember" each user
		between browsing sessions. (A session is the time from when a user browses to
		a site to the time the user closes all windows and tabs associatied with the
		site.) By the use of cookies, a website can remember who a user is despite that
		the previous session may have ended days ago.
		</p>
		<p>Cookies are used for a variety of purposes. The most common purpose they are
		used for is to remember the User Identity (UID) of a user for a particular website
		which in turn can allow the website to look up the data it has stored internal
		to itself about the user who has the cookie that the server created on their
		browser for them. This internal data can include anything from the version of
		browser and the dimensions of the screen upon which the website renders content,
		to user options like the preferred colours of the user, text-size or options
		that are specific to certain types of site.
		</p>

		<h3>Malignant Cookies</h3>
		<p>They can also be used to track user activities not only on the site that the
		user is visiting but on third party websites which are able to read cookies set
		by a website for other websites to read. Tracking cookies do not only store your
		options for a website but can identify across a huge swathe of websites and such
		sites can target content at those they track which can include advertising for
		commercial purposes by people who know you clicked on an advert for a train trip
		or a political candidate and are capable of being used for targeted propaganda
		at dissidents, people of influence and even people who some organisations may
		wish to keep in a bubble of false and misleading information for purposes which
		may not involve financial gain or profits as would fit into categories imagined
		by ordinary people where money is a scarce and all important matter to those who
		cant imagine a world composed of those who have never lacked money.
		</p>
		<p>On this website, we tick the legal boxes of ensuring your privacy but then so
		do all the organisations showing privacy popups telling you they care so much 
		about your privacy they are only going to share with their partners as soon as
		you click the annoying button preventing the flow of your browsing session. We
		don't share your data with anyone except the "authorities" and only then once
		the said "authorities" have fulfilled the legal requirements they need to follow
		like getting a court order and such like, indemnifying us from being sued by you
		because we gave away your private information to those who were not legally
		entitled. We will co-operate with the "authorities" but we strike a balance that
		the "authorities" must themselves be in compliance with the law.
		</p>
		<p>We reserve a right to reveal your data without your permission in situations
		or imminent threat of death or torture, terrorism, state corruption and war.
		Outside of that, only if the law says we are <u>required</u> to divulge it.
		</p>
	</section>
	<section>
		<h2>Cookies Types</h2>
		<p>We separate cookies into four simple categories in describing who can see
		the cookies which are on your browser.
		</p>
		<h3>Session Cookies</h3>
		<p>These cookies are deleted at the end of every session and it would be rare
		for them to contain anything that could seriously violate your privacy. Perhaps
		the server wants to know what your screen size is during the current session so
		it can generate pages appropriate to the device dimensions. This could be stored
		in a session cookie but the next you access the website, the server will create
		a brand new session cookie serving the same purpose. Prior to version 3.0 of
		this web application, the "chatrooms section visiblity" and the "theme"
		being light or dark were stored on a session cookie which reset back to default
		values if the user left and came back again.
		</p>
		<h3>Third Party Cookies</h3>
		<p>Third party cookies are traditionally cookies which created for websites
		other than the website you are currently visiting. For example, you visit the
		example.com website and it puts a cookie on your browser that can be read by
		any website and is intended that freindsofexample.com can read that cookie and
		make the connection that you exist elsewhere anytime you visit a whole range of
		websites.
		</p>
		<p>Third party cookies were heavily exploited by organisations during the late
		HTTP 1.1 era and many browsers continue to allow users to block third party
		cookies with the caveat that on the modern internet, some sites may not work at
		all.
		</p>
		<h3 id='ssby3rd'>Samesite Cookies</h3>
		<p>A samesite cookie is a cookie which is created by a website specifically
		forbidding the cookie to be read by any website other than itself. These types
		of cookies are used by almost all websites which employ the use of cookies. The
		ability to be remembered by a site you signed up to logged into before is most
		often provided by samesite cookies.
		</p>
		<h3>Samesite Cookies by Third Parties</h3>
		<p>Social media and external authentication has encouraged techniques which were
		previously considered dangerous since they allowed third party websites to run
		programs on a website which was not their own. This was traditionally described
		as a cross site scripting XSS attack and far from a website just deliberately
		running a script from another site, alot of effort was made by maligned hackers
		to cause an external script to run on a website that was not their own such that
		alot of underlying technology had to be rewritten to prevent people from getting
		their scripts to run on someone elses website.
		</p>
		<p>Samesite Cookies by Third Parties are a type of Samesite cookie which are 
		appear to be created by the site that you are visiting and will not flag up as
		a third party cookie in a users browser but the cookies are ultimately being
		created by a script which is hosted on a third party website but is being run
		by the site you are visiting. This web application at the current
		time can run a script which is hosted by Facebook that creates cookies appearing
		to be created by the instance of the web application that a user is
		visiting. That is to say that a user visits this site, logs in using the
		facebook button and ends up with a samesite cookie for this site which were
		actually created by the script which was being hosted by facebook during the
		login procedure.
		</p>
	</section>
</article>

<a id='1stpc'></a>
<br/><br/><br/>
<h1>Cookies by <?php echo $app->settings['sitename']; ?></h1>

<article>
	<section>
		<h2><q>theme</q></h2>
		<p>The <q>theme</q> cookie is a samesite cookie which remebers the theme preferred
		by both members and anonymous users. At the current time (January 2021) there are
		two themes installed representing a dark mode like night time and a light mode
		like during the day.
		</p>
	</section>
	<section>
		<h2><q>user</q></h2>
		<p>The <q>Login</q> cookie is a samesite cookie which contains a members
		username between sessions when the user is not online.
		</p>
		<p>This cookie is only created when a someone with a Basic Membership or
		greater opts to be remembered and logged in automatically every time they
		visit the site.
		</p>
	</section>
	<section>
		<h2><q>login</q></h2>
		<p>The login cookie is a samesite cookie which the server uses to ensure the
		user cookie is a genuine cookie created by the genuine user on the website so
		avoiding potential security hazards such as someone using a forged cookie.
		</p>
		<p>This cookie is only created when a someone with a Basic Membership or greater
		opts to be remembered and logged in automatically every time they visit the site.
		</p>
	</section>
</article>

<a id='3rdpc'></a>
<br/><br/><br/>
<h1>Third Party Cookies</h1>
<article>
	<h1>Our Third Party Cookie Policy</h1>
	<section>
		<p>With the possible exception of benign session cookies which are deleted at
		the end of each session and do not contain personally identifying information,
		this web application does not create any cookies which can be read by sites
		other than the site on which the instance of the web application is running.
		</p>
		<p>In saying this, in order to provide features that some websites employing
		an instance of the this web application may desire to use, the use of 
		<a href='#ssby3rd'>Samesite Cookies by Third Parties</a> is unavoidable if
		the certain features of the instance are enabled such as facebook logins.
		</p>
		<p>The website owner should consult the list of site settings section of the
		setup or install page to switch these features on and off.
		</p>
	</section>
	<section>
		<h2>Facebook</h2>
		<p>Our website may be enabled to support logging in and signing up using
		Facebook as an Outside Authentication (OAuth) service provider. If you have
		logged in or signed up using the Facebook login then you will receive cookies
		which appear to be samesite cookies from our website but which were actually
		created by a script which is run through our site but hosted on Facebook.
		</p>
		<p>At the current time (January 2021), Facebook will create two cookies which
		appear to be same-site/any-subdomain cookies from our website for anyone who
		logs in or signs up using the facebook login or continue as button. Their names
		are as described here:
		</p>
		<p class='center'><code>fbm_###############</code> (where # is digit from 0 to 9)
		</p>
		<p class='center'><code>fbsr_###############</code> (where # is digit from 0 to 9)
		</p>
		<p>These cookies are only sent for "social members" who login to our site using
		the facebook login button and are not needed for members who have signed up for
		or upgraded from "social membership" to "Basic Membership".
		</p>
		<h3>Other Facebook Cookies</h3>
		<p>If Facebook analytics has been enabled for the website, a cookie for a
		Facebook Pixel will be set on your browser like so: &nbsp; <code>_fbp</code>
		</p>
	</section>
	<section>
		<h2>Google</h2>
		<p>Our website may be enabled to support logging in and signing up using
		Google as an Outside Authentication (OAuth) service provider or the use of
		analytics cookies for the purposes of advertising and improving the search
		engine rankings of this website. If Google has been permitted to place
		cookies on your browser through this site then you may see the following
		cookies described here:
		</p>
		<p class='center'><code>_gat_gtag_UA_#########_#</code>
		</p>
		<p class='center'><code>_ga</code>
		</p>
		<p class='center'><code>_gid</code>
		</p>
		<p>These cookies are only sent for "social members" who login to our site using
		the facebook login button and are not needed for members who have signed up for
		or upgraded from "social membership" to "Basic Membership".
		</p>
	</section>
</article>

<a id='3rdpr'></a>
<br/><br/><br/>

<h1>Third Party Requests</h1>
<article>
	<h1>Our Third Party Cookie Policy</h1>
	<section>
		<p>Our website may be enabled to support various third parties who wish
		to make requests of third party sites for use on your experience of this
		website. It is hard to provide a comprehensive list of third party sites
		which this website may call due to the use of external scripts by third
		parties who may change which sites they make requests to without this site
		having much of any direct control over it rather than just switching off
		the features which cause the third party requests to be made.
		</p>
		<p>We highly recommend the use of Searxes Third Party Request Blocker
		browswer extension as a means to prevent all Third Party Requests on any
		website to be blocked unless you specifically enable the ones that Searxes
		indicates websites are wanting to make.
		</p>
		<p>This software was developed by Stephen Duffy for udhr.auranos.org which
		has a very special privacy policy which takes into account the Universal
		Declaration of Human Rights amongst other former high standing documents
		with the intent to provide users with maximum privacy and anonymity while
		at the same time providing features which will allow website owners who
		employ this software to reduce privacy to standard levels such as might be
		seen on most internet sites in operation today.
		</p>
	</section>
</article>
<?php
	$app->renderFooter();
	$app->renderTail();
?>
