<?php





	/******************************************\
	* Web Application 6.0 by SCFDuffy (C) 2022 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 6.0 written by SCFDuffy        (C) July 2022 *
	\**************************************************************/






	$homepath=dirname($_SERVER['SCRIPT_NAME']);
	$homepath=($homepath=='/')?$_SERVER['DOCUMENT_ROOT']:$_SERVER['DOCUMENT_ROOT'].$homepath;
	while (!file_exists($homepath.'/main')) $homepath=dirname(substr($homepath,0,-1));
	require_once($homepath.'/main/classes/Application.php');


	if ($app->user!=false) $target=$app->user['username'];
	$app->renderHead("$target profile - {$app->settings['sitename']}",'SCFDuffy','Profile, Member, User, Details, Bio',"Profile page for a member of {$app->settings['sitename']}");
	if (isset($_GET['view'])) $target=$_GET['view'];
	if (!$app->user){
		$app->renderHeader();
?>
	<article>
		<h1>User Profile</h1>
		<section class='center'>
		<p>You must be logged in to your account to see this page.
		</p>
		<p>Click the back button or login to your account.
		</p>
		</section>
	</article>
<?php
	} else if ($app->user['username']==$target) {
		$averr='';$uerr='';$eerr='';$cterr='';$ferr='';$lerr='';$berr='';
		$avatar=$app->user['icon_url'];
		if ($avatar=='') $avatar="{$app->homeurl}/main/style/icons/anonymous.png";
		if (isset($_FILES['pr_av']['tmp_name'])&&($_FILES['pr_av']['tmp_name']!='')){
			if ($_FILES['pr_av']['size']>=1048576) $averr='File too large. File must be less that 1 megabyte.';
			else{
				$app->makeBucket();
				$avext=strtolower(pathinfo(basename($_FILES["pr_av"]["name"]),PATHINFO_EXTENSION));
				$avres=false;
				switch ($avext){
					case 'jpg':
					case 'jpeg':	$avres=imagecreatefromjpeg($_FILES["pr_av"]["tmp_name"]); break;
					case 'gif':		$avres=imagecreatefromgif($_FILES["pr_av"]["tmp_name"]); break;
					case 'png':		$avres=imagecreatefrompng($_FILES["pr_av"]["tmp_name"]); break;
					case 'webp':	$avres=imagecreatefromwebp($_FILES["pr_av"]["tmp_name"]); break;
					case 'bmp':		$avres=imagecreatefrombmp($_FILES["pr_av"]["tmp_name"]); break;
					default: 		$averr='Image must be a gif, jpg, jpeg, png, webp or bmp.'; break;
				}
				if ($avres===false) $averr='File is corrupted!';
				else{
					if ( imagesx($avres) > imagesy($avres) ) $i0=imagescale($avres,128,-1,IMG_BICUBIC_FIXED);
					else $i0=imagescale($avres,128*(imagesx($avres)/imagesy($avres)),128,IMG_BICUBIC_FIXED);
					imagedestroy($avres);
					$i128=imagecreatetruecolor(128,128);
					imageSaveAlpha($i128,true);
					imagefill($i128,64,64,imagecolorallocatealpha($i128,0,0,0,127));
					imagecopy($i128,$i0,(128-imagesx($i0))/2,(128-imagesy($i0))/2,0,0,imagesx($i0),imagesy($i0));
					imagedestroy($i0);

					do $avfilename='avatar-'.time().rand(1000,9999).'.png';
					while ($app->bucketExist($avfilename));

					$temp=tempnam("{$app->homepath}/main",'temp');
					imagepng($i128,$temp);
					$app->bucketSave($avfilename,file_get_contents($temp));
					unlink($temp);

					imagedestroy($i128);
					$oldimage=basename(parse_url($avatar, PHP_URL_PATH));
					if ($app->bucketExist($oldimage)) $app->bucketDelete($oldimage);
					$avatar="{$app->settings['bucketurl']}$avfilename";
					$app->editUser($app->user['uuid'],'icon_url',$avatar);
					$app->user['icon_url']=$avatar;
				}
			}
		}
		else{
			include("{$app->homepath}/main/scripts/pregs.php");
			if ((isset($_POST['pr_u']))&&($_POST['pr_u']!='')){
				if (!preg_match($pregs['username'],$_POST['pr_u'])) $uerr='Illegal characters in username';
				else if (($app->user['username']!==$_POST['pr_u'])&&($app->getUser($_POST['pr_u']))) $uerr='Username already taken';
				else{
					$app->editUser($app->user['uuid'],'username',$_POST['pr_u']);
					$app->user['username']=$_POST['pr_u'];
					$app->login($app->user);
				}
			}
			if ((isset($_POST['pr_e']))&&($_POST['pr_e']!='')){
				if (!preg_match($pregs['email'],$_POST['pr_e'])) $eerr='Inavalid Email Address';
				else if (($app->user['email']!==$_POST['pr_e'])&&($app->getUserByQuery("email='{$_POST['pr_e']}'")))
				$eerr="There is already an account associated with this email address<br/>You can reset it using the <a href='{$app->homedir}/main/special/recover.php'>Recovery Page</a>";
				else $app->editUser($app->user['uuid'],'email',$_POST['pr_e']);
			}
			if ((isset($_POST['pr_ct']))&&($_POST['pr_ct']!='')){
				if (!preg_match($pregs['city'],$_POST['pr_ct'])) $cterr='Illegal characters in city name';
				else $app->editUser($app->user['uuid'],'city',$_POST['pr_ct']);
			}
			if ((isset($_POST['pr_f']))&&($_POST['pr_f']!='')){
				if (!preg_match($pregs['name'],$_POST['pr_f'])) $ferr='Illegal characters in name';
				else $app->editUser($app->user['uuid'],'first_name',$_POST['pr_f']);
			}
			if ((isset($_POST['pr_l']))&&($_POST['pr_l']!='')){
				if (!preg_match($pregs['name'],$_POST['pr_l'])) $lerr='Illegal characters in name';
				else $app->editUser($app->user['uuid'],'last_name',$_POST['pr_l']);
			}
			if ((isset($_POST['pr_g']))&&($_POST['pr_g']!='')){
				$app->editUser($app->user['uuid'],'gender',$_POST['pr_g']);
			}
			if ((isset($_POST['pr_c']))&&($_POST['pr_c']!='')){
				$app->editUser($app->user['uuid'],'country',$_POST['pr_c']);
			}
			if ((isset($_POST['pr_d']))&&($_POST['pr_d']!='')){
				if (!preg_match($pregs['dob'],$_POST['pr_d'])) $derr='Invalid date of birth';
				else $app->editUser($app->user['uuid'],'dob',$_POST['pr_d']);
			}
			if ((isset($_POST['pr_b']))&&($_POST['pr_b']!='')){
				$bio=$_POST['pr_b'];
				$app->editUser($app->user['uuid'],'bio',$bio);
			}
			$app->user=$app->getUser($app->user['uuid']);
		}
		$app->renderHeader();
		$averr='';$uerr='';$eerr='';$cterr='';$ferr='';$lerr='';$derr='';$berr='';
?>

	<article>
		<h1>User Profile</h1>
		<section class='center'>
			<h2><?php echo $app->user['username']; ?></h2>
			<p class='center'>(<?php echo $app->user['account_type']; ?>)</p>
			<p class='center'>Joined on <?php echo Date("l \\t\h\\e dS \of F Y \a\\t g:ia",$app->user['creation_time']); ?></p>
		</section>
	</article>
	<article>
		<h2>Avatar</h2>
		<section class='center'>
	      <form id='avform' enctype='multipart/form-data' method='post'>
				<div class='center'>
					<img src='<?php echo $avatar; ?>' style='width:6rem;' /><br/>
					<input name='pr_av' type='file' /></br>
					<input type='submit' value='upload' />
					<p style='color:red;'><?php echo $averr; ?></p>
				</div>
			</form>				
		</section>
	</article>
	<article>
		<h2>Information</h2>
		<section class='center'>
	      <form id='mainform' method='post'>
				<div class='aligner'>
				<h3>Username
					<input name='pr_u' value='<?php if (isset($_POST['pr_u'])) echo $_POST['pr_u']; else echo$app->user['username']; ?>' />
					<p style='color:red;'><?php echo $uerr; ?></p>
				</h3>
				<h3>Email
					<input name='pr_e' value='<?php echo $app->user['email']; ?>' />
					<p style='color:red;'><?php echo $eerr; ?></p>
				</h3>
				<h3>Country
					<select name='pr_c'>
						<?php
							echo "<option value=''></option>";
							$countryList=explode("\n",file_get_contents("{$app->homepath}/main/scripts/countries.list"));
							foreach ($countryList as $country){
								if ($country===$app->user['country']) $selected="selected='true'"; else $selected='';
								echo "<option value='$country' $selected>$country</option>";
							}
						?>
					</select>
				</h3>
				<h3>City
					<input name='pr_ct' value='<?php echo $app->user['city']; ?>' />
					<p style='color:red;'><?php echo $cterr; ?></p>
				</h3>
				<h3>First Name
					<input name='pr_f' value='<?php echo $app->user['first_name']; ?>' />
					<p style='color:red;'><?php echo $ferr; ?></p>
				</h3>
				<h3>Last Name
					<input name='pr_l' value='<?php echo $app->user['last_name']; ?>' />
					<p style='color:red;'><?php echo $lerr; ?></p>
				</h3>
				<h3>Date of Birth
					<input type='date' name='pr_d' value='<?php echo $app->user['dob']; ?>' />
					<p style='color:red;'><?php echo $derr; ?></p>
				</h3>
				<h3>Gender
					<select name='pr_g'>
						<option value=''></option>
						<option value='male' <?php if ($app->user['gender']==='male') echo "selected='true'"; ?>>Male</option>
						<option value='female' <?php if ($app->user['gender']==='female') echo "selected='true'"; ?>>Female</option>
					</select>					
				</h3>
				</div>
				<div class='center'>
					<h3>About Me</h3>
					<textarea name='pr_b' style='height:6rem;width:90%;text-align:left;'><?php echo $app->user['bio']; ?></textarea>
					<p style='color:red;'><?php echo $berr; ?></p>
					<br/>
					<input type='submit' value='Submit Changes' />
				</div>
			</form>
		</section>
	</article>
	<article>
		<h2>Password</h2>
		<section class='center'>
			<p>This button will take you to the password reset page.</p>
			<button onclick='location.assign("<?php echo "{$app->homedir}/main/special/recover.php"; ?>")'>Reset Password</button>
		</section>
	</article>

<?php
	}
	else{	//this is a target profile - ie its an indeditable profile of another user
		$app->renderHeader();
		$target=$app->getUserByQuery("username='$target'");
		if ($target==false){
			$target=$_GET['view'];
?>

	<h1>User Profile</h1>
	<article>
		<section class='center'>
		<p>There is no such user <q><?php echo $target; ?></q> on the system. This
		may be because the user has changed their name or they have had their 
		account deleted or it could be that you attempted to access this page
		through an unorthodox means such as directly typing the get parameter
		into the browser address field.
		</p>
		<p>In any case, the user does not exist.
		</p>
		</section>
	</article>
<?php
		}
		else{
			$avatar=$target['icon_url'];
			if ($avatar=='') $avatar="{$app->homeurl}/main/style/icons/anonymous.png";
			$name=$target['username'];
			if (($target['first_name']!='')||($target['last_name']!='')) $name="{$target['first_name']} {$target['last_name']}";
			$age=false;
			if ($target['dob']!='') $age=date_diff(new DateTime($target['dob']),new DateTime('now'))->format('%y');
			$place='';
			if ($target['city']!='') $place.=$target['city'];
			if ($target['country']!=''){
				if ($place!='') $place.=', ';
				$place.=$target['country'];
			}
			if ($target['gender']==='male'){$gen1='he';$gen2='has';$gen3='himself';$gen4='He';$gen5='is';$gen6='lives';}
			else if ($target['gender']==='female'){$gen1='she';$gen2='has';$gen3='herself';$gen4='She';$gen5='is';$gen6='lives';}
			else{$gen1='they';$gen2='have';$gen3='themself';$gen4='They';$gen5='are';$gen6='live';}
			if ($target['bio']!='') $about="This is what $gen1 $gen2 to say about $gen3:";
			else $about="$gen4 $gen2 not provided any further information about $gen3.";
?>

	<article>
		<h1>User Profile</h1>
		<section class='center'>
			<br/>
			<img src='<?php echo $avatar; ?>' style='width:6rem;' /><br/>
			<h1><?php echo $target['username']; ?></h1>
			<p style='text-align:left;'>
			<?php
				echo "<b>".ucfirst($name)."</b> holds <b>{$target['account_type']}</b> membership with us, having joined on <b>";
				echo Date("l \\t\h\\e jS \of F Y \a\\t g:ia",$target['creation_time']);
				echo "</b>";
				if ($age!==false) echo ". $gen4 $gen5 <b>$age</b> years of age";
				if ($place!==''){
					if ($age!=false) echo " and";
					else echo ". $gen4";
					echo " $gen1 $gen6 in <b>$place</b>";
				}
				echo ". $about";
				if ($target['bio']!=''){
			?>
					<p><textarea disabled='true' style='height:6rem;width:90%;text-align:left;'><?php echo $target['bio']; ?></textarea></p>
			<?php
				}
				echo " $gen4 last logged in on <b>";
				echo Date("l \\t\h\\e jS \of F Y \a\\t g:ia",$target['last_login']);
				echo "</b>.";
			?>
			</p>
		</section>
	</article>


<?php
		}
	}
	
	$app->renderFooter();
	$app->renderTail();
?>
