<?php





	/******************************************\
	* Web Application 6.0 by SCFDuffy (C) 2022 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 6.0 written by SCFDuffy        (C) July 2022 *
	\**************************************************************/






	$homepath=dirname($_SERVER['SCRIPT_NAME']);
	$homepath=($homepath=='/')?$_SERVER['DOCUMENT_ROOT']:$_SERVER['DOCUMENT_ROOT'].$homepath;
	while (!file_exists($homepath.'/main')) $homepath=dirname(substr($homepath,0,-1));
	require_once($homepath.'/main/classes/Application.php');

	$installed=false;
	$privelegeError='';
	if (!$app->db){	//no database
		$tabselect='Database';
	}
	else{
		$q=$app->db->query("show tables where Tables_in_{$app->settings['dbName']}='users'");		
		if ($q->num_rows==0){	//no table
			$q=$app->db->query(file_get_contents("{$app->homepath}/main/scripts/users.sql"));
			$app->settings['sitename']='Unnamed';
			$app->settings['nameCompulsory']='';
			$app->settings['emailCompulsory']='';
			$app->settings['emailValidation']='';
			$app->settings['countryCompulsory']='';
			$app->settings['genderCompulsory']='';
			$app->settings['dobCompulsory']='';
			$app->settings['min_age']=0;
			$tabselect='Information';
		}
		else{
			$q=$app->db->query("select * from users where uuid='1';");
			if ($q->num_rows!==1){	//no admin
				$tabselect='Information';
			}
			else{
				$app->installed=true;
				$installed=true;
				$tabselect='Styling';
				if (isset($_GET['anchor'])) $tabselect=$_GET['anchor'];
			}
		}
	}

	if (!isset($app->settings['sitename'])) $app->settings['sitename']="{$_SERVER['SERVER_NAME']}";
	if (!isset($app->settings['automail'])) $app->settings['automail']="noreply@{$_SERVER['SERVER_NAME']}";
	if (!isset($app->settings['mainmail'])) $app->settings['mainmail']="admin@{$_SERVER['SERVER_NAME']}";
	if (!isset($app->settings['bucket'])) $app->settings['bucket']='/main/bucket';
	if (!isset($app->settings['nameCompulsory'])) $app->settings['nameCompulsory']='';
	if (!isset($app->settings['emailCompulsory'])) $app->settings['emailCompulsory']='';
	if (!isset($app->settings['emailCompulsory'])) $app->settings['emailCompulsory']='';
	if (!isset($app->settings['emailCompulsory'])) $app->settings['emailCompulsory']='';
	if (!isset($app->settings['genderCompulsory'])) $app->settings['genderCompulsory']='';
	if (!isset($app->settings['dobCompulsory'])) $app->settings['dobCompulsory']='';
	if (!isset($app->settings['min_age'])) $app->settings['min_age']=0;
	if (!isset($app->settings['dbHost'])) $app->settings['dbHost']='localhost';
	if (!isset($app->settings['dbPort'])) $app->settings['dbPort']='3306';
	if (!isset($app->settings['dbName'])) $app->settings['dbName']='gdsdb';
	if (!isset($app->settings['dbUser'])) $app->settings['dbUser']='gdsdbu';
	if (!isset($app->settings['dbPass'])) $app->settings['dbPass']='dbpass';

	if (!isset($app->settings['plugins'])) $app->settings['plugins']=[];

	$errfocus='';


















	//DATABASE INFORMATION TESTING CODE
	if ((!$installed)||($app->userPrivs('director')>=0)){
		$db_error=false;
		if ((isset($_POST['dbform_submit']))&&($_POST['dbform_submit']!=false)){

			if (!$errfocus) $tabselect='Database';
			if (  //ARE ALL THE SETTINGS FOR THE DATABASE CONNECTION AVAILABLE?
					(isset($_POST['db_host'])&&($_POST['db_host']!=false))&&
					(isset($_POST['db_port'])&&($_POST['db_port']!=false))&&
					(isset($_POST['db_name'])&&($_POST['db_name']!=false))&&
					(isset($_POST['db_user'])&&($_POST['db_user']!=false))&&
					(isset($_POST['db_pass'])&&($_POST['db_pass']!=false))&&
					(isset($_POST['dbform_token'])&&($_POST['dbform_token']!=false))
				){
				$app->token=$_POST['dbform_token'];
				mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
				try{$test=new mysqli($_POST['db_host'],$_POST['db_user'],$app->decrypt(hex2bin($_POST['db_pass']),hex2bin($app->token)),$_POST['db_name'],$_POST['db_port']);
				}
				catch (Exception $exception){$db_error="Exception in databse test code in setup.php: $exception";}
				if (isset($test)){
					if ($test->connect_errno!==0) $db_error=$test->connect_error;
					$test->close();
					unset($test);
				}
				else $db_error='No Database Detected';
				if (!$db_error){
					$app->settings['dbHost']=$_POST['db_host'];
					$app->settings['dbPort']=$_POST['db_port'];
					$app->settings['dbName']=$_POST['db_name'];
					$app->settings['dbUser']=$_POST['db_user'];
					$app->settings['dbPass']=$app->decrypt(hex2bin($_POST['db_pass']),hex2bin($app->token));
					file_put_contents("{$app->homepath}/main/scripts/config.json",json_encode($app->settings,true));
					$tabselect='Information';
				}
			}
			else if (!$errfocus){
				$tabselect='Database';
				if ((!isset($_POST['db_host']))||($_POST['db_host']==false)) $errfocus='db_host';
				else
				if ((!isset($_POST['db_port']))||($_POST['db_port']==false)) $errfocus='db_port';
				else
				if ((!isset($_POST['db_name']))||($_POST['db_name']==false)) $errfocus='db_name';
				else
				if ((!isset($_POST['db_user']))||($_POST['db_user']==false)) $errfocus='db_user';
				else
				if ((!isset($_POST['db_pass']))||($_POST['db_pass']==false)) $errfocus='db_pass';
			}
		}
	}
	else{
		$privelegeError='Only the website director can alter these settings.';
		$app->logCrack('Attempted to alter settings of director without sufficient privelege.');
	}























	//SITEMAP UPDATE BUTTON
	if ((!$installed)||($app->userPrivs('director')>=0)){
		if ((isset($_POST['smuform_submit']))&&($_POST['smuform_submit']!=false)&&(isset($_POST['smuform_token']))&&($_POST['smuform_token']!=false)){
			$app->token=$_POST['smuform_token'];
			$app->sitemapUpdateAll();
			$tabselect='Information';
		}
	}
	//SITE INFORMATION DETECTION CODE
	$site_info_complete=true;
	if ((!$installed)||($app->userPrivs('director')>=0)){
		if (!$db_error){
			if (isset($_POST['wsform_submit'])&&($_POST['wsform_submit']!=false)){
				if (!$errfocus) $tabselect='Information';
				if (
						(isset($_POST['site_name'])&&($_POST['site_name']!=false))&&
						(isset($_POST['auto_mail'])&&($_POST['auto_mail']!=false))&&
						(isset($_POST['bucket'])&&($_POST['bucket']!=false))&&
						(isset($_POST['adm_email'])&&($_POST['adm_email']!=false))&&
						(isset($_POST['adm_user'])&&($_POST['adm_user']!=false))&&
						(isset($_POST['adm_pass'])&&($_POST['adm_pass']!=false))&&
						(isset($_POST['wsform_token'])&&($_POST['wsform_token']!=false))
					){
					$app->token=$_POST['wsform_token'];
					$app->settings['sitename']=$_POST['site_name'];
					$app->settings['automail']=$_POST['auto_mail'];
					$app->settings['bucket']=$_POST['bucket'];
					$app->settings['mainmail']=$_POST['adm_email'];
					file_put_contents("{$app->homepath}/main/scripts/config.json",json_encode($app->settings,true));

					$q=$app->db->query("show tables where Tables_in_{$app->settings['dbName']}='users'");		
					if ($q->num_rows===0){
						$q=$app->db->query(file_get_contents("{$app->homepath}/main/scripts/users.sql"));
					}
					$q=$app->db->query("select * from users where uuid='1';");
					if ($q->num_rows==1){
						$adminRecord=$app->getUser(1);
						$passhash=password_hash($app->decrypt(hex2bin($_POST['adm_pass']),hex2bin($app->token)),PASSWORD_DEFAULT);
						$app->editUser($adminRecord['uuid'],'username',$_POST['adm_user']);
						$app->editUser($adminRecord['uuid'],'password',$passhash);
						$app->editUser($adminRecord['uuid'],'email',$_POST['adm_email']);
					}
					else{
						$app->addUser('director',$_POST['adm_user'],$app->decrypt(hex2bin($_POST['adm_pass']),hex2bin($app->token)),$_POST['adm_email'],0);
						$app->editUser(1,'icon_url',"{$app->homedir}/main/style/icons/anonymous.png");
					}
					$tabselect='Styling';
					$app->login($app->getUser(1));
					$app->installed=true;
				}
				else if (!$errfocus){
					$site_info_complete=false;
					if ((!isset($_POST['site_name']))||($_POST['site_name']=='')) $errfocus='site_name';
					else
					if ((!isset($_POST['auto_mail']))||($_POST['auto_mail']=='')) $errfocus='auto_mail';
					else
					if ((!isset($_POST['bucket']))||($_POST['bucket']=='')) $errfocus='bucket';
					else
					if (!isset($_POST['adm_email'])||($_POST['adm_email']==false)) $errfocus='adm_email';
					else
					if (!isset($_POST['adm_user'])||($_POST['adm_user']==false)) $errfocus='adm_user';
					else
					if (!isset($_POST['adm_pass'])||($_POST['adm_pass']==false)) $errfocus='adm_pass';
				}
			}
		}
	}
	else{
		$privelegeError='Only the website director can alter these settings.';
		$app->logCrack('Attempted to alter settings of director without sufficient privelege.');
	}































	//ICON DETECTION AND CREATION CODE
	$icon_error='';
	if ((!$installed)||($app->userPrivs('technical')>=0)){
		if (!$db_error){
			if (isset($_FILES['site_icon']['tmp_name'])&&($_FILES['site_icon']['tmp_name']!='')){
				if (!$errfocus) $tabselect='Styling';
				if ((isset($_POST['stform_token'])&&($_POST['stform_token']!=false))){
					$app->token=$_POST['stform_token'];
				}
				if (getimagesize($_FILES['site_icon']['tmp_name'])===false) $icon_error='No Image';
				else{
					if ($_FILES['site_icon']['size']>=1048576) $icon_error='File too large. File must be less that 1 megabyte.';
					else{
						if (!file_exists($app->homepath.'/main/style/favicons')){
							mkdir($app->homepath.'/main/style/favicons',0774,true);
							file_put_contents("{$app->homepath}/main/style/favicons/.htaccess","# Disable directory browsing\nOptions -Indexes\n");
						}
						$icon_extension=strtolower(pathinfo(basename($_FILES["site_icon"]["name"]),PATHINFO_EXTENSION));
						$icon_res=false;
						switch ($icon_extension){
							case 'jpg':
							case 'jpeg':	$icon_res=imagecreatefromjpeg($_FILES["site_icon"]["tmp_name"]); break;
							case 'gif':		$icon_res=imagecreatefromgif($_FILES["site_icon"]["tmp_name"]); break;
							case 'png':		$icon_res=imagecreatefrompng($_FILES["site_icon"]["tmp_name"]); break;
							case 'webp':	$icon_res=imagecreatefromwebp($_FILES["site_icon"]["tmp_name"]); break;
							case 'bmp':		$icon_res=imagecreatefrombmp($_FILES["site_icon"]["tmp_name"]); break;
							default: $icon_error='Image must be a gif, jpg, jpeg, png, webp or bmp.'; break;
						}
						if ($icon_res===false) $icon_error='File is corrupted!';
						else{
							if ( imagesx($icon_res) > imagesy($icon_res) ) $i0=imagescale($icon_res,512,-1,IMG_BICUBIC_FIXED);
							else $i0=imagescale($icon_res,512*(imagesx($icon_res)/imagesy($icon_res)),512,IMG_BICUBIC_FIXED);
							imagedestroy($icon_res);
							$i512=imagecreatetruecolor(512,512);
							imageSaveAlpha($i512,true);
							imagefill($i512,256,256,imagecolorallocatealpha($i512,0,0,0,127));
							imagecopy($i512,$i0,(512-imagesx($i0))/2,(512-imagesy($i0))/2,0,0,imagesx($i0),imagesy($i0));
							imagedestroy($i0);
							$homepath="{$app->homepath}/main/style/favicons";
							$md=true;
							if (!file_exists($homepath)) $md=mkdir($homepath,0777);
							if (!$md) $icon_error="Cannot write to <q>{$app->homepath}/main/style</q>. Must allow <q>Write Access</q> to <q>Other Users</q>. ";
							else{
								chmod($homepath,0777);
								if (file_exists($homepath.'/mainicon.png')) unlink($homepath.'/mainicon.png');
								imagepng($i512,$homepath.'/mainicon.png');
								$i0=imagescale($i512,512,512,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/android-chrome-512x512.png');imagedestroy($i0);
								$i0=imagescale($i512,310,310,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/ms-icon-310x310.png');imagedestroy($i0);
								$i0=imagescale($i512,192,192,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/android-chrome-192x192.png');imagedestroy($i0);
								$i0=imagescale($i512,192,192,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/android-icon-192x192.png');imagedestroy($i0);
								$i0=imagescale($i512,192,192,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/apple-icon.png');imagedestroy($i0); 
								$i0=imagescale($i512,180,180,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/apple-icon-180x180.png');imagedestroy($i0);
								$i0=imagescale($i512,180,180,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/apple-touch-icon.png');imagedestroy($i0); 
								$i0=imagescale($i512,152,152,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/apple-icon-152x152.png');imagedestroy($i0);
								$i0=imagescale($i512,150,150,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/ms-icon-150x150.png');imagedestroy($i0);
								$i0=imagescale($i512,144,144,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/android-icon-144x144.png');imagedestroy($i0);
								$i0=imagescale($i512,144,144,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/apple-icon-144x144.png');imagedestroy($i0);
								$i0=imagescale($i512,144,144,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/ms-icon-144x144.png');imagedestroy($i0);
								$i0=imagescale($i512,120,120,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/apple-icon-120x120.png');imagedestroy($i0);
								$i0=imagescale($i512,114,114,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/apple-icon-114x114.png');imagedestroy($i0);
								$i0=imagescale($i512,96,96,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/android-icon-96x96.png');imagedestroy($i0);
								$i0=imagescale($i512,96,96,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/favicon-96x96.png');imagedestroy($i0);
								$i0=imagescale($i512,76,76,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/apple-icon-76x76.png');imagedestroy($i0);
								$i0=imagescale($i512,72,72,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/android-icon-72x72.png');imagedestroy($i0);
								$i0=imagescale($i512,72,72,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/apple-icon-72x72.png');imagedestroy($i0);
								$i0=imagescale($i512,70,70,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/ms-icon-70x70.png');imagedestroy($i0);
								$i0=imagescale($i512,60,60,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/apple-icon-60x60.png');imagedestroy($i0);
								$i0=imagescale($i512,57,57,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/apple-icon-57x57.png');imagedestroy($i0);
								$i0=imagescale($i512,48,48,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/android-icon-48x48.png');imagedestroy($i0);
								$i0=imagescale($i512,36,36,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/android-icon-36x36.png');imagedestroy($i0);
								$i0=imagescale($i512,32,32,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/favicon-32x32.png');imagedestroy($i0);
								$i0=imagescale($i512,16,16,IMG_BICUBIC_FIXED);imagepng($i0,$homepath.'/favicon-16x16.png');imagedestroy($i0);
								$image_data=file_get_contents($homepath.'/favicon-16x16.png');$i0=pack('vvvCCCCvvVV',0,1,1,16,16,0,0,1,0,filesize($homepath.'/favicon-16x16.png'),22);$i0.=$image_data;
								file_put_contents($homepath.'/favicon.ico',$i0);
								if (!isset($_POST['site_icon_root'])) file_put_contents($app->homepath.'/favicon.ico',$i0);
								unset($image_data,$i0);
								imagedestroy($i512);
								file_put_contents("{$homepath}/browserconfig.xml","<"."?xml version='1.0' encoding='utf-8'?"."><browserconfig><msapplication><tile><square70x70logo src='{$app->homedir}/main/style/favicons/ms-icon-70x70.png'/><square144x144logo src='{$app->homedir}/main/style/favicons/ms-icon-144x144.png'/><square150x150logo src='{$app->homedir}/main/style/favicons/ms-icon-150x150.png'/><square310x310logo src='{$app->homedir}main/style/favicons/ms-icon-310x310.png'/><TileColor>#ffffff</TileColor></tile></msapplication></browserconfig>");
								file_put_contents("{$homepath}/IEconfig.xml","<"."?xml version='1.0' encoding='utf-8'"."?><browserconfig><msapplication><tile><square70x70logo src='{$app->homedir}/main/style/favicons/ms-icon-70x70.png'/><square144x144logo src='{$app->homedir}/main/style/favicons/ms-icon-144x144.png'/><square150x150logo src='{$app->homedir}/main/style/favicons/ms-icon-150x150.png'/><square310x310logo src='{$app->homedir}main/style/favicons/ms-icon-310x310.png'/><TileColor>#ffffff</TileColor></tile></msapplication></browserconfig>");
								file_put_contents("{$homepath}/site.webmanifest",'{"name":"","short_name":"","icons":[{"src":"'.$app->homedir.'/main/style/favicons/android-chrome-192x192.png","sizes":"192x192","type":"image/png"},{"src":"'.$app->homedir.'/main/style/favicons/android-chrome-512x512.png","sizes":"512x512","type":"image/png"}],"theme_color":"#ffffff","background_color":"#ffffff","display":"standalone"}');
								file_put_contents("{$homepath}/manifest.json",'{"name":"App","icons":[{"src": "'.$app->homedir.'/main\/style\/favicons\/android-icon-36x36.png","sizes": "36x36","type": "image\/png","density": "0.75"},{"src": "'.$app->homedir.'/main\/style\/favicons\/android-icon-48x48.png","sizes": "48x48","type": "image\/png","density": "1.0"},{"src": "'.$app->homedir.'/main\/style\/favicons\/android-icon-72x72.png","sizes": "72x72","type": "image\/png","density": "1.5"},{"src": "'.$app->homedir.'main\/style\/favicons\/android-icon-96x96.png","sizes": "96x96","type": "image\/png","density": "2.0"},{"src": "'.$app->homedir.'main\/style\/favicons\/android-icon-144x144.png","sizes": "144x144","type": "image\/png","density": "3.0"},{"src": "'.$app->homedir.'main\/style\/favicons\/android-icon-192x192.png","sizes": "192x192","type": "image\/png","density": "4.0"}]}');
								file_put_contents("{$homepath}/iconmeta.htm","
<link rel='icon' type='image/x-icon' sizes='16x16' href='{$app->homedir}/main/style/favicons/favicon.ico' />
<link rel='icon' type='image/png' sizes='96x96' href='{$app->homedir}/main/style/favicons/favicon-96x96.png' />
<link rel='icon' type='image/png' sizes='32x32' href='{$app->homedir}/main/style/favicons/favicon-32x32.png' />
<link rel='icon' type='image/png' sizes='16x16' href='{$app->homedir}/main/style/favicons/favicon-16x16.png' />
<link rel='icon' type='image/png' sizes='512x512' href='{$app->homedir}/main/style/favicons/android-chrome-512x512.png' />
<link rel='icon' type='image/png' sizes='192x192' href='{$app->homedir}/main/style/favicons/android-chrome-192x192.png' />
<link rel='icon' type='image/png' sizes='192x192' href='{$app->homedir}/main/style/favicons/android-icon-192x192.png' />
<link rel='icon' type='image/png' sizes='144x144' href='{$app->homedir}/main/style/favicons/android-icon-144x144.png' />
<link rel='icon' type='image/png' sizes='96x96' href='{$app->homedir}/main/style/favicons/android-icon-96x96.png' />
<link rel='icon' type='image/png' sizes='72x72' href='{$app->homedir}/main/style/favicons/android-icon-72x72.png' />
<link rel='icon' type='image/png' sizes='48x48' href='{$app->homedir}/main/style/favicons/android-icon-48x48.png' />
<link rel='icon' type='image/png' sizes='36x36' href='{$app->homedir}/main/style/favicons/android-icon-36x36.png' />
<link rel='apple-icon' type='image/png' sizes='192x192' href='{$app->homedir}main/style/favicons/apple-icon.png' />
<link rel='apple-touch-icon' type='image/png' sizes='180x180' href='{$app->homedir}/main/style/favicons/apple-icon-180x180.png' />
<link rel='apple-touch-icon' type='image/png' sizes='180x180' href='{$app->homedir}/main/style/favicons/apple-touch-icon.png' />
<link rel='apple-touch-icon' type='image/png' sizes='152x152' href='{$app->homedir}/main/style/favicons/apple-icon-152x152.png' />
<link rel='apple-touch-icon' type='image/png' sizes='144x144' href='{$app->homedir}/main/style/favicons/apple-icon-144x144.png' />
<link rel='apple-touch-icon' type='image/png' sizes='120x120' href='{$app->homedir}/main/style/favicons/apple-icon-120x120.png' />
<link rel='apple-touch-icon' type='image/png' sizes='114x114' href='{$app->homedir}/main/style/favicons/apple-icon-114x114.png' />
<link rel='apple-touch-icon' type='image/png' sizes='76x76' href='{$app->homedir}/main/style/favicons/apple-icon-76x76.png' />
<link rel='apple-touch-icon' type='image/png' sizes='72x72' href='{$app->homedir}/main/style/favicons/apple-icon-72x72.png' />
<link rel='apple-touch-icon' type='image/png' sizes='60x60' href='{$app->homedir}/main/style/favicons/apple-icon-60x60.png' />
<link rel='apple-touch-icon' type='image/png' sizes='57x57' href='{$app->homedir}/main/style/favicons/apple-icon-57x57.png' />
<meta name='msapplication-TileImage' content='{$app->homedir}/main/style/favicons/ms-icon-310x310.png' />
<meta name='msapplication-TileImage' content='{$app->homedir}/main/style/favicons/ms-icon-150x150.png' />
<meta name='msapplication-TileImage' content='{$app->homedir}/main/style/favicons/ms-icon-70x70.png' />
<meta name='msapplication-TileImage' content='{$app->homedir}/main/style/favicons/ms-icon-144x144.png' />
<meta name='msapplication-config' content='{$app->homedir}/main/style/favicons/browserconfig.xml' />
<meta name='msapplication-config' content='{$app->homedir}/main/style/favicons/IEconfig.xml' />
<link rel='manifest' href='{$app->homedir}/main/style/favicons/manifest.json' />
<link rel='manifest' href='{$app->homedir}/main/style/favicons/site.webmanifest' />
<meta name='msapplication-TileColor' content='#ffffff' />
<meta name='theme-color' content='#ffffff' />
");
							}
						}
					}
				}
				$icon_complete=false;
				if (file_exists($app->homepath.'/main/style/favicons/mainicon.png')) $icon_complete=true;
				else $errfocus='site_icon';
			}
		}
	}
	else{
		$privelegeError='Only someone with technical priveleges can alter these settings.';
		$app->logCrack('Attempted to alter technical priveleged settings without sufficient privelege.');
	}














	//REGISTRATIONS SETUP DETECTION AND CONFIGURATION
	if ((!$installed)||($app->userPrivs('technical')>=0)){
		if (isset($_POST['urform_submit'])&&($_POST['urform_submit']!=false)){
			if (!$errfocus) $tabselect='Registrations';
				if (
					(isset($_POST['urform_token'])&&($_POST['urform_token']!=false))
				){
					$app->settings['emailValidation']=isset($_POST['ss_evalid'])?'on':'';
					$app->settings['emailCompulsory']=isset($_POST['ss_email'])?'on':'';
					$app->settings['countryCompulsory']=isset($_POST['ss_country'])?'on':'';
					$app->settings['dobCompulsory']=isset($_POST['ss_dob'])?'on':'';
					$app->settings['min_age']=$_POST['ss_age'];
					$app->token=$_POST['urform_token'];
					file_put_contents("{$app->homepath}/main/scripts/config.json",json_encode($app->settings,true));
				}
		}
	}
	else{
		$privelegeError='Only someone with technical priveleges can alter these settings.';
		$app->logCrack('Attempted to alter technical priveleged settings without sufficient privelege.');
	}












	//PLUGIN SELECTION CONFIGURATION
	if ((!$installed)||($app->userPrivs('technical')>=0)){
		if (isset($_POST['piform_submit'])&&($_POST['piform_submit']!=false)){
			if (!$errfocus) $tabselect='Plugins';
			if (
				(isset($_POST['piform_token'])&&($_POST['piform_token']!=false))
			){
				if (!$app->settings['plugins']) $app->settings['plugins']=[];
				$app->token=$_POST['piform_token'];
				$pis=glob("{$app->homepath}/main/plugins/*",GLOB_ONLYDIR);
				foreach($pis as $pi){
					$piname=substr($pi,strrpos($pi,'/')+1);
					if (isset($_POST["pi_$piname"])){
						$pip=array_search($piname,$app->settings['plugins']);
						if (($pip===false)&&($_POST["pi_$piname"]==1)){
							if ($pip===false)	array_push($app->settings['plugins'],$piname);
						}
						else if (($pip!==false)&&($_POST["pi_$piname"]==0)){
							if ($pip!==false)	array_splice($app->settings['plugins'],$pip,1);
						}
					}
				}
				file_put_contents("{$app->homepath}/main/scripts/config.json",json_encode($app->settings,true));
			}
		}
	}
	else{
		$privelegeError='Only someone with technical priveleges can alter these settings.';
		$app->logCrack('Attempted to alter technical priveleged settings without sufficient privelege.');
	}




	$app->renderHead();
	$app->renderHeader();
	if (($installed)&&($app->userPrivs('technical')<0)){
?>
<article>
	<h1>Special Page</h1>
	<section class='center'>
		<h3>Website Settings</h3>
		<details class='help' ontoggle='app.resize();'>
			<summary>Help</summary>
			<div class='helpbox'>
				<h3>Accessing Website Settings</h3>
				<p>If you believe you should have the priveleges to access this part
				of the website but are unable to access this page properly then you
				should make sure that you are logged in under the correct account
				and if you still cannot access the settings, speak to either an
				administator or the director (or webmaster) to have them raise your
				privelege level to access this part of the website.
				</p>
			</div>
		</details>
			<div style='padding:0 1rem;text-align:left;'>
				<p>You must be logged in using an account with sufficient priveleges
				to alter the settings of the website.
				</p>
				<p>As a general rule, only users with technical priveleges can alter
				the settings of the website itself. This includes the website director
				(ie The Webmaster), administration staff and anyone who has been given
				technical priveleges to alter the website such that they may need to
				access these settings.
				</p>
				<p>Moderators, writers, affiliates and members with higher priveleges
				than ordinary members are, as a general rule, not permitted to alter
				the settings of the website itself, albeit that they may have an
				enhanced privelege level on other parts of the website.
				</p>
		</div>
	</section>
</article>
<?php
	}
	else{
		$app->tabstrip($tabselect,["Database","Information","Styling","Registrations","Plugins"]);
?>
	<script>
		function plugin_test(element,name){
			if (element.value==0) return;
			var xhr = new XMLHttpRequest();
			xhr.open("GET", <?php echo "'{$app->homedir}/main/plugins/'"; ?>+name+<?php echo "'/test.php'" ; ?>);
			xhr.onreadystatechange = function () {
				if (xhr.readyState === 4) {
					if (xhr.responseText=='1') element.value=1;
					else{
						element.value=0;
						element.nextElementSibling.style.color='red';
					}
				}
			};
			xhr.send();
		}
		function safepost_dbform(){
			var form=document.getElementById('dbform');	
			var token=document.getElementsByName('dbform_token')[0].value;
			var dbpw=document.getElementsByName('db_pass')[0];
			dbpw.value=app.encryptHex(dbpw.value,token);
			form.submit();
			dbpw.value=app.decryptHex(dbpw.value,token);
			return false;
		}
		function safepost_wsform(){
			var form=document.getElementById('wsform');	
			var token=document.getElementsByName('wsform_token')[0].value;
			var adpw=document.getElementsByName('adm_pass')[0];
			adpw.value=app.encryptHex(adpw.value,token);
			form.submit();
			adpw.value=app.decryptHex(adpw.value,token);
			return false;
		}
	</script>



















<article id='Database' class='tabbed'
	<?php if ($tabselect=='Database') echo "style='display:block;'"; ?>
>
	<h1>Database</h1>
	<section class='center'>
		<h3>Database Information</h3>
		<details class='help' ontoggle='app.resize();'>
			<summary>Help</summary>
			<div class='helpbox'>
				<h3>Hostname and Port</h3>
				<p>This application needs to connect to a MySql database server in
				order to work. You're hosting provider will provide you with the
				database <b><i>hostname</i></b> in the form of a domain name or an
				IP address. It is often set to <q>localhost</q>. Similarly, your
				hosting provider will also provide you with the <b><i>port</i></b>
				at which you by which to connect to the database server on the host
				at <b><i>hostname</i></b>. The default <b><i>port</i></b> for a
				MySql or MariaDB server is <q>3306</q> but it may differ depending
				on how your hosting provider has set it up. You should consult their
				help pages if you have problems working out what the right
				<b><i>hostname</i></b> and <b><i>port</i></b> are for you database
				server.
				</p>
				<h3>Database Name</h3>
	         <p>You will need create a new database on the database server using
	         cPanel, PhpMyAdmin or some other means provided by your hosting
	         provider. Sometimes a hosting provider will restrict you to a
				<b><i>Database Name</i></b> with a prefix such as <q>prefix_dbname</q>.
				You should enter the full <b><i>Database Name</i></b> including the
				prefix on this page. The <b><i>Database Name</i></b> should be
				something which will help you identify its purpose on your server
				such as <q>prefix_mainsite</q> or <q>prefix_ecommerce</q>.
				</p>
				<h3>Username and Password</h3>
				<p>You will also need to enter a username and password that this
				application can use to interact with the database. This can be a
				username and password provided by your host but is often a username
				and password created deliberately for this application. Your hosting
				provider will provide you with a username and password for
				the database server and/or provide you with a means to create new
				users and passwords for the database server.
				</p>
				</p>Make sure that the username has full access to the database. You
				should only create the databased and grant access to the appropriate
				username for this application. This username will then go about the
				business of creating/altering the database structure here at install
				or setup time.
				</p>
				<p>If you have access to aterminal through cPanel, ssh or some
				special page your hosting provider has created to allow you to
				interact with your hosts command line interface, the following
				script will create a new database and user with the default
				settings of this installation.
				</p>
				<p class='center'>
					<code>sudo mysql -e "create database gdsdb;grant all on gdsdb.* to 'gdsdbu'@'localhost' identified by 'dbpass';";</code>
				</p>
				<p>This can be undone from the mysql/mariadb database using the following code.
				</p>
				<p class='center'>
					<code>sudo mysql -e "drop database gdsdb;drop user 'gdsdbu'@'localhost';";</code>
				</p>
				<p>You may need to adjust the words <q>localhost</q>, <q>gdsdb</q>,
				<q>gdsdbu</q> and <q>dbpass</q> according to your own setup and
				preferences.
				</p>
			</div>
		</details>
		<?php if ($db_error){echo "<br/><p class='error'>$db_error</p>";}?>
      <form id='dbform' method='post' onsubmit='return safepost_dbform();'>
			<div class='aligner'>
				<h3>Hostname
					<input name='db_host' placeholder='DB Server Host URL or IP'
					   <?php
					      if (isset($_POST['db_host'])&&($_POST['db_host']!=false))
					         echo "value='{$_POST['db_host']}'";
						   else if (isset($app->settings['dbHost']))
						      echo "value='{$app->settings['dbHost']}'";
							if ($errfocus=='db_host') echo "autofocus='true'";
					   ?>
					/>
				</h3>
				<h3>Port					
					<input name='db_port' placeholder='DB Server Port (often 3306)'
						<?php
							if (isset($_POST['db_port'])&&($_POST['db_port']!=false))
								echo "value='{$_POST['db_port']}'";
							else if (isset($app->settings['dbPort']))
								echo "value='{$app->settings['dbPort']}'";
							if ($errfocus=='db_port') echo "autofocus='true'";
						?>
				/></h3>
				<h3>Database Name					
					<input name='db_name' placeholder='DB Name'
						<?php
							if (isset($_POST['db_name'])&&($_POST['db_name']!=false))
						 		echo "value='{$_POST['db_name']}'";
							else if (isset($app->settings['dbName']))
								echo "value='{$app->settings['dbName']}'";
							if ($errfocus=='db_name') echo "autofocus='true'";
						?>
				/></h3>
				<h3>Username					
					<input name='db_user' placeholder='DB User Username'
						<?php
							if (isset($_POST['db_user'])&&($_POST['db_user']!=false))
								echo "value='{$_POST['db_user']}'";	
							else if (isset($app->settings['dbUser']))
								echo "value='{$app->settings['dbUser']}'";
							if ($errfocus=='db_user') echo "autofocus='true'";
						?>
				/></h3>
				<h3>Password
					<input name='db_pass' type='password' placeholder='DB User Password'
						<?php
							if (isset($_POST['db_pass'])&&($_POST['db_pass']!=false))
								echo "value='".$app->decryptHex($_POST['db_pass'],$app->token)."'";
							else if (isset($app->settings['dbPass']))
								echo "value='{$app->settings['dbPass']}'";
							if ($errfocus=='db_pass') echo "autofocus='true'";
						?>
				/></h3>
			</div>
			<br/>
			<input type='hidden' name='dbform_token' value=<?php echo "'".($app->token)."'"; ?> />
			<input type='hidden' name='dbform_submit' value='true' />
			<input type='submit' value='Use These Settings' />
		</form>
	</section>
</article>































<article id='Information' class='tabbed'
	<?php if ($tabselect=='Information') echo "style='display:block;'"; ?>
>
	<h1>Website</h1>
	<section class='center'>
		<p></p>
		<details class='help' ontoggle='app.resize();'>
			<summary>Help</summary>
			<div class='helpbox'>
				<h3>Installation URL</h3>
				<p>This installation URL cannot be changed from here. This setting
				tells you where the application is currently installed at and it is
				the application these settings will affect. To change the place that
				the application is installed at, or to install and additional copy
				of the application to another subdirectory on your host, simply
				unzip the installation files to the subdirectory from which you want
				to server the application from.
				</p>
				<h3>Website Name</h3>
				<p>This is the title of the website. This name will be used in the
				header of all the pages on your website and may appear elsewhere on
				auto-generated pages where the title of the website is expected to
				appear.
				</p>
				<h3>Automailer</h3>
				<p>In some circumstances, the application will send an email to a
				user for such things as email address verification or to convey
				important information about their account. The email address in this
				field will be the email address on your server from which the emails
				will appear to be sent from and will be the email address that the
				recipient will reply to by default. Often the email address for an
				automailer is a <q>No Reply</q> address which implies that replies
				to the automailer will not be read as it is a machine which sends
				the emails rather than a human being such as might be described by
				the main email address in the next section.
				</p>
				<h3>Bucket</h3>
				<p>The bucket is a folder used to store static content such as music
				or images that a page might employ. Any data which is not the page
				itself but used by pages is stored here to save clutter on the pages
				folder. It a place to store frivolous content which does not have
				the same importance as the content stored in the static folder. The
				files in the bucket folder will in a future release be serve from a
				content delivery network (CDN) and some thought should be given as
				to whether a file is <q>must have already</q> content or content
				that users will not mind waiting for. For example, the avatars of
				all the users on your site would be perfect content to throw in a
				bucket, whereas the front page background image is something that
				could make your site look ugly if it loads much later than the rest
				of the page requiring that background image to look right.
				</p>
				<h3>Main Account</h3>
				<p>The main account is central to the functioning of the application.
				Through this account, other less priveleged acccounts can be created
				including those which are almost as powerful as the main account but
				can be created and deleted only by the main account holder.
				</p>
				<p>A username and password are <em>REQUIRED</em> and the email
				address will be used as contact information should someone wish to
				get in touch with the webmaster of the site.
				</p>
				<h3>Update Sitemap</h3>
				<p>The Update Sitemap button will cause the Sitemap.xml file on the
				server's www-root directory to be updated with the latest information
				about this application's publicly visible pages. These include the
				index page for the folder this application is installed on, as well
				as the copyright notice and privacy page but it will also list all
				of the pages that have been created in the <q>/yourapp/main/pages</q>
				subdirectory.
				</p>
			</div>
		</details>
		<p></p>
		<div class='aligner'>
			<h3 class='center'>The Application is installed at:
				<div style='border:var(--pixel) dashed	var(--section-fg);border-radius:var(--medium-round);padding:var(--medium-round);margin:var(--medium-round);'>
					<?php echo $app->homeurl; ?>
				</div>
			</h3>
		</div>
		<form method='post'>
			<input type='hidden' name='smuform_token' value=<?php echo "'".($app->token)."'"; ?> />
			<input type='hidden' name='smuform_submit' value='true' />
			<input type='submit' value='Update Sitemap' />
		</form>
		<br/>
		<h3>Website Information</h3>
		<?php if (!$site_info_complete){echo "<br/><p class='error'>Please Complete Form</p>";}?>
      <form id='wsform' method='post' onsubmit='return safepost_wsform();'>
			<div class='aligner'>
				<h3 title='The Title of this Website.'>Website Name
         		<input name='site_name' placeholder='example.com'
	               <?php
	               	if (isset($_POST['site_name'])&&($_POST['site_name']!=false))
	               		echo "value='{$_POST['site_name']}'";
							else //if ($app->installed)
								echo "value='{$app->settings['sitename']}'";
							if ($errfocus=='site_name') echo "autofocus='true'";
						?>

					/>
				</h3>
				<h3 title='Verification Emails will be Sent from Here'>Automailer
					<input name='auto_mail' type='email' placeholder='noreply@example.com'
						<?php
							if (isset($_POST['auto_mail'])&&($_POST['auto_mail']!=false))
								echo "value='{$_POST['auto_mail']}'";
							else //if ($app->installed)
								echo "value='{$app->settings['automail']}'";
							if ($errfocus=='auto_mail') echo "autofocus='true'";
						?>
					/>
         	</h3>
				<h3 title='CDN Bucket or Upload Folder'>File Bucket			
					<input name='bucket' placeholder='File Bucket URL'
						<?php
							if (isset($_POST['bucket'])&&($_POST['bucket']!=false))
								echo "value='{$_POST['bucket']}'";
							else //if ($app->installed)
								echo "value='{$app->settings['bucket']}'";
						?>
					/>
         	</h3>
			</div>
			<h3>Main Account</h3>
			<div class='aligner'>
           	<h3>Email Address					
	           	<input name='adm_email' type='email' placeholder='webmaster@example.com'
	           		<?php
							if (isset($_POST['adm_email'])&&($_POST['adm_email']!=false))
								echo "value='{$_POST['adm_email']}'";
							else //if ($app->installed)
								echo "value='{$app->settings['mainmail']}'";
							if ($errfocus=='adm_email') echo "autofocus='true'";
				   	?>
					/>
         	</h3>
				<h3>Username					
					<input name='adm_user' placeholder='Directors Username'
						<?php
							if (isset($_POST['adm_user'])&&($_POST['adm_user']!=false))
								echo "value='{$_POST['adm_user']}'";	
							else
								echo "value='admin'";
							if ($errfocus=='adm_user') echo "autofocus='true'";
						?>
					/>
				</h3>
				<h3>Password
					<input name='adm_pass' type='password' placeholder='Directors Password'
						<?php
							if (isset($_POST['adm_pass'])&&($_POST['adm_pass']!=false))
								echo "value='".$app->decrypt(hex2bin($_POST['adm_pass']),hex2bin($app->token))."'";
							if ($errfocus=='adm_pass') echo "autofocus='true'";
						?>
					/>
				</h3>
			</div>
			<br/>
			<input type='hidden' name='wsform_token' value=<?php echo "'".($app->token)."'"; ?> />
			<input type='hidden' name='wsform_submit' value='true' />
			<input type='submit' value='Use These Settings' />
		</form>
	</section>
</article>




























<article id='Styling' class='tabbed'
	<?php if ($tabselect=='Styling') echo "style='display:block;'"; ?>
>
	<h1>Styling</h1>
	<section class='center'>
		<h3>Website Style</h3>
		<details class='help' ontoggle='app.resize();'>
			<summary>Help</summary>
			<div class='helpbox'>
				<h3>Icon</h3>
				<p>Upload an icon from your local storage devide by clicking on the
				file browser button and selecting an image file to use as the icon
				for the website. Images of any dimensions can be used but the overall
				size of the image file must be less than 1 megabyte. The application
				only supports image types of <q>jpg</q>, <q>jpeg</q>, <q>gif</q>,
				<q>png</q>, <q>webp</q> and <q>bmp</q>.
				</p>
				<p>Setting the icon will cause icons to be created for all common
				uses of site icons including desktop icons, smartphone icons, start
				menu icons as well as the webserver favicon and a set of favicons
				in various resolutions for your site. The favicon will appear in
				the browser window or tab next a the title of pages on your website.
				</p>
				<h3>Favicon for Root</h3>
				<p>The traditional place to put a favicon was in the root of your
				web server. This meant that if you hosted different applications
				under different subdirectoris on your websever that the same favicon
				would be used for all applications on the webserver.
				</p>
				<p>The Gartbeth Digital Services Web Application can be installed
				as multiple instances on various subdirectories of your webserver
				and you may want to have a favicon only appear for the application
				which is at the public root of your webserver and not to alter that
				when installing this application as a sub-application which can be
				accessed from the application which occurs at (for example)
				<q>www.example.com/index.html</q>. By checking the box to suppress
				favicon for root, no favicon will be created for <q>www.example.com</q>
				but favicons will be created for the application you could be installing
				now at (for example) <q>www.example.com/auranos/</q>.
				</p>
			</div>
		</details>
		<form id='mainform' enctype='multipart/form-data' method='post'>
			<div class='aligner'>
				<div style='display:inline-block; padding:1rem 0;'>
					<?php
						if (file_exists("{$app->homepath}/main/style/favicons/mainicon.png"))
							echo "<img src='{$app->homedir}/main/style/favicons/mainicon.png' style='height:4.5rem;padding:0.25rem;' />";
					?>
				</div>

				<div style='display:inline-block;vertical-align:top; padding:1rem 0;'>
					<h3>Site Icon
						<input name='site_icon' type='file' />
					</h3>

					<h3 title="Suppress placing a favicon image on the www-root folder.">
						<p>
						No Favicon for www-root
						<input name='site_icon_root' type='checkbox'
						<?php
							if (isset($_POST['site_icon_root']))
								echo ' checked';
						?>
						/>
						</p>
					</h3>
				</div>
			</div>
			<?php if ($icon_error!==''){echo "<br/><b class='error'>$icon_error</b><br/>";} ?>
			<br />
			<input type='hidden' name='stform_token' value=<?php echo "'".($app->token)."'"; ?> />
			<input type='hidden' name='stform_submit' value='true' />
			
			<input type='submit' value='Use These Settings' />
		</form>
	</section>
</article>

































<article id='Registrations' class='tabbed'
	<?php if ($tabselect=='Registrations') echo "style='display:block;'"; ?>
>
	<h1>Registrations</h1>
	<section class='center'>
		<h3>New User Signups</h3>
		<details class='help' ontoggle='app.resize();'>
			<summary>Help</summary>
			<div class='helpbox'>
				<p>These settings are the mandatory requirements of new signups. You
				can use these settings to make certain fields a requirement for new
				signups.
				</p>
				<h3>Email and Email Validation</h3>
				<p>Requiring Email validation will prevent users from participating
				on the site until they respond to an email which the application
				will send to the specified email account. For email validation to
				function, the application will automatically set email as a required
				field.
				</p>
				<p>However, you can operate the application without requiring email
				validation but insisting that all users provide an email address so
				they can register a membership to the site. This can be useful if
				you are on a server which does not support <q>sendmail</q>. You can
				also use the application in such a way that emails aren't required
				at all.
				</p>
				<h3>Country</h3>
				<p>You can make it compulsory that new users provide their real the
				country they live in (or where they are from).
	         </p>
				<h3>Minumum Age</h3>
	         <p>You can mandate that mew users provide their data of birth. This
	         may be for the purposes of letting other users view their profiles
	         but it can also be used in combination with the minimumum age field
	         which can be used to restrict certain content on your website such
	         that only users over a certain age can see that content intended for
	         adults exists.
	         </p>
	         <p>A minumum age of <q>0</q> suggests there are no age restrictions.
	         </p>
			</div>
		</details>
  		<script>
			function syncEmailSiteSettings(calltype){
				if ((calltype==='v') && (document.getElementsByName("ss_evalid")[0].checked))
					document.getElementsByName("ss_email")[0].checked=true;
				if ((calltype==='e') && (!document.getElementsByName("ss_email")[0].checked))
					document.getElementsByName("ss_evalid")[0].checked=false;
			}
		</script>
		<form id='urform' method='post'>
			<div class='aligner'>

				<h3>Email Validation Required
					<input name='ss_evalid' type='checkbox' onclick='syncEmailSiteSettings("v");' title='User must click a link sent by email'
						<?php
							if (isset($_POST['ss_evalid'])&&($_POST['ss_evalid']=='on'))
								echo "checked='checked'";
							else if (isset($app->settings['emailValidation']))
								if ($app->settings['emailValidation']) echo "checked='checked'";
						?>
					/>
				</h3>
				<h3>Email Required
					<input name='ss_email' type='checkbox' onclick='syncEmailSiteSettings("e");'
						<?php
							if (isset($_POST['ss_email'])&&($_POST['ss_email']=='on'))
								echo "checked='checked'";
							else if (isset($app->settings['emailCompulsory']))
								if ($app->settings['emailCompulsory']) echo "checked='checked'";
						?>
					/>
				</h3>
				<h3>Country Required
					<input name='ss_country' type='checkbox' 
						<?php
							if (isset($_POST['ss_country'])&&($_POST['ss_country']=='on'))
								echo "checked='checked'";
							else if (isset($app->settings['countryCompulsory']))
 								if ($app->settings['countryCompulsory']!=false)
									echo "checked='checked'";
						?>
					/>
				</h3>
				<h3>Date of Birth Required
					<input name='ss_dob' type='checkbox' 
						<?php
							if (isset($_POST['ss_dob'])&&($_POST['ss_dob']=='on'))
								echo "checked='on'";
							else if (isset($app->settings['dobCompulsory']))
								if ($app->settings['dobCompulsory']!=false)
									echo "checked='checked'";
						?>
					/>
				</h3>
				<h3>Minimum Age
					<input name='ss_age' type='number' min='0' onclick="document.getElementsByName('ss_dob')[0].checked='on';"
						<?php
							if (isset($_POST['ss_age']))
								echo "value={$_POST['ss_age']}";
							else if (isset($app->settings['min_age']))
								echo "value={$app->settings['min_age']}";
						?>
					/>
				</h3>
			</div>
			<br/>
			<input type='hidden' name='urform_token' value=<?php echo "'".($app->token)."'"; ?> />
			<input type='hidden' name='urform_submit' value='true' />
			<input type='submit' value='Use These Settings' />
		</form>
	</section>
</article>





















<article id='Plugins' class='tabbed'
	<?php if ($tabselect=='Plugins') echo "style='display:block;'"; ?>
>
	<h1>Plugins</h1>
	<section class='center'>
		<h3>Enable and Configure Plugins</h3>
		<details class='help' ontoggle='app.resize();'>
			<summary>Help</summary>
			<div class='helpbox'>
				<p>These settings allow you to enable or disable plugins and set
				their configuration.
				</p>
			</div>
		</details>
		<form id='piform' method='post'>
			<div class='aligner'>
				<?php
					$pis=glob($app->homepath.'/main/plugins/*',GLOB_ONLYDIR);
					foreach($pis as $pi){
						$piname=substr($pi,strrpos($pi,'/')+1);
						echo "<h3>$piname<input name='pi_$piname' class='boolean' type='range' min='0' max='1' onchange='plugin_test(this,\"$piname\");' ";
						if ((isset($app->settings['plugins']))&&
							(array_search($piname,$app->settings['plugins'])!==false))
							echo "value='1' />";
						else
							echo "value='0' />";
						echo " <a href='{$app->homedir}/main/plugins/$piname/setup.php'>Setup</a>";
						echo "</h3>";
					}
				?>
			</div>
			<br/>
			<input type='hidden' name='piform_token' value=<?php echo "'".($app->token)."'"; ?> />
			<input type='hidden' name='piform_submit' value='true' />
			<input type='submit' value='Use These Settings' />
		</form>
	</section>
</article>














<?php
	}
	$app->renderFooter();
	$app->renderTail();
?>


