<?php





	/******************************************\
	* Web Application 6.0 by SCFDuffy (C) 2022 *
	* ---------------------------------------- ********************\
	* SCFDuffy retains the absolute copyright on this source code. *
	* This includes portions written in PHP, SQL, CSS, Javascript, *
	* HTML and any prosaic writings contained in this file. It may *
	* not be copied, clipped, modified or published in whole or in *
	* part without the expressed prior consent of SCFDuffy. These  *
	* rights of copy are retained to the fullest extent applicable *
	* in law. All Rights Reserved. (C) Copyright SCFDuffy 2021 (C) *
	* ------------------------------------------------------------ *
	* Web Application 6.0 written by SCFDuffy        (C) July 2022 *
	\**************************************************************/






	$homepath=dirname($_SERVER['SCRIPT_NAME']);
	$homepath=($homepath=='/')?$_SERVER['DOCUMENT_ROOT']:$_SERVER['DOCUMENT_ROOT'].$homepath;
	while (!file_exists($homepath.'/main')) $homepath=dirname(substr($homepath,0,-1));
	require_once("$homepath/main/classes/Application.php");

	include("{$app->homepath}/main/scripts/pregs.php");
	
	$at=false; $ru=false; $rp=false; $rc=false; $re=false; $rn=false; $rf=false; $rl=false; $rg=false; $rd=false; $ra=false; $success=false;
	$ruerr=''; $rperr=''; $rcerr=''; $reerr=false; $rnerr=false; $rferr=false; $rlerr=false; $rgerr=false; $rderr=false; $raerr=false;
	$focus='ru'; $success=false;

	if (isset($_POST['token'])&&($_POST['token']!=false))
		$at=$_POST['token'];
	if (isset($_POST['ru'])&&($_POST['ru']!=false))
		$ru=$app->decryptHex($_POST['ru'],$app->token);
	if (isset($_POST['rp'])&&($_POST['rp']!=false))
		$rp=$app->decryptHex($_POST['rp'],$app->token);
	if (isset($_POST['rc'])&&($_POST['rc']!=false))
		$rc=$app->decryptHex($_POST['rc'],$app->token);
	if (isset($_POST['re'])&&($_POST['re']!=false))
		$re=$app->decryptHex($_POST['re'],$app->token);
	if (isset($_POST['rn'])&&($_POST['rn']!=false))
		$rn=$app->decryptHex($_POST['rn'],$app->token);
	if (isset($_POST['rd'])&&($_POST['rd']!=false))
		$rd=$app->decryptHex($_POST['rd'],$app->token);
	if (isset($_POST['ra'])&&($_POST['ra']!=false))
		$ra=$_POST['ra'];

	if ($at){
		if (!$ru) $ruerr='You must supply a username';
		else {
			if (preg_match($pregs['username'],$ru)===0) $ruerr='Invalid Username';
			else{
				$focus='rp';
				if (!$rp) $rperr='You must supply a password';
				else {
					if (preg_match($pregs['password'],$rp)===0) $rperr='Invalid Password';
					else{
						$focus='rc';
						if (!$rc) $rcerr='Retype the password to confirm its correct';
						else if ($rc!==$rp) $rcerr='The password and confirmation don`t match';
						else {
							$focus='re';
							if ((!$re)&&(($app->settings['emailCompulsory']=='on')||($app->settings['emailValidation']))){
								if ($app->settings['emailValidation']=='on') $reerr='An email address is needed for validation';
								else if ($app->settings['emailCompulsory']=='on') $reerr='All accounts must have an email address';
							}
							else {
								if (($re!='')&&(preg_match($pregs['email'],$re)===0)) $reerr='Invalid Email Address';
								else if (($re!='')&&($app->getUserByQuery("email='$re'"))) $reerr="There is already an account associated with this email address<br/>You can reset it using the <a href='{$app->homedir}main/special/recover.php'>Recovery Page</a>";								
								else{
									if ((!$rn)&&($app->settings['countryCompulsory']=='on')) $rnerr='All accounts must have a country';
									else{
										$focus='rf';
										if ((!$rf)&&($app->settings['nameCompulsory']=='on')) $rferr='You must provide your first name';
										else {
											if (($rf!='')&&(preg_match($pregs['name'],$rf)===0)) $rferr='Invalid Name';
											else{
												$focus='rl';
												if ((!$rl)&&($app->settings['nameCompulsory']=='on')) $rlerr='You must provide your last name';
												else {
													if (($rl!='')&&(preg_match($pregs['name'],$rl)===0)) $rlerr='Invalid Name';
													else{
														$focus='rg';
														if ((!$rg)&&($app->settings['genderCompulsory']=='on')) $rgerr='You must provide your gender';
														else {
															$focus='rd';
															if ((!$rd)&&($app->settings['dobCompulsory']=='on')) $rderr='You must provide a date of birth';
															else {
																if (($rd!='')&&(preg_match($pregs['dob'],$rd)===0)) $rderr='Invalid Date';
																else{
																	if ((time()-strtotime($rd))/31557600 < $app->settings['min_age']) $rderr='This site is not suitable for your age group.';
																	else{	//the date of birth is within constraints
																		$focus='ra';
																		if (!$ra) $raerr='Agree to the Terms and Conditions';
																		else {
																			$record=$app->getUserByQuery("username='$ru'");
																			if ($record!==false){
																				$focus='ru';
																				$ruerr='Username not available';
																			}
																			else{
																				unset($record);
																				if ($app->settings['emailValidation']){
																					$ev=rand(100000000,999999999);
																					$token=bin2hex(random_bytes(32));
																					$code=$app->encryptHex($re."\n".$ev,$token);
																					$mailbody=
"Hello $ru!,

This is an automated email from {$app->settings['sitename']}.

We recently received a sign up for a new membership using this email address for
the new account. We are sending this email so you can validate your account with
our website.

To validate your account now, click or copy and paste the following link into a
browser:

<a href='{$app->homeurl}/main/special/validate.php?id=$code&t=$token'>

	{$app->homeurl}/main/special/validate.php?id=$code&t=$token

</a>

If you did not sign up with {$app->settings['sitename']}, you have received this email in
error and you can ignore it. We are sorry for any inconvenience.

Thankyou from {$app->settings['sitename']}.
";
																					$app->automailer($re,$app->settings['sitename'].' Email Validation',$mailbody);
																					$success='validation';
																				}
																				else{
																					$ev=0;
																					$success=true;
																				}
																				$app->addUser('member',$ru,$rp,$re,$ev,$rf,$rl,$rn,$rg,$rd);
																				$newuser=$app->getUserByQuery("username='$ru'");
																				$app->editUser($newuser['uuid'],'icon_url',$app->homeurl.'/main/style/icons/anonymous.png');
																				if (!$app->settings['emailValidation']) $app->login($newuser);
																			}
																		}
																	}
																}
															}
														}
													}
												}					
											}
										}					
									}
								}
							}					
						}
					}
				}
			}
		}
	}
	if ($success===true){
?>
<!doctype html>



	<html><body onload="parent.app.closeFrameReload('dialogue');"></body></html>



<?php } else {
	$app->renderHead("Signup - {$app->settings['sitename']}",'SCFDuffy','Signup, register, join, membership, account, enroll, member, application, apply, invite, invitation',"Signup page for {$app->settings['sitename']}");
	$app->renderHead();
?>

<style>
	body{background:none;}
	table{position:fixed;width:100%;height:100%;table-layout:auto;text-align:center;}
	article{text-align:center;display:inline-block;border:0.125rem outset #ccc;}
	section{text-align:right;display:block;border:none;}
	.error{color:red;text-align:center;font-size:1rem;padding-top:0; margin-top:0;}
	p{text-align:right;}
</style>
<script>
	function ignoreClick(ev){ev.cancelBubble=true;} //clicking on the dialogue itself doesnt close the signup screen
	function keyHandler(e){if (e.code==='Escape') closeFrame();}
	function closeFrame(){
		document.removeEventListener('keyup',keyHandler);
		document.getElementById('dialogue').removeEventListener('click',ignoreClick);
		document.body.removeEventListener('click',closeFrame);
		parent.app.closeFrame('dialogue');
	}
	function safepost(){
		var form=document.getElementById('mainform');	
		var token=document.getElementsByName('token')[0].value;
		var ru=document.getElementsByName('ru')[0];
		var rp=document.getElementsByName('rp')[0];
		var rc=document.getElementsByName('rc')[0];
		var re=document.getElementsByName('re')[0];
		var rns=document.getElementById('rns');
		var rn=document.getElementsByName('rn')[0]; rn.value=rns.options[rns.selectedIndex].text;
		var rds=document.getElementById('rds');
		var rd=document.getElementsByName('rd')[0]; rd.value=rds.value;
		ru.value=app.encryptHex(ru.value,token);
		rp.value=app.encryptHex(rp.value,token);
		rc.value=app.encryptHex(rc.value,token);
		re.value=app.encryptHex(re.value,token);
		rn.value=app.encryptHex(rn.value,token);
		rd.value=app.encryptHex(rd.value,token);
		form.submit();
		ru.value=app.decryptHex(ru.value,token);
		rp.value=app.decryptHex(rp.value,token);
		rc.value=app.decryptHex(rc.value,token);
		re.value=app.decryptHex(re.value,token);
		rn.value=app.decryptHex(rn.value,token);
		rd.value=app.decryptHex(rd.value,token);
		return false;
	}
	function init(){
		app=new Website();
		document.body.addEventListener('click',closeFrame);
		document.getElementById('dialogue').addEventListener('click',ignoreClick);
		document.addEventListener('keyup',keyHandler);
		document.getElementsByName('<?php echo $focus; ?>')[0].focus();

	}
</script>
	<table class='middle'>
	<tr><td></td><td>
		<article id='dialogue'>

			<h1>Signup</h1>


<?php if ($success==='validation') { ?>


			<section style='text-align:center;'>
				<h3>Email Validation</h3>
				<p>Your account has been created.</p>
				<p>An email has been sent to:</p>
				<p><?php echo $app->decryptHex($_POST['re'],$app->token); ?></p>
				<p>You must validate this email to login.
				</p>
				<input type='button' value='okay' onclick='closeFrame();' />
			</section>


<?php } else { ?>


			<section>
				<form id='mainform' method='post' onsubmit='return safepost();' autocomplete='off'>

					<p>Username*		
					<input name='ru' placeholder='Choose a Username'
						<?php
							if (isset($_POST['ru'])&&($_POST['ru']!=false))
								echo "value='".$app->decryptHex($_POST['ru'],$app->token)."'";
//else echo "value='user'";
						?>
					/>
					<?php if ($ruerr) echo "<div class='error'>$ruerr</div>"; ?>
					</p>
					
					<p>Password*
					<input name='rp' type='password' placeholder='Set a Password'
						<?php
							if (isset($_POST['rp'])&&($_POST['rp']!=false))
								echo "value='".$app->decryptHex($_POST['rp'],$app->token)."'";
//else echo "value='pass'";
						?>
					/>
					<?php if ($rperr) echo "<div class='error'>$rperr</div>"; ?>
					</p>

					<p>Confirm Password*
					<input name='rc' type='password' placeholder='Retype Password'
						<?php
							if (isset($_POST['rc'])&&($_POST['rc']!=false))
								echo "value='".$app->decryptHex($_POST['rc'],$app->token)."'";
//else echo "value='pass'";
						?>
					/>
					<?php if ($rcerr) echo "<div class='error'>$rcerr</div>"; ?>
					</p>

					<p>Email Address<?php if (($app->settings['emailCompulsory'])||($app->settings['emailValidation'])) echo '*'; ?>

					<input name='re' type='email' placeholder='Enter Your Email Address'
						<?php
							if (isset($_POST['re'])&&($_POST['re']!=false))
								echo "value='".$app->decryptHex($_POST['re'],$app->token)."'";
//else echo "value='root@spock'";
						?>
					/>
					<?php if ($reerr) echo "<div class='error'>$reerr</div>"; ?>
					</p>





					<p>Country<?php if ($app->settings['countryCompulsory']) echo '*'; ?>
	
					<?php
						if (isset($_POST['rn'])&&($_POST['rn']!=false))
							$countrySelected=$app->decryptHex($_POST['rn'],$app->token); else $countrySelected='';
					?>
					<select id='rns'>
						<?php
							echo "<option value=''></option>";
							$countryList=explode("\n",file_get_contents("{$app->homepath}/main/scripts/countries.list"));
							foreach ($countryList as $country){
								if ($country===$countrySelected) $selected="selected='true'"; else $selected='';
								echo "<option value='$country' $selected>$country</option>";
							}
						?>
					</select>
					<input name='rn' type='hidden' value='<?php echo $countrySelected; ?>' />
					<?php if ($rnerr) echo "<div class='error'>$rnerr</div>"; ?>
					</p>



					<p>Date of Birth<?php if ($app->settings['dobCompulsory']) echo '*'; ?>
					<input id='rds' type='date' placeholder='Date of Birth?'
						<?php
							if (isset($_POST['rd'])&&($_POST['rd']!=false))
								echo "value='".$app->decryptHex($_POST['rd'],$app->token)."'";
						?>
					/>
					<input name='rd' type='hidden' value='<?php echo $dobValue; ?>' />
					<?php if ($rderr) echo "<div class='error'>$rderr</div>"; ?>
					</p>

					<p class='center'>I agree to the <a href='<?php echo "{$app->homedir}/main/pages/terms.php"; ?>'>Terms and Conditions</a>*
					<input name='ra' type='checkbox'
						<?php
							if (isset($_POST['ra'])&&($_POST['ra']!=false))
								echo "checked='".$_POST['ra']."'";
						?>
					/>
					<?php if ($raerr) echo "<div class='error'>$raerr</div>"; ?>
					</p>

					<p class='center'>
						<input type='button' value='cancel' onclick='closeFrame();' />
						<input type='submit' value='signup' />
					</p>

					<input type='hidden' name='token' value='<?php echo $app->token; ?>' />
				</form>
			</section>
			<p class='center'>Fields marked with * are compulsory.</p>
<?php } ?>
		</article>
	</td><td></td></tr>
	</table>
<?php
	$app->renderTail();
} ?>
